/*********************************************************************\

	File   		:	dlxm_scan

	Date		:	15 12 1993
	Version		:	1

\*********************************************************************/


/*---------------------------------------------------------\
                     Includes
\---------------------------------------------------------*/
#include <mut315.h>
#include <stdio.h>
#include <genpat.h>

/*---------------------------------------------------------\
                     defines
\---------------------------------------------------------*/
#define maxcycle  482 

/*---------------------------------------------------------\
                     Global variables
\---------------------------------------------------------*/
char scin[33];
int  l;

/*---------------------------------------------------------\
                     inttostr
\---------------------------------------------------------*/
char *inttostr(integer, len)
  int integer;
  int len;
{
 char *str;

 str = (char *) mbkalloc (len * sizeof (char) + 1);
 sprintf (str, "%.32d", integer);
 return(&str[32-len]);
}

/*---------------------------------------------------------\
                     clock
\---------------------------------------------------------*/
void clock()
{
 int i;

 for (i=0;i < (maxcycle*3);i=i+3)
 {  
  AFFECT(inttostr(i,32),"ck","0b0");
  AFFECT(inttostr(i+1,32),"ck","0b1");
  AFFECT(inttostr(i+2,32),"ck","0b0");
 }
}

/*---------------------------------------------------------\
                     init_it
\---------------------------------------------------------*/
void init_it()
{
 AFFECT(inttostr(0,32),"it","0o0");
}

/*---------------------------------------------------------\
                     power
\---------------------------------------------------------*/
void power()
{
 AFFECT(inttostr(0,32),"vdd","0b1");
 AFFECT(inttostr(0,32),"vss","0b0");
}

/*---------------------------------------------------------\
                     mode_test
\---------------------------------------------------------*/
void mode_test(cycle)
  int cycle;
{
 AFFECT(inttostr(cycle,32),"frz","0b0");
 AFFECT(inttostr(cycle,32),"test","0b1");
 AFFECT(inttostr(cycle+1,32),"test","0b1");
 AFFECT(inttostr(cycle+2,32),"test","0b1");
}

/*---------------------------------------------------------\
                     mode_normal
\---------------------------------------------------------*/
void mode_normal(cycle,nc)
  int cycle;
  int nc;
{
 int i;

 for (i=0;i<nc*3;i=i+3)
 {
  AFFECT(inttostr(cycle,32),"test","0b0");
  AFFECT(inttostr(cycle+1,32),"test","0b0");
  AFFECT(inttostr(cycle+2,32),"test","0b0");
  cycle+=3;
 }
}

/*---------------------------------------------------------\
                     get_bin
\---------------------------------------------------------*/
void get_bin(string)
  char *string;
{
 int i,n;
 char bin[5];
 l=strlen(string);
 strcpy(scin,"");
 strcpy(bin,"");

 for(i=0;i<l;i++)
 {
  switch (string[i])
  {
   case '0':strcpy(bin,"0000");break;
   case '1':strcpy(bin,"0001");break;
   case '2':strcpy(bin,"0010");break;
   case '3':strcpy(bin,"0011");break;
   case '4':strcpy(bin,"0100");break;
   case '5':strcpy(bin,"0101");break;
   case '6':strcpy(bin,"0110");break;
   case '7':strcpy(bin,"0111");break;
   case '8':strcpy(bin,"1000");break;
   case '9':strcpy(bin,"1001");break;
   case 'a':strcpy(bin,"1010");break;
   case 'b':strcpy(bin,"1011");break;
   case 'c':strcpy(bin,"1100");break;
   case 'd':strcpy(bin,"1101");break;
   case 'e':strcpy(bin,"1110");break;
   case 'f':strcpy(bin,"1111");break;
  }
  strcat(scin,bin) ;
 }
}

/*---------------------------------------------------------\
                     set_val
\---------------------------------------------------------*/
void set_val(cycle,val_reg)
  int cycle;
  char *val_reg;
{
 int i;
 char st[5];

 strcpy(st,"0b ");
 get_bin(val_reg);
 for (i=0;i<l*4;i++)
 {
  st[2]=scin[i];
  AFFECT(inttostr(cycle,32),"scin",st);
  AFFECT(inttostr(cycle+1,32),"scin",st);
  AFFECT(inttostr(cycle+2,32),"scin",st);
  cycle+=3;
 }
}

/*---------------------------------------------------------\
                     main
\---------------------------------------------------------*/
int main()
{
  int i,j,cpat;

 /* Declaring name of pattern file */
 DEF_GENPAT("dlxm_scan");

  /* interface declararion */
 DECLAR("ck",":1","B",IN,"");
 DECLAR("test",":1","B",IN,"");
 DECLAR("scin",":1","B",IN,"");
 DECLAR("frz",":1","B",IN,"");
 DECLAR("it",":1","o",IN,"2 downto 0");
 
 /*DECLAR("rw",":1","B",INOUT,"");*/
 
 DECLAR("data_adr",":1","x",INOUT,"31 downto 0");
 
 DECLAR("data",":1","x",INOUT,"31 downto 0");
 
 DECLAR("scout",":1","B",OUT,"");

 DECLAR("vdd",":0","B",IN,"");
 DECLAR("vss",":0","B",IN,"");


 /* initilisation of the clock, vdd, vss, and it */
 clock();
 init_it();
 power();

 /* Test mode, loading scan-path */
 mode_test(0);
 /* encoding ifetch state for initial state */
 set_val(0,"0019");

 set_val(GETCPAT()+1,"00000000");
 set_val(GETCPAT()+1,"ffffffff");
 set_val(GETCPAT()+1,"00000000");
 set_val(GETCPAT()+1,"ffffffff");
 set_val(GETCPAT()+1,"00000000");
 set_val(GETCPAT()+1,"ffffffff");
 set_val(GETCPAT()+1,"7fffff00");

 /* normal mode, Execute 1 micro-instruction ifetch*/
 mode_normal(GETCPAT()+1,1);

 /* Mode Test, Analysing registers values */
 mode_test(GETCPAT()+1);

 /* the end */
 SAV_GENPAT();

} 
