%{
#include <stdio.h>
#include <string.h>
#include <ctype.h>
/*#include <search.h>*/
#include MUT_H 
#include "../../beh104/beh104.h"

typedef struct syf_expr
  {
  char	 	*IDENT; 	/* identifier or constant name		*/
  struct chain	*LIST_ABL;	/* pointer on bvl_abllst list		*/
  short		 WIDTH;         /* width of bit vector			*/
  }
syf_ablstr;

typedef struct
  {
  char 		*NAME;		/* identifier name */
  short  	 LEFT;		/* vector's left index */
  short 	 RIGHT;		/* vector's right index */
  char           FLAG;
  }
syf_name;

struct g_type
  {
  int  VALU;
  char FLAG;
  };

#include "y.tab.h"
#include "syf_bedef.h"
#include "syf_blex.h"

static el_mc tab_mc []=
  {
    {"abs"		,ABS},
    {"access"		,ACCESS},
    {"after"		,AFTER},
    {"alias"		,ALIAS},
    {"all"		,ALL},
    {"and"		,_AND},
    {"architecture"	,ARCHITECTURE},
    {"array"		,ARRAY},
    {"assert"		,ASSERT},
    {"attribute"	,ATTRIBUTE},
    {"begin"		,_BEGIN},
    {"block"		,BLOCK},
    {"body"		,BODY},
    {"buffer"		,BUFFER},
    {"bus"		,BUS},
    {"case"		,CASE},
    {"component"	,COMPONENT},
    {"configuration"	,CONFIGURATION},
    {"constant"		,CONSTANT},
    {"disconnect"	,DISCONNECT},
    {"downto"		,DOWNTO},
    {"else"		,ELSE},
    {"elsif"		,ELSIF},
    {"end"		,_END},
    {"entity"		,ENTITY},
    {"error"		,ERROR},
    {"exit"		,_EXIT},
    {"file"		,_FILE},
    {"for"		,FOR},
    {"function"		,FUNCTION},
    {"generate"		,GENERATE},
    {"generic"		,GENERIC},
    {"guarded"		,GUARDED},
    {"if"		,IF},
    {"in"		,_IN},
    {"inout"		,_INOUT},
    {"is"		,IS},
    {"label"		,_LABEL},
    {"library"		,LIBRARY},
    {"linkage"		,_LINKAGE},
    {"loop"		,LOOP},
    {"map"		,MAP},
    {"mod"		,MOD},
    {"nand"		,_NAND},
    {"new"		,NEW},
    {"next"		,_NEXT},
    {"nor"		,_NOR},
    {"not"		,_NOT},
    {"null"		,_NULL},
    {"of"		,OF},
    {"on"		,ON},
    {"open"		,OPEN},
    {"or"		,_OR},
    {"others"		,OTHERS},
    {"out"		,_OUT},
    {"package"		,PACKAGE},
    {"port"		,PORT},
    {"procedure"	,PROCEDURE},
    {"process"		,PROCESS},
    {"range"		,RANGE},
    {"record"		,RECORD},
    {"register"		,REGISTER},
    {"rem"		,REM},
    {"report"		,REPORT},
    {"return"		,RETURN},
    {"select"		,SELECT},
    {"severity"		,SEVERITY},
    {"signal"		,SIGNAL},
    {"stable"		,_STABLE},
    {"subtype"		,SUBTYPE},
    {"then"		,THEN},
    {"to"		,TO},
    {"transport"	,TRANSPORT},
    {"type"		,BEHTYPE},
    {"units"		,UNITS},
    {"until"		,UNTIL},
    {"use"		,USE},
    {"variable"		,VARIABLE},
    {"wait"		,WAIT},
    {"warning"		,WARNING},
    {"when"		,WHEN},
    {"while"		,WHILE},
    {"with"		,WITH},
    {"xor"		,_XOR}
  };

static int find_mc(s)

  char *s;
  {
  char *loc;
  el_mc *pt;

  loc = namealloc(s);
  pt= (el_mc *) bsearch(loc, (char *)tab_mc,SYF_NB_MC,sizeof(el_mc),strcmp);
  if (pt==NULL) return(-1);
  return(pt->kval);
  }


%}

upper_case_letter 	  [A-Z]
digit 			  [0-9]
special_character   	  [\#\&\'\(\)\*\+\,\-\.\/\:\;\<\=\>\_\|]
space_character 	  [ \t]
format_effector		  [\t\v\r\l\f]
end_of_line		  \n
lower_case_letter 	  [a-z]
other_special_character   [\!\$\@\?\[\\\]\^\`\{\}\~]

graphic_character	  ({basic_graphic_character}|{lower_case_letter}|{other_special_character})
basic_graphic_character	  ({upper_case_letter}|{digit}|{special_character}|{space_character})
letter		   	  ({upper_case_letter}|{lower_case_letter})
letter_or_digit	   	  ({letter}|{digit})
decimal_literal	   	  {integer}(\.{integer})?({exponent})?
integer		   	  {digit}(_?{digit})*
exponent	   	  ([eE][-+]?{integer})
base		   	  {integer}
based_integer	   	  {extended_digit}(_?{extended_digit})*
extended_digit	   	  ({digit}|[a-fA-F])
base_specifier	  	  (B|b|O|o|X|x)

%%
[ \t]			;
\&			{ return(Ampersand); }
\'			{ return(Apostrophe); }
\(			{ return(LeftParen); }
\)			{ return(RightParen); }
"**"			{ return(DoubleStar); }
\*			{ return(Star); }
\+			{ return(Plus); }
\,			{ return(Comma); }
\-			{ return(Minus); }
":="			{ return(VarAsgn); }
\:			{ return(Colon); }
\;			{ return(Semicolon); }
"<="			{ return(_LESym); }
">="			{ return(_GESym); }
\<			{ return(_LTSym); }
\>			{ return(_GTSym); }
=			{ return(_EQSym); }
\/=			{ return(_NESym); }
"=>"			{ return(Arrow); }
"<>"			{ return(Box); }
\|			{ return(Bar); }
!			{ return(Bar); }
\.			{ return(Dot); }
\/			{ return(Slash); }

{letter}(_?{letter_or_digit})*		{
			int itoken;
			itoken=find_mc(yytext);
			if (itoken== -1) 
			  {
			  yylval.text = namealloc(yytext);
			  return ( Identifier );
			  }
			else
			  {
			  return ( itoken );
			  }
					}
({decimal_literal})|({base}#{based_integer}(\.{based_integer})?#({exponent})?)|({base}:{based_integer}(\.{based_integer})?:({exponent})?)		{
			yylval.text = mbkalloc((unsigned int)strlen(yytext)+1);
	 		strcpy(yylval.text,yytext);
			return ( AbstractLit );
									}
'({graphic_character}|\"|\%)' 						{
			yylval.text = namealloc (yytext);
			return ( CharacterLit );
									}
(\"({graphic_character}|(\"\")|\%)*\")|(\%({graphic_character}|(\%\%)|\")*\%) {
			yylval.text = namealloc (yytext);
			return ( StringLit );
									}
{base_specifier}((\"{extended_digit}(_?{extended_digit})*\")|(\%{extended_digit}(_?{extended_digit})*\%)) 							{
			yylval.text = namealloc (yytext);
			return ( BitStringLit );
									}
\n									{
			/* end of line */
			 SYF_LINNUM++;
									}
\-\-{space_character}*[pP][rR][aA][gG][mM][aA].*$ 							{
			/* pragma */
			yylval.text = namealloc (yytext);
			return(Pragma);
									}
\-\-.*$ 								{
			/* comment */
			/* nothing */
									}
.									{
			return (*yytext);
									}
%%
