/*******************************************************************************
*
* Fichier de structures FSM .
*
* version du 	09/06/92 .
*******************************************************************************/
#define NUMBER_BIT(n)  (int )(log(n -0.5)/log(2.0)) + 1
#define NUMBER_CODE(n) (int)(0.1 + pow(2.0,(double)NUMBER_BIT(n)))
#define NUMBERCTRL 3
#define NOP 0
#define PUSH 1
#define POP 2

#define MOORE 1
#define MEALEY 2

#define ER_BUS 0
#define ER_PARAM 1

#define MUST '1'
#define ASP '2'
#define ALEA '3'
#define FORC '4'
#define VERT '5'
#define JEDI '6'
#define MUSE '7'
#define NEWC '8'
#define RECUIT '9'

#define REG_MS 1 
#define REG_D 2 

extern struct syf_befig *SYF_HEDFIG ;
extern char SYF_ERRFLG ;
int syf_trace ;
char *FSM_FILE ;
char *FILE_NAME ;

int SYF_COMPILE ;
/*********************** STRUCTURE D'UN ETAT *************************/
typedef struct locOutput
 {
   struct locOutput *next ;
   short label ;
   chain_list *abl ;
 } *pLocOut ;

typedef struct transition
 {
   struct transition *next ;
   chain_list *abl ; 
   pNode bdd ;
   int sPlabel ;
 } *pTrans ;


/************* STRUCTURE POUR LA SYNTHESE ET STRUCTURE SYSTEME ***********/

typedef struct code
	{
	int code ;
	chain_list *abl ;
	}*pCode ;

typedef struct state
	{
	char *name ;
        pTrans trans;
        pLocOut   locOut;
        pLocOut   locOutDc;
	chain_list *abl ;
   	pNode bdd ;
        void *user;
	}*pState ;

typedef struct output
	{
	char *name ;
	chain_list *abl ;
	pNode bdd ;
	} *pOut ;

typedef struct Sregister
	{
	char *name ;
	chain_list *abl ;
	chain_list *cnd ;
	pNode bdd ;
	} *pReg ;

/************** STRUCTURE DE PILE *************/

typedef struct stack
{
struct stack *next ;
int ctrl ;
int curentStatelabel ;
int returnStatelabel ;
chain_list *abl ;
} *pStack ;

typedef struct output *pCtrl; 
typedef struct output *pSignal; 
typedef struct system
{
char *name ;
int typeMachine ;
char **input ;
int numberIn ;
int numberOut ;
int numberState ;
int numberReg ;
pState state ;
pStack stack ;
pOut out ;
pReg reg ;
pReg regOut ;
char *codage;
pCode code ;
pCode dc ;
chain_list *ablDc ;
pReg *inStack ;
pCtrl inCtrl ;
pSignal inFixStack;
int stackCodeMask;
int stackFixCode;
int numberCtrl;
int sizeStack;
int stackNumBit ;
char *horloge ;
chain_list *cndReg;
int typeReg ;
char *scin ;
char *scout ;
char *testMode ;
} *pAutoSys ;
pAutoSys  autoSys ;

/************************* declaration des fonctions *****************/

void initializeAuto() ;
int createState() ;
pTrans createTrans() ;
pLocOut createLocOut() ;
pLocOut createLocOutDc() ;
void ajoutTrans();
void displayTrans();
void displayCode();
struct syf_befig *auto2beh() ;
struct syf_befig *a2behRom() ;
void simplifAutoDc() ;
void displayStateName();
pCircuit rempliBddAuto();
pCircuit makeLocalBdd() ;
void destroyAuxAuto();
pCircuit createCir() ;
void simplifDcAutoBeh() ;
chain_list *invChainList() ;
void nc_displayGrp() ;
void displayReg() ;
pCircuit compile() ;
pCircuit compileKiss() ;
void syf_cod() ;
char *nameI() ;
char *nameMa() ;
char *nameSl() ;
