
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_rmvbefig.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_rmvbefig						*/
/* description	: delete a BEFIG structure and return the pointer of	*/
/*		  the next object. A warning is printed out if the	*/
/*		  object to be deleted is not empty when the mode is N.	*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

struct syf_befig *syf_beh_rmvbefig (listbefig, befigname, mode)

struct syf_befig *listbefig;	/* list of befig containing the object	*/
char         *befigname;	/* name of the BEFIG to be deleted	*/
char          mode;		/* recursive delete or not (Y or N)	*/

  {
  struct syf_befig  headfig;
  struct syf_befig *ptlastfig;
  struct syf_befig *ptbefig;
  struct ptype *ptptype;

  if (listbefig != NULL)
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headfig.NEXT = listbefig;
    ptbefig      = &headfig;
    while ((ptbefig != NULL) && (ptbefig->NAME != befigname))
      {
      ptlastfig = ptbefig;
      ptbefig   = ptbefig->NEXT;
      }

    if (ptbefig != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/*    If the object has been found check the mode and, if asked	*/
	/* delete pointed objects recursively.				*/
	/* ###------------------------------------------------------### */

      if (mode == 'N')
        {
        if ((ptbefig->BEREG != NULL) || (ptbefig->BEMSG != NULL) ||
            (ptbefig->BERIN != NULL) || (ptbefig->BEOUT != NULL) ||
            (ptbefig->BEBUS != NULL) || (ptbefig->BEAUX != NULL) ||
            (ptbefig->BEDLY !=NULL)  || (ptbefig->BEBUX != NULL) || 
	    (ptbefig->BEPOR != NULL) || (ptbefig->USER  != NULL))

          (void) fprintf (stderr,"BEH_warning : befig `%s` not empty\n",
                          befigname);
        }
      else
        {
        syf_beh_frebereg (ptbefig->BEREG);
        syf_beh_frebemsg (ptbefig->BEMSG);
        syf_beh_freberin (ptbefig->BERIN);
        syf_beh_frebeout (ptbefig->BEOUT);
        syf_beh_frebebus (ptbefig->BEBUS);
        syf_beh_frebeaux (ptbefig->BEAUX);
        syf_beh_frebeaux (ptbefig->BEDLY);
        syf_beh_frebebux (ptbefig->BEBUX);
        syf_beh_frebepor (ptbefig->BEPOR);
        if ((ptptype = getptype (ptbefig->USER,BEH_GENERIC)) != NULL)
          syf_beh_frebegen (ptptype->DATA);
        }

      ptlastfig->NEXT = ptbefig->NEXT;
      mbkfree (ptbefig);
      }

    listbefig = headfig.NEXT;
    }

  return(listbefig);
  }
