
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_getgenva.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to acces to the	*/
/*		  value of a behaviour data structure			*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_getgenval						*/
/* description	: Search an find a BEGEN structure (known from its name)*/
/*		  then return its value field. If the BEGEN is not found*/
/*		  a NULL pointer is returned				*/
/* called func.	:							*/
/* ###--------------------------------------------------------------### */

void *syf_beh_getgenval (listbegen, begenname)

struct syf_begen *listbegen;	/* head of BEGEN list			*/
char         *begenname;	/* name of the structure 		*/

  {
  struct syf_begen *ptbegen;
  void         *value = NULL;

	/* ###------------------------------------------------------### */
	/*    searching the object					*/
	/* ###------------------------------------------------------### */

  ptbegen = listbegen;
  while ((ptbegen != NULL) && (ptbegen->NAME != begenname))
    ptbegen = ptbegen->NEXT;

	/* ###------------------------------------------------------### */
	/*    if found return its value field				*/
	/* ###------------------------------------------------------### */

  if (ptbegen != NULL)
    value = ptbegen->VALUE;

  return (value);
  }
