
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebiabl.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebiabl						*/
/* description	: delete a list of BIABL structures and all objects	*/
/*		  pointed by any os BIABLs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebiabl (listbiabl)

struct biabl *listbiabl;	/* list of biabl to be deleted		*/

  {
  struct biabl *ptbiabl;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbiabl != NULL)
    {
    freeExpr (listbiabl->VALABL);
    freeExpr (listbiabl->CNDABL);

    ptbiabl   = listbiabl;
    listbiabl = listbiabl->NEXT;
    mbkfree (ptbiabl);
    }

  }
