
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_freberin.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_freberin						*/
/* description	: delete a list of BEAUX structures and all objects	*/
/*		  pointed by any os BEAUXs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_freberin (listberin)

struct syf_berin *listberin;	/* list of berin to be deleted		*/

  {
  struct syf_berin *ptberin;

	/* ###------------------------------------------------------### */
	/*    for each object of the list delete the object itself	*/
	/* ###------------------------------------------------------### */

  while (listberin != NULL)
    {
    ptberin   = listberin;
    listberin = listberin->NEXT;
    mbkfree (ptberin);
    }

  }
