
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebemsg.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebemsg						*/
/* description	: delete a list of BEMSG structures and all objects	*/
/*		  pointed by any os BEMSGs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebemsg (listbemsg)

struct syf_bemsg *listbemsg;	/* list of bemsg to be deleted		*/

  {
  struct syf_bemsg *ptbemsg;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbemsg != NULL)
    {
    freeExpr (listbemsg->ABL);

    ptbemsg   = listbemsg;
    listbemsg = listbemsg->NEXT;
    mbkfree (ptbemsg);
    }

  }
