
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebegen.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebegen						*/
/* description	: delete a list of BEGEN structures and all objects	*/
/*		  pointed by any os BEGENs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebegen (listbegen)

struct syf_begen *listbegen;	/* list of begen to be deleted		*/

  {
  struct syf_begen *ptbegen;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbegen != NULL)
    {
    mbkfree (listbegen->VALUE);

    ptbegen   = listbegen;
    listbegen = listbegen->NEXT;
    mbkfree (ptbegen);
    }

  }
