
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_frebefig.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_frebefig						*/
/* description	: delete a list of BEFIG structures and all objects	*/
/*		  pointed by any os BEFIGs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void syf_beh_frebefig (listbefig)

struct syf_befig *listbefig;	/* list of befig to be deleted		*/

  {
  struct syf_befig *ptbefig;
  struct ptype *ptptype;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbefig != NULL)
    {
    syf_beh_frebereg (ptbefig->BEREG);
    syf_beh_frebemsg (ptbefig->BEMSG);
    syf_beh_freberin (ptbefig->BERIN);
    syf_beh_frebeout (ptbefig->BEOUT);
    syf_beh_frebebus (ptbefig->BEBUS);
    syf_beh_frebeaux (ptbefig->BEAUX);
    syf_beh_frebeaux (ptbefig->BEDLY);
    syf_beh_frebebux (ptbefig->BEBUX);
    syf_beh_frebepor (ptbefig->BEPOR);
    if ((ptptype = getptype (ptbefig->USER,BEH_GENERIC)) != NULL)
      syf_beh_frebegen (ptptype->DATA);

    ptbefig   = listbefig;
    listbefig = listbefig->NEXT;
    mbkfree (ptbefig);
    }

  }
