
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_delbereg.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_delbereg						*/
/* description	: delete a BEREG structure and return the pointer of	*/
/*		  the next object. A warning is printed out if the	*/
/*		  object to be deleted is not empty when the mode is N	*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

struct syf_bereg *syf_beh_delbereg (listbereg, ptbereg, mode)

struct syf_bereg *listbereg;	/* list of bereg containing the object	*/
struct syf_bereg *ptbereg;		/* pointer of the BEREG to be deleted	*/
char          mode;		/* recursive delete or not (Y or N)	*/

  {
  struct syf_bereg  headreg;
  struct syf_bereg *ptlastreg;

  if ((listbereg != NULL) && (ptbereg != NULL))
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headreg.NEXT = listbereg;
    ptlastreg    = &headreg;
    while ((ptlastreg != NULL) && (ptlastreg->NEXT != ptbereg))
      ptlastreg = ptlastreg->NEXT;

    if (ptlastreg != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/*    If the object has been found check the mode and, if asked	*/
	/* delete pointed objects recursively.				*/
	/* ###------------------------------------------------------### */

      if (mode == 'N')
        {
        if ((ptbereg->BIABL != NULL) || (ptbereg->BINODE != NULL))
          (void) fprintf (stderr,"BEH_warning : bereg `%s` not empty\n",
                          ptbereg->NAME);
        }
      else
        {
        syf_beh_frebiabl  (ptbereg->BIABL);
        syf_beh_frebinode (ptbereg->BINODE);
        }

      ptlastreg->NEXT = ptbereg->NEXT;
      mbkfree (ptbereg);
      }

    listbereg = headreg.NEXT;
    }

  return(listbereg);
  }
