
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_crtbetyp.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_crtbetyp						*/
/* description	: create an array of BETYPs from a list of BETYPs	*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct syf_betyp *syf_beh_crtbetyp (listbetyp)

struct syf_betyp *listbetyp;	/* pointer on the list of betyps	*/

  {
  struct syf_betyp *lclbetyp = listbetyp;
  struct syf_betyp *ptbetyp  = NULL;
  int           size     = 0;

  while (lclbetyp != NULL)
    {
    lclbetyp = lclbetyp->NEXT;
    size++;
    }

  if (size != 0)
    {
    ptbetyp  = (struct syf_betyp *) mbkalloc (size * sizeof(struct syf_betyp));
    lclbetyp = ptbetyp;

    while (listbetyp != NULL)
      {
      lclbetyp->NAME   = listbetyp->NAME;
      lclbetyp->LEFT   = listbetyp->LEFT;
      lclbetyp->RIGHT  = listbetyp->RIGHT;
      lclbetyp->VALUE  = listbetyp->VALUE;
      lclbetyp->SIZE   = listbetyp->SIZE;
      lclbetyp->BYTE   = listbetyp->BYTE;
      lclbetyp->BASE   = listbetyp->BASE;
      lclbetyp->INDEX  = listbetyp->INDEX;
      lclbetyp->RESOLV = listbetyp->RESOLV;
      lclbetyp->CLASS  = listbetyp->CLASS;

      lclbetyp->NEXT   = lclbetyp + 1;

      listbetyp        = listbetyp->NEXT;
      lclbetyp++;
      }

    (lclbetyp - 1)->NEXT = NULL;
    }

  return (ptbetyp);
  }
