
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbiabl.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbiabl						*/
/* description	: create a BIABL structure at the top the list		*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct biabl *syf_beh_addbiabl (lastbiabl, label, condition, value)

char         *label;		/* block's label			*/
struct biabl *lastbiabl;	/* pointer on the last biabl structure	*/
struct chain *condition;	/* guard expression (ABL)		*/
struct chain *value;		/* value expression (ABL)		*/

  {
  struct biabl  *ptbiabl;

  ptbiabl         = (struct biabl *) mbkalloc (sizeof(struct biabl));
  label           = namealloc (label);

  ptbiabl->LABEL  = label;
  ptbiabl->CNDABL = condition;
  ptbiabl->VALABL = value;
  ptbiabl->NEXT   = lastbiabl;

  return (ptbiabl);
  }
