
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbebus.c					*/
/* date		: Aug  28 1992						*/
/* version	: v102							*/
/* authors	: P. BAZARGAN						*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbebus						*/
/* description	: create a BEBUS structure at the top the list		*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct syf_bebus *syf_beh_addbebus (lastbebus, name, biabl, binode, type)

struct syf_bebus  *lastbebus;	/* pointer on the last bebus structure	*/
char          *name;		/* port's name				*/
struct biabl  *biabl;		/* port's drivers (ABL)			*/
struct binode *binode;		/* port's drivers (BDD)			*/
char           type;		/* port type mark (M or W)		*/

  {
  struct syf_bebus *ptbus;

  name          = namealloc (name);

  ptbus         = (struct syf_bebus *) mbkalloc (sizeof(struct syf_bebus));
  ptbus->NAME   = name;
  ptbus->BIABL  = biabl;
  ptbus->BINODE = binode;
  ptbus->TYPE   = type;
  ptbus->NEXT   = lastbebus;

  return (ptbus);
  }
