
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_addbeasg.c					*/
/* date		: Aug 28 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to create a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_addbeasg						*/
/* description	: create a BEASG structure at the top the list		*/
/* called func.	: addptype, mbkalloc, namealloc				*/
/* ###--------------------------------------------------------------### */

struct ptype *syf_beh_addbeasg (lastptype, name, abl, type)

struct ptype  *lastptype;	/* pointer on the last ptype structure	*/
char          *name;		/* signal's name			*/
struct chain  *abl;		/* condition's expression		*/
unsigned char  type;		/* signal's type (cannot be 0)		*/

  {
  struct ptype *ptptype;
  struct syf_beasg *ptbeasg;

  name              = namealloc (name);

  ptbeasg           = (struct syf_beasg *) mbkalloc (sizeof(struct syf_beasg));
  ptbeasg->NAME     = name;
  ptbeasg->ABL      = abl;
  ptbeasg->TYPE     = type;

  ptptype           = addptype (lastptype, BEH_BEASG, (void *)ptbeasg);

  return (ptptype);
  }
