/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur Logique                                       */
/*    Fichier :  sl_systemp.c                                                */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 30/09/1993     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include MUT_H
#include LOG_H
#include BEH_H
#include "ctype.h"
#include "../menu/sl_corps.h"
#include "../ablorder/sl_order.h"
#include "../compil/lax_param.h"
#include "../mapping/types.h"
#include "../mapping/compile.h"
#include "../mapping/util.h"
#include "../mbk/sl_mbk.h"
#include "../cccc/c4_debug.h"
#include "../cccc/c4.h"
#include "sl_type.h"
#include "../compil/sl_util.h"

 
/*----------------------------------------------------------------------------
initializeParam : initialise les parametres de la synthese.
------------------------------------------------------------------------------
retour          : un pointeur sur une structure param.
------------------------------------------------------------------------------*/

param *initializeParam(optim,aux,level,delayPI,intermediate,optimPO,numTransN,numTransP)
int optim;
int aux;
int level;
ptype_list *delayPI;
chain_list *intermediate;
chain_list *optimPO;
int numTransN,numTransP;
{
param *par;

par = (param *) malloc (sizeof(param));
par->mode = optim;
par->aux = aux;
par->level = level;
par->delayPI = delayPI;
par->intermediate = intermediate;
par->earlyPO = optimPO;
par->numTransN = numTransN;
par->numTransP = numTransP;

par->maxSlopeTime = 0;
par->impedancePI = NULL;
par->capaPO = NULL;
par->capaPI = NULL;

return(par);
}

/*----------------------------------------------------------------------------
initializeSLSystem:  alloue sys 
------------------------------------------------------------------------------
retour		: un pointeur sur une structure systeme. 
------------------------------------------------------------------------------*/

sl_system *initializeSLSystem()
{
sl_system *sl;

sl = (sl_system *) malloc (sizeof(sl_system));

sl->orderPI = NULL;

sl->order = 0;
sl->version = (char *) malloc (100);
sl->fileVhdl  = (char *) malloc (100);
sl->fileOut   = (char *) malloc (100);
sl->file      = (char *) malloc (100);
sl->fileParam = (char *) malloc (100);
sl->filePar   = (char *) malloc (100);

sl->beh_lib   = (char *) malloc (100);
sl->log_lib   = (char *) malloc (100);
sl->par_lib   = (char *) malloc (100);
sl->cata_lib   = (char *) malloc (100);
sl->cata_save   = (char *) malloc (100);
sl->c4_lib   = (char *) malloc (100);
sl->in_lo   = (char *) malloc (20);
sl->out_lo   = (char *) malloc (20);
sl->out_ph   = (char *) malloc (20);

return( sl );
}


void mappingSC()
{
   chain_list *fileLib;
   int lit,maxLit,litRed,litReg,profMax,delaisMax,operBin;

		/* compilation de la bibliotheque */

   VHB_HEDFIG = NULL;

   printf("Running Mapping Standard Cell...\n");

   coutAblBeh(SL_BEH,&lit,&maxLit,&litRed,&profMax,&delaisMax,&operBin,
              &litReg,0,SL_DELAYPI);
   printf("==============================  INITIAL COST  ==================================\n");
   printf("Total number of litterals   = %d\n",lit);
   printf("Reduced number of litterals = %d\n",litRed);
   printf("Register litterals          = %d\n",litReg);
   printf("Number of binary operators  = %d\n",operBin);
   printf("Cone maximum                = %d\n",maxLit);
   printf("Depth maximum               = %d\n",profMax);
   printf("Delay maximum               = %.3f\n",((float) delaisMax)/1000);
   printf("===============================================================================\n");
   if (SL_TRACE)
      printf("Removing the auxiliary signals...\n");

   if (SL_AUX == 0)
      compactExprBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO,1);
   else
      mapCarExprBeh(SL_BEH,simplif10Expr);

   
   if (SL_TRACE)
      {
      coutAblBeh(SL_BEH,&lit,&maxLit,&litRed,&profMax,&delaisMax,&operBin,
              &litReg,0,SL_DELAYPI);
      printf("==============================  INITIAL COST  ==================================\n");
      printf("Total number of litterals   = %d\n",lit);
      printf("Reduced number of litterals = %d\n",litRed);
      printf("Register litterals          = %d\n",litReg);
      printf("Number of binary operators  = %d\n",operBin);
      printf("Cone maximum                = %d\n",maxLit);
      printf("Depth maximum               = %d\n",profMax);
      printf("Delay maximum               = %.3f\n",((float) delaisMax)/1000);
      printf("===============================================================================\n");
      }

   if (SL_TRACE && SL_AUX == 0)
      {
      printf("apres decompactage\n");
      displayBeh(SL_BEH,1);
      }

   fileLib = (chain_list *) SLgetFile(SL_CATA_LIB,"vbe");
   if (!fileLib)
      {
      printf("Mapping SC : Error - there's no cell in '%s'\n",SL_CATA_LIB);
      exit(-1);
      }
   while (fileLib)		
      {
      if (SL_TRACE)
         {
         printf("%s\n",fileLib->DATA);
         }
      if (compileVHDL(fileLib->DATA,NULL,0,NULL,1,0,1,1,0,renameSig,0,NULL) != NULL)
         {
         /* display de la compilation des cellules
            displayBeh(VHB_HEDFIG,1);
         */
         removeAuxBeh(VHB_HEDFIG,NULL);
         bddToAblBeh(VHB_HEDFIG,0);
         }
      fileLib = fileLib->NEXT;
      }
   if (SL_TRACE)
      {
      printf("\n");
      }
   mappSys = initMapping();
   compileLibrary();
   mapper();
   genMBKBeh(SL_BEH,1);
   changeAblBeh(SL_BEH);
   endMapping();

   if (SL_TRACE)
      {
      printf("End of mappingSC\n");
      }
   else
      printf("\n");
}

void mappingC4()
{
char *carint;
int lit,maxLit,litRed,litReg,profMax,delaisMax,operBin;

   if (SL_BEH->TYPE & BEH_STABLE)
      {
      printf("Mapping C4 : error - attribut stable is not supported with C4\n");
      exit(-1);
      }

   coutAblBeh(SL_BEH,&lit,&maxLit,&litRed,&profMax,&delaisMax,&operBin,
              &litReg,0,SL_DELAYPI);
   printf("==============================  INITIAL COST  ==================================\n");
   printf("Total number of litterals   = %d\n",lit);
   printf("Reduced number of litterals = %d\n",litRed);
   printf("Register litterals          = %d\n",litReg);
   printf("Number of binary operators  = %d\n",operBin);
   printf("Cone maximum                = %d\n",maxLit);
   printf("Depth maximum               = %d\n",profMax);
   printf("Delay maximum               = %.3f\n",((float) delaisMax)/1000);
   printf("================================================================================\n");

   printf("Running Mapping with C4 ...");
   printf(".");
   fflush(stdout);
   devXorBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO);

   printf(".");
   fflush(stdout);

   if (SL_TRACE)
      printf("\nRemoving the auxiliary signals...\n");

   if (SL_AUX == 0)
      compactExprBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO,1);
   else
      mapCarExprBeh(SL_BEH,simplif10Expr);

   if (SL_TRACE == 2 && SL_AUX == 0)
      {
      printf("apres decompactage\n");
      displayBeh(SL_BEH,1);
      }

   printf(".");
   fflush(stdout);
   flatPolarityBeh(SL_BEH);

   printf(".");
   fflush(stdout);
   decompBoolBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO,SL_NUMTRANSP,SL_NUMTRANSN);

		/* on appelle une deuxieme fois (les temps ont change) */
   printf(".");
   fflush(stdout);
   decompBoolBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO,SL_NUMTRANSP,SL_NUMTRANSN);

   printf(".");
   fflush(stdout);
   mapBeh(SL_BEH,SL_OPTIM,SL_DELAYPI,SL_OPTIMPO,SL_NUMTRANSP,SL_NUMTRANSN);

   printf(".");
   fflush(stdout);
   postBeh(SL_BEH,SL_AUX);

   printf(".");
   fflush(stdout);

		/* appel a C4 */

   printf("\n");
   putenv((char *) genNAME("MBK_WORK_LIB=%s",SL_CCCC_LIB));
   mbkenv();
   c4MappBeh(SL_BEH,SL_TRACE,SL_DELAYPI);

   putenv((char *) genNAME("MBK_WORK_LIB=%s",SL_LOG_LIB));
   mbkenv();
   genMBKBeh(SL_BEH,0);
   changeAblBeh(SL_BEH);
}

/*----------------------------------------------------------------------------
laxOptimize	: Encapsulation de la fonction d'optimisation pour LAX 
------------------------------------------------------------------------------
retour		: une befig optimisee
------------------------------------------------------------------------------*/

befig_list *laxOptimize(beh,trace,optim,aux,intermediate,level,optimPO,delayPI)
befig_list *beh;
int trace;
int optim;
int aux;
chain_list *intermediate;
int level;
chain_list *optimPO;
ptype_list *delayPI;
{
int vhb_reorder = 0;

	/* initialisation de la structure sl_sys */

sl_sys->beh = beh;

sl_sys->fileVhdl = NULL;
sl_sys->file = NULL;
sl_sys->beh_lib = NULL;
sl_sys->log_lib = NULL;

sl_sys->mode = 1;
sl_sys->version = "3.00";
sl_sys->trace = trace;
sl_sys->option = 'o';

                /* affichage de la banniere */
 
if (getenv("MBK_BANN"))
   sl_sys->banniere = 0;
else
   sl_sys->banniere = 1;
 
                /* on fige le chapeau des latches */
 
if (!getenv("MBK_NAME_LOG"))
   sl_sys->name_log = 0;            /* on genere une lofig du nom  + optim */
else
   sl_sys->name_log = 1;            /* on genere une lofig du meme nom */
 
/* appel aux fonctions d'ordonnancement - 0 rien - 1 ABL - 2 ABL + BDD */
 
if (!getenv("MBK_ORDER"))
   sl_sys->makeOrder = 2;
else
   if (!strcmp(getenv("MBK_ORDER"),"0"))
      sl_sys->makeOrder = 0;
   else
      if (!strcmp(getenv("MBK_ORDER"),"1"))
         sl_sys->makeOrder = 1;
      else
         sl_sys->makeOrder = 2;
 
if (sl_sys->makeOrder >= 1)
   sl_sys->order = 1;


sl_sys->par = initializeParam(optim,aux,level,delayPI,intermediate,optimPO,4,4);

if (SL_MAKEORDER >= 1)
   vhb_reorder = 2;
       
displayBeh(beh,1);

	/* la befig a deja ete compile, 
           on ne cree que les graphes avec compileVHDL */

if (compileVHDL(SL_VHDL,SL_ORDERPI,SL_ORDER,SL_PAR,
                SL_AUX,1,vhb_reorder,1,trace,nameInt,SL_LATCHES,beh) == NULL)
   {
   return NULL;
   }
else
   {
   anealingFOOD(SL_TRACE);
   }
resetBdd();
return beh;
}
