#include MUT_H
#include BEH_H
#include "../compil/lax_param.h"
#include "../synthe/sl_type.h"
#include "../compil/sl_util.h"
#include "../ablorder/sl_order.h"
#include "../menu/sl_corps.h"
#include "sl_param.h"
#include "string.h"

/*----------------------------------------------------------------------------
verifLoadParam	: verifie l'appartenance des entrees retardees et des sorties 
                  a optimiser dans la befig.
------------------------------------------------------------------------------
retour		: 0 si mauvaises entrees ou sorties
		  1 si OK
------------------------------------------------------------------------------*/

int verifLoadParam(beh,par)
befig_list *beh;
param *par;
{
chain_list *earlyPO = par->earlyPO;
ptype_list *delayPI = par->delayPI;
berin_list *in = beh->BERIN;

while (earlyPO)
   {
   if (!existOutputBeh(beh,earlyPO->DATA))
      return(0);
   earlyPO = earlyPO->NEXT;
   }
while (delayPI)
   {
   if (!existInputBeh(beh,delayPI->DATA))
      return(0);
   delayPI = delayPI->NEXT;
   }

if (delayPI == NULL) 
   return(1);

while (in)
   {
   if (!inChain_list (par->delayPI,in->NAME))
      return(0);
   in = in->NEXT;
   }
return(1);
}

/*---------------------------------------------------------------------------
listeDe		: fait un "ls" en colonnes des fichiers d'un type donne
-----------------------------------------------------------------------------
retour		: aucun
---------------------------------------------------------------------------*/

void	listeDe( path, typeFic )
char  	*path, *typeFic ;

{
char	*commande = (char*) mbkalloc( 100 );

strcpy( commande, "ls -C ");
if (!strcmp(path,"."))
   strcat(commande,"*.");
else
   {
   strcat(commande,path);
   strcat(commande,"/*.");
   }
printf("List of files '.%s' in '%s' :\n\n", typeFic,path );
system( strcat( commande, typeFic) );
#if MACHINE != pc
   mbkfree(commande);	/* chaine */
#endif
}

/*-----------------------------------------------------------------------------
ligne1		: renvoie la premiere chaine d'un fichier donne
-------------------------------------------------------------------------------
retour		: un char*  ( NULL si le fichier n'existe pas )
-----------------------------------------------------------------------------*/

char	*ligne1( fileName )
char	*fileName;

{
FILE	*Pfile;
char	*chaine = (char*) mbkalloc ( 30 );

if ( Pfile = fopen( fileName, "rt" ) ) {
	fscanf( Pfile, "%s", chaine );
	fclose( Pfile );
	return ( chaine );
	}
else {
	return ( NULL );
	}
}
	

/*----------------------------------------------------------------------------
afficheIOi	: affiche en colonnes les entrees+index donnees par une LC 
------------------------------------------------------------------------------
retour		: aucun
----------------------------------------------------------------------------*/ 

int		 afficheIOi( IOi, nbCol, nbLig, ligneDepart )
chain_list	*IOi;
int		 nbCol;
int		 nbLig;
int		 ligneDepart;

{
int 		 count = 0;
chain_list	*auxiliaire;
int		 largeurCol;
int		 currentCol = 1;
int		 currentLig = ligneDepart;
 
while ( nbCol*nbLig < countChain_list( IOi ) )  nbCol++;

count = 2;
largeurCol = 80/nbCol;
while ( IOi )  {
	while ( (currentLig<(nbLig+ligneDepart)) && (IOi!=NULL) ) {
		gotolc( currentLig, currentCol );
		printf(" %.2d",count++);
		printf(" %s",IOi->DATA);
		IOi = IOi->NEXT;
		currentLig++;
		}
	currentCol += largeurCol;
	currentLig = ligneDepart;
	};
return ( nbCol );
}


/*-----------------------------------------------------------------------------
tempo 		: boucle de temporisation
-------------------------------------------------------------------------------
retour		: aucun
-----------------------------------------------------------------------------*/
void		tempo( t )
unsigned long	t;
{
unsigned long	i;
for( i=0; i<t; i++ );
}


/*-----------------------------------------------------------------------------
ModifOrder	: Modification de la LC des entrees (ie Modification des index)
-------------------------------------------------------------------------------
retour		: aucun
-----------------------------------------------------------------------------*/
void		  ModifOrder( orderPI, origIndex, destIndex )
chain_list	 *orderPI;
int		  origIndex;
int		  destIndex;

{
chain_list	*pti;
chain_list	*ptj;
chain_list	*ptk;
char		*dataAux = (char*) mbkalloc( 30 );
int 		 count = 2;
char	c;

pti = (chain_list *)mbkalloc(sizeof(chain_list));
ptj = (chain_list *)mbkalloc(sizeof(chain_list));
ptk = (chain_list *)mbkalloc(sizeof(chain_list));

if (destIndex == origIndex ) return;
if (destIndex >  origIndex ) destIndex++;

if (destIndex == 2) {
	ModifOrder( orderPI, origIndex, 3);
	dataAux = (char *)orderPI->DATA;
	orderPI->DATA = orderPI->NEXT->DATA;
	orderPI->NEXT->DATA = (void *)dataAux;
	return;
	}
	
if (origIndex == 2) {
	dataAux = (char *)orderPI->DATA;
	orderPI->DATA = orderPI->NEXT->DATA;
	orderPI->NEXT->DATA = (void *)dataAux;
	ModifOrder( orderPI, 3, destIndex -1);
	return;
	}
	

ptk->NEXT = pti = ptj = orderPI;


while ( count != destIndex ) {
	ptk = ptk->NEXT;
	pti = pti->NEXT;
	count++;
	}
count = 2;
while ( count != origIndex ) {
	ptj = ptj->NEXT;
	count++;
	}

if ( destIndex == 2 ) {
/*	orderPI = addchain( orderPI, ptj->DATA );
	orderPI = delchain( orderPI, ptj );
	return (orderPI );
*/
	}

delchain( orderPI, ptj );

ptj->NEXT = pti;
ptk->NEXT = ptj;
return ;
}

/*-----------------------------------------------------------------------------
addchain_alpha	: Insertion d'un element de LC dans l'ordre alphabetique
-------------------------------------------------------------------------------
retour		: un chain_list*
-----------------------------------------------------------------------------*/
chain_list	*addchain_alpha( LC, data )
chain_list	*LC;
char		*data;
{
chain_list	*LC_aux;
data = namealloc( data );

LC_aux = LC;
 
if ( LC_aux == NULL ) return( addchain( NULL, data));

if (strcmp( data,LC_aux->DATA) < 0 )
	return( addchain( LC_aux, data));
	
while ( LC_aux->NEXT ){
	if ( strcmp(data,LC_aux->NEXT->DATA) < 0 ) {
		LC_aux->NEXT = addchain( LC_aux->NEXT, data);
		return( LC );
		}
	LC_aux = LC_aux->NEXT;
	}

LC_aux->NEXT = addchain( LC_aux->NEXT, data);
return( LC );
}


/*-----------------------------------------------------------------------------
addptype_alpha	: Insertion d'un element de LC typee dans l'ordre alphabetique
-------------------------------------------------------------------------------
retour		: un ptype_list*
-----------------------------------------------------------------------------*/
ptype_list	*addptype_alpha( LC, data, type )
ptype_list	*LC;
char		*data;
long		 type;
{
ptype_list	*LC_aux;
data = namealloc( data );

LC_aux = LC;
 
if ( LC_aux == NULL ) return( addptype( NULL, type, data ));

if (strcmp( data,LC_aux->DATA) < 0 )
	return( addptype( LC_aux, type, data));
	
while ( LC_aux->NEXT ){
	if ( strcmp(data,LC_aux->NEXT->DATA) < 0 ) {
		LC_aux->NEXT = addptype( LC_aux->NEXT, type, data );
		return( LC );
		}
	LC_aux = LC_aux->NEXT;
	}

LC_aux->NEXT = addptype( LC_aux->NEXT, type, data );
 
return( LC );
}
/*--------------------------------------------------------------------------
delMaillon	: detruit un mailon dont la donnee est DATA dans une LC
----------------------------------------------------------------------------
retour		: le pointeur de la LC traitee
--------------------------------------------------------------------------*/
chain_list	*delMaillon( LC, data )
chain_list	*LC;
char		*data;
{
chain_list	*LC_aux = LC;

if ( LC == NULL ) return ( NULL );

if ( strcmp(LC_aux->DATA, data) == 0 ) 
	return( delchain( LC_aux, LC_aux ) );

while (LC_aux) {
	if ( strcmp(LC_aux->DATA, data ) == 0 ) 
		return( delchain( LC, LC_aux ));
	LC_aux = LC_aux->NEXT;
	}

return ( LC );
}	


/*--------------------------------------------------------------------------
delMaillont	: detruit un mailon dont la donnee est DATA dans une LC typee
----------------------------------------------------------------------------
retour		: le pointeur de la LC traitee
--------------------------------------------------------------------------*/
ptype_list	*delMaillont( LC, data )
ptype_list	*LC;
char		*data;
{
ptype_list	*LC_aux = LC;

if ( LC == NULL ) return ( NULL );

if ( strcmp(LC->DATA, data) == 0 ) 
	return( delptype( LC, LC->TYPE ) );

while (LC_aux) {
	if ( strcmp(LC_aux->DATA, data ) == 0 ) {
		return( (ptype_list*) delchain( LC, LC_aux ));
		}
	LC_aux = LC_aux->NEXT;
	}

return ( LC );
}	


/*--------------------------------------------------------------------------
findDatat	: recherche la DATA, dans une LC typee, de position rang
----------------------------------------------------------------------------
retour		: la DATA
--------------------------------------------------------------------------*/
char		*findDatat( LC, rang )
ptype_list	*LC;
int		 rang;
{
int		 i;
ptype_list	*LC_aux = LC;

if ( LC == NULL ) return ( NULL );

if ( rang > countPtype_list( LC ) ) 
	printf("\nrange error !\n");
else 
	for( i = 1; i < rang; i++ ) LC_aux = LC_aux -> NEXT;
return (char *)LC_aux -> DATA;
}


/*--------------------------------------------------------------------------
itoa		: convertit un int en une chaine de caract 
----------------------------------------------------------------------------
retour		: un char *
--------------------------------------------------------------------------*/
char	*itoa( nb )
int 	 nb;
{
char	*p = (char*) mbkalloc( 20 );

if ( nb == 0 ) return("0");

p += 20;
*(--p)= 0;

while ( nb ) {
	*(--p) = ( nb %  10 ) +48;
	nb = nb / 10;
	}

return ( p );
}

