#include MUT_H
#include MPH_H
#include MLO_H
#include BEH_H
#include "c4.h"
#include "c4_stretch.h"

/******************************************************************************
 ***  Version 1.0b02                                            14/06/1991  ***
 ******************************************************************************

 ******************************************************************************
 ******************************************************************************
 ***                                                                        ***
 ***                            c.c.c.c tools                               ***
 ***                    Complex Cmos Cells Compiler                         ***
 ***                                                                        ***
 ******************************************************************************
 ******************************************************************************

 ******************************************************************************
 ***                  STRETCHED CELLS GENERATOR MODULE                      ***
 ******************************************************************************/

/*----------------------------------------------------------------------------*
  -------- very low-level func -------------------------------------------[]--
  ----------------------------------------------------------------------------
  SYNTAX : scaleTrans(loFig_list *, int, int)
  ----------------------------------------------------------------------------
  EXEMPLE : scaleTrans(lFig, 1, 3)
  ----------------------------------------------------------------------------
  FONCTION :
  ----------------------------------------------------------------------------
  ERROR : none
 *----------------------------------------------------------------------------*/

void scaleTrans(lFig, dn, dp)
lofig_list *lFig;
int dn, dp;
{
  lotrs_list *lTr;

  for (lTr = lFig->LOTRS; lTr; lTr = lTr->NEXT)
    if (lTr->X == (-SCALE_X)) {
      lTr->WIDTH += (4 * SCALE_X * ((lTr->TYPE == TRANSN) ? dn : dp));
      lTr->X = 0;
    }
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  =-=-=-=- low level func =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-[]=-
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  SYNTAX : strDefCell(short, char *, short, short, chai_list *, char *, char *)
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  EXEMPLE : strDefCell(NT1, "nt1_yy", 1, 3,@lc_io, "s", "io")
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  FONCTION :
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  ERROR : none
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

char *strDefCell(cellType, name, dn, dp, lc_io, out, in1, in2, in3, in4,in5)
short cellType;
char *name;
short dn, dp;
chain_list *lc_io;
char *out;
char *in1, *in2, *in3, *in4 ,*in5;
{
  char *genNAME();
  lofig_list *lFig;

  switch (cellType) {
    case N1 :
      n1_p(name, dn, dp, out, in1);
      lofigNot(name, lc_io, out, in1);
      break;

    case NT1 :
      nt1_p(name, dn, dp, out, in1, in2, in3);
      lofigBus(name,lc_io,out, in1, in2, in3);
      break;

    case L1 :
      l1_p(name, dn, dp,out,in1,in2);
      lofigLatch1(name,lc_io,out,in1,in2,in3);
      break;

    case L1N :
      l1n_p(name, dn, dp, out, in1, in2);
      lofigLatch1N(name,lc_io,out,in1,in2,in3);
      break;

    case L2 :
      l2_p(name, dn, dp, out, in1, in2, in3, in4);
      lofigLatch2(name,lc_io,out,in1,in2,in3,in4,in5);
      break;

    case L2N :
      l2n_p(name, dn, dp, out, in1, in2, in3, in4);
      lofigLatch2N(name,lc_io,out,in1,in2,in3,in4,in5);
      break;

    case BD :
      lofigBD(name,lc_io,out,in1,in2,in3,in4);
      break;

    case TIE :
      tie_p(name, dn, dp);
      lofigTie(name,lc_io);
      break;

    case HIGH :
      high_p(name, dn, dp,out);
      lofigHigh(name, lc_io);
      break;

    case LOW :
      low_p(name, dn, dp,out);
      lofigLow(name, lc_io);
      break;
  }

  (void)dellofig(name);
  lFig = getlofig(name, 'A');
  scaleTrans(lFig, dn, dp);
  savelofig(lFig);
  return name;
}

/*============================================================================*
  ======== high level func ===================================================
  ============================================================================
  SYNTAX : char *c4_genPCells(short, char *, int, int)
  ============================================================================
  EXEMPLE : nameCell = c4_genPCells(NT1, "nt1_yy", 1, 3)
  ============================================================================
  FONCTION :
  ============================================================================
  ERROR : none
 *============================================================================*/

char *c4_genPCells(cellType, name, nbNCh, nbPCh, lc_io, out, in1, in2, in3, in4, in5)
short cellType;
char *name;
short nbNCh, nbPCh;
chain_list *lc_io;
char *out;
char *in1, *in2, *in3, *in4, *in5;
{
  short dn, dp;

  dn = MAX(0, nbNCh - 2);
  dp = MAX(0, nbPCh - 2);
  return strDefCell(cellType,name,dn,dp,lc_io,out,in1,in2,in3,in4,in5);
}
