#include MUT_H
#include LOG_H
#include BEH_H
#include "c4.h"
#include "c4_debug.h"

/******************************************************************************
 ***  Version 1.0b01                                            14/06/1991  ***
 ******************************************************************************

 ******************************************************************************
 ******************************************************************************
 ***                                                                        ***
 ***                            c.c.c.c tools                               ***
 ***                    Complex Cmos Cells Compiler                         ***
 ***                                                                        ***
 ******************************************************************************
 ******************************************************************************

 ******************************************************************************
 ***                            DEBUG MODULE                                ***
 ******************************************************************************

/*::::::::::::::::::::::::: start of debug func. :::::::::::::::::::::::::::::*/

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  =-=-=-=- low-level func =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-[]=-
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  SYNTAX : void c4_dbg_printInfo(MemFig *)
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  EXEMPLE : c4_dbg_printInfo(cell)
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  FONCTION : 
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  ERROR : none
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void c4_dbg_printInfo(cell)
MemFig *cell;
{
  extern chain_list *expr2Model();
  chain_list *ex;

  if (cell) {
    printf("\n=======> Infos <=========================================\n\n");
    printf("Exe. checkExpr:   %s\n", (C4_CHECKok(cell) ? "SUCCES" : "ECHEC"));
    printf("Exe. placeInput:  %s\n", (C4_PLACEok(cell) ? "SUCCES" : "ECHEC"));
    printf("Exe. createInt:   %s\n", (C4_CONNECTok(cell) ? "SUCCES" : "ECHEC"));
    printf("Exe. rouTrans:    %s\n", (C4_VROUTok(cell) ? "SUCCES" : "ECHEC"));
    printf("Compilation OK?:  %s\n", (C4_COMPok(cell) ? "OUI" : "NON"));
    printf("Routage OK?:      %s\n", (C4_ROUTok(cell) ? "OUI" : "NON"));
    printf("ABL d'entree:    ");
    displayExpr(C4_INEXPR(cell));
    if (cell->status.checkExprOK) {
      printf("\nABL de sortie:   ");
      displayExpr(C4_TREXPR(cell));
      printf("\n");
    }
    else
      printf ("\nABL de sortie non disponible.\n");
    if (cell->status.placeInputsOK) {
      printf("Modele:           sortie =");
      if (C4_POLARITY(cell) == 1)
        displayExpr(ex = expr2Model(C4_TREXPR(cell)));
      else
        displayExpr(ex = notExpr(expr2Model(C4_TREXPR(cell))));
      printf("\n");
      freeExpr(ex);
    }
    else
      printf("Modele non disponible.\n");
    if (cell->status.placeInputsOK) 
      {
      printf("Liste assoc.:    ");
      ex = C4_ASSOCLST(cell);
      while (ex) 
        {
        printf("%3d ", ex->DATA);
        ex = ex->NEXT;
        }
      printf("\n");
      }
    else
      printf("Liste assoc. non disponible.\n");
    printf("Polarite:         ");
    if (C4_POLARITY(cell) == 1)
      printf("POSITIVE\n");
    else
      if (C4_POLARITY(cell) == 0)
        printf("NEGATIVE\n");
      else
        printf("ni NEGATIVE, ni POSITIVE !\n");
    printf("Tr N serie:       %d\n", C4_NBNTRAN(cell));
    printf("Tr P serie:       %d\n", C4_NBPTRAN(cell));
    printf("\n"); 
    printf("Nb Entrees:       %d\n", C4_NBINP(cell));
    printf("Nb Coupures:      %d\n", C4_NBCUT(cell));
    printf("Nb Pitchs:        %d\n", C4_NBPITCH(cell));
    printf("Nb Ch N voulus:   %d\n", C4_NBNCHAN0(cell));
    printf("Nb Ch P voulus:   %d\n", C4_NBPCHAN0(cell));
    printf("Nb Ch N obtenus:  %d\n", C4_NBNCHAN(cell));
    printf("Nb Ch P obtenus:  %d\n", C4_NBPCHAN(cell));
  }
  else {
    printf("\n   === Erreur ===\n");
    printf("Impossible d'afficher les infos!\n");
  }
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  =-=-=-=- low-level func =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-[]=-
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  SYNTAX : void c4_dbg_printTGr(MemFig *)
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  EXEMPLE : c4_dbg_printTGr(cell)
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  FONCTION : 
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  ERROR : none
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void c4_dbg_printTGr(cell)
MemFig *cell;
{
  register short i;

  if ((cell) && (cell->status.createInterconOK)) {
    printf("\n=======> Graphe de transistor : <========================\n\n");
    for (i = 0; cell->tGraph[i]; i++)
      if (cell->tGraph[i]->trName == NULL) {
        if (cell->tGraph[i]->blkType == 1)
        printf("          - - - - - - - - - -  Coupure  - - - - - - - - -  \n");
        if (cell->tGraph[i]->blkType == 2)
        printf("          - - - - - - - - - -   Sortie  - - - - - - - - -  \n");
        if (cell->tGraph[i]->blkType == 3)
        printf("          - - - - - - - - - - Inverseur - - - - - - - - -  \n");
    }
      else
        printf("Sig:%3s  Arbre P: Hi->%3d Lo->%3d  Arbre N: H->%3d Lo->%3d\n",            cell->tGraph[i]->trName,
              cell->tGraph[i]->hiPEq,
              cell->tGraph[i]->loPEq,
              cell->tGraph[i]->hiNEq,
              cell->tGraph[i]->loNEq);
  }
  else {
    printf("\n   === Erreur ===\n");
    printf("Impossible d'afficher le graphe de T.; il n'a pas ete cree!\n");
  }
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  =-=-=-=- low-level func =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-[]=-
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  SYNTAX : void c4_dbg_printMRt(MemFig *)
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  EXEMPLE : c4_dbg_printMRt(cell)
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  FONCTION : 
  =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  ERROR : none
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

void c4_dbg_printMRt(cell)
MemFig *cell;
{
  register short i, ind;
  short a1, a2;

  i = ind = 0;
  if ((cell) && (cell->status.createInterconOK)) {
    printf("\n=======> Matrice d'interconnexions <=====================\n\n");
    printf("            +-----------------------+ +-----------------------+\n");
    printf("            | No eq  | Ch |NbCo| Xc | | No eq  | Ch |NbCo| Xc |\n");
    while (ind<MAX_EQ &&
          (cell->mRout[0][ind] != NULL || cell->mRout[1][ind] != NULL)) {
      printf("+---------+");
      printf("=+--------+----+----+----+");
      printf("=+--------+----+----+----+\n");
      printf("| Elt%3d  |",ind);
      if (cell->mRout[1][ind] == NULL)
        printf("                          ");
      else
        printf(" | P :%3d |%3d |%3d |%3d |",
              cell->mRout[1][ind]->noEq,
              cell->mRout[1][ind]->noCh,
              cell->mRout[1][ind]->nbCont,
              cell->mRout[1][ind]->contPos[0]);
      if (cell->mRout[0][ind] == NULL)
        printf("\n");
      else
      printf(" | N :%3d |%3d |%3d |%3d |\n",
              cell->mRout[0][ind]->noEq,
              cell->mRout[0][ind]->noCh,
              cell->mRout[0][ind]->nbCont,
              cell->mRout[0][ind]->contPos[0]);
      if (cell->mRout[0][ind] != NULL)
        a1 = cell->mRout[0][ind]->nbCont;
      else
        a1 = 0;
      if (cell->mRout[1][ind] != NULL)
        a2 = cell->mRout[1][ind]->nbCont;
      else
        a2 = 0;
      for (i = 1; i < ((a1 > a2) ? a1 : a2); i++) {
        if (i == 1)
          printf("+---------+");
        else
          printf("           ");
        if ((i == 1) && (cell->mRout[1][ind] != NULL))
          printf(" +--------+----+----");
        else
          printf("                    ");
        if ((cell->mRout[1][ind]!=NULL) &&(i < cell->mRout[1][ind]->nbCont))
          printf("|%3d |", cell->mRout[1][ind]->contPos[i]);
        else
          if ((cell->mRout[1][ind]!=NULL) &&(i == cell->mRout[1][ind]->nbCont))
            printf("+----+");
          else
            printf("      ");
        if ((i == 1) && (cell->mRout[0][ind] != NULL))
          printf(" +--------+----+----");
        else
          printf("                    ");
        if ((cell->mRout[0][ind]!=NULL) &&(i < cell->mRout[0][ind]->nbCont))
         printf("|%3d |\n", cell->mRout[0][ind]->contPos[i]);
        else
          if ((cell->mRout[0][ind]!=NULL) &&(i == cell->mRout[0][ind]->nbCont))
            printf("+----+\n");
          else
            printf("      \n");
      }
      if (i == 1)
        printf("+---------+");
      else
        printf("           ");
      if ((i == 1) &&
         (cell->mRout[1][ind]!=NULL) && (cell->mRout[1][ind]->nbCont == 1))
        printf(" +--------+----+----");
      else
        printf("                    ");
      if ((cell->mRout[1][ind]!=NULL) && (i == cell->mRout[1][ind]->nbCont))
        printf("+----+");
      else
        printf("      ");
      if ((i == 1) &&
         (cell->mRout[0][ind]!=NULL) && (cell->mRout[0][ind]->nbCont == 1))
        printf(" +--------+----+----");
      else
        printf("                    ");
      if ((cell->mRout[0][ind]!=NULL) && (i == cell->mRout[0][ind]->nbCont))
        printf("+----+\n");
      else
        printf("      \n");
    ind++;
    }
  }
  else {
    printf("\n   === Erreur ===\n");
    printf("Impossible d'afficher le matrice R.; elle n'a pas ete creee!\n");
  }
}

/*:::::::::::::::::::::::::: end of debug func. ::::::::::::::::::::::::::::::*/
