/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit : Icon library                                                */
/*    Fichier : aiDrive.c (Alliance icon driver)                            */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) : Vincent POUILLEY                      le : 13/09/1992     */
/*                                                                          */
/*    Modifie par : Vincent POUILLEY                    le : 08/12/1992     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/*    $Id: aiDrive.c,v 2.1.1.1 1993/09/23 16:04:30 sax Exp sax $                */
/*                                                                          */
/****************************************************************************/

#include <stdio.h>
#include "IconConst.h"
#include "ConvMacro.h"
#include MUT_H
#include ICN_H
#include IAC_H
#include ICU_H
#include <time.h>
#include <sys/types.h>
#include <sys/time.h>

#ident "@(#)Driver Alliance icon v2.00 06/08/93 by Vincent POUILLEY"

#ifdef __STDC__
char HAlignToAi(int align)
#else
char HAlignToAi(align)
int align;
#endif
{
	switch (align)
	{
		case SAX_RIGHT :
			return 'R';
		case SAX_CENTER :
			return 'C';
		default :
			return 'L';
	}
}

#ifdef __STDC__
char VAlignToAi(int align)
#else
char VAlignToAi(align)
int align;
#endif
{
	switch (align)
	{
		case SAX_UP :
			return 'U';
		case SAX_CENTER :
			return 'C';
		default :
			return 'D';
	}
}

#ifdef __STDC__
char DirectionToAi (int direction)
#else
char DirectionToAi (direction)
int direction;
#endif
{
	return (direction == SAX_HORIZONTAL) ? 'H' : 'V';
}

#ifdef __STDC__
char SideToAi(int side)
#else
char SideToAi(side)
int side;
#endif
{
	switch (side)
	{
		case SAX_NORTH :
			return 'N';
		case SAX_SOUTH :
			return 'S';
		case SAX_WEST :
			return 'W';
		default :
			return 'E';
	}
}

#ifdef __STDC__
char * LoDirToAi(char dir)
#else
char * LoDirToAi(dir)
char dir;
#endif
{
	switch(dir)
		{
		case 'I' :
			return "IN";
		case 'O' :
			return "OUT";
		case 'B' :
			return "INOUT";
		case 'X' :
			return "UNKNOWN";
		case 'Z' :
			return "TRISTATE";
		case 'T' :
			return "TRANSCV";
		default :
			(void)fprintf(stderr,"\n*** Icon Error *** saveicon (ai) impossible : Invalid logical connector direction : %c\n",dir);
			return "UNKNOWN";
		}
}

#ifdef __STDC__
char TypeToAi(int type)
#else
char TypeToAi(type)
int type;
#endif
{
	switch (type)
	{
		case COMP_ISARCSTART | COMP_ISARCEND :
			return 'A';
		case COMP_ISARCSTART :
			return 'S';
		case COMP_ISARCEND :
			return 'E';
		case COMP_ISARCCOMP :
			return 'C';
		default :
			return 'L';
	}
}

#ifdef __STDC__
void aigetdate(char *date)
#else
void aigetdate(date)
char *date;
#endif
{
	time_t timer;
	struct tm * tmtime;

	time(&timer);
	tmtime = localtime(&timer);
	(void)sprintf(date, "%02d/%02d/%02d", tmtime->tm_mday,
				  tmtime->tm_mon + 1, tmtime->tm_year);
}

#ifdef __STDC__
int saveaiicon(IconGate_list * icon_gate)
#else
int saveaiicon(icon_gate)
IconGate_list * icon_gate;
#endif
{
	FILE * out;
	char filename[ICON_BUFSIZE], buf[ICON_BUFSIZE];
	double scale;
	
	sprintf(filename, "%s/%s.%s", WORK_LIB, ICONGATE_MODELNAME(icon_gate), ICON_OUT);
	if ((out = (FILE *)fopen(filename, "r")) != NULL)
	{
		fclose (out);
		sprintf(buf,  "%s/%s.old.%s", WORK_LIB, ICONGATE_MODELNAME(icon_gate), ICON_OUT);
		if (link(filename, buf) != 0)
		{
			unlink(buf);
			link(filename, buf);
		}
		unlink(filename);
	}
	if ((out = (FILE *)fopen(filename, "w")) == NULL)
	{
		fprintf (stderr, "\n*** Icon Error *** saveicon (ai) impossible : Unable to write file %s\n", filename);
		return PROBLEM;
	}

	/*init temp variables */
	scale = ICONGATE_SCALE(icon_gate);

	/* write header */
	fprintf(out, "V ALLIANCE : 2\n");
	aigetdate(buf);
	fprintf (out, "H %s,I,%s\n", ICONGATE_MODELNAME(icon_gate), buf);
	
	/* write icon gate information */
	fprintf (out, "B %d,%d,%d,%d\n",
			 UNSCALE_TO_INT(scale, ICONGATE_X(icon_gate)) / SCALE_X,
			 UNSCALE_TO_INT(scale, ICONGATE_Y(icon_gate)) / SCALE_X,
			 UNSCALE_TO_INT(scale, ICONGATE_WIDTH(icon_gate)) / SCALE_X,
			 UNSCALE_TO_INT(scale, ICONGATE_HEIGHT(icon_gate)) / SCALE_X);
	fprintf (out, "M %d,%d,%c%c,%c\n",
			 UNSCALE_TO_INT(scale, ICONGATE_X_MODELNAME(icon_gate)) / SCALE_X,
			 UNSCALE_TO_INT(scale, ICONGATE_Y_MODELNAME(icon_gate)) / SCALE_X,
			 HAlignToAi(ICONGATE_HALIGN_MODELNAME(icon_gate)),
			 VAlignToAi(ICONGATE_VALIGN_MODELNAME(icon_gate)),
			 DirectionToAi(ICONGATE_DIRECTION_MODELNAME(icon_gate)));
	fprintf (out, "I %d,%d,%c%c,%c\n",
			 UNSCALE_TO_INT(scale, ICONGATE_X_INSNAME(icon_gate)) / SCALE_X,
			 UNSCALE_TO_INT(scale, ICONGATE_Y_INSNAME(icon_gate)) / SCALE_X,
			 HAlignToAi(ICONGATE_HALIGN_INSNAME(icon_gate)),
			 VAlignToAi(ICONGATE_VALIGN_INSNAME(icon_gate)),
			 DirectionToAi(ICONGATE_DIRECTION_INSNAME(icon_gate)));
	fprintf (out, "T %d,%d,%c%c,%c\n",
			 UNSCALE_TO_INT(scale, ICONGATE_X_LABEL(icon_gate)) / SCALE_X,
			 UNSCALE_TO_INT(scale, ICONGATE_Y_LABEL(icon_gate)) / SCALE_X,
			 HAlignToAi(ICONGATE_HALIGN_LABEL(icon_gate)),
			 VAlignToAi(ICONGATE_VALIGN_LABEL(icon_gate)),
			 DirectionToAi(ICONGATE_DIRECTION_LABEL(icon_gate)));

	/* reverse all list */
	ICONGATE_LINES(icon_gate) = (IconLine_list *)reverse((chain_list *)ICONGATE_LINES(icon_gate));
	ICONGATE_SHAPES(icon_gate) = (IconShape_list *)reverse((chain_list *)ICONGATE_SHAPES(icon_gate));
	ICONGATE_CIRCLES(icon_gate) = (IconCircle_list *)reverse((chain_list *)ICONGATE_CIRCLES(icon_gate));
	ICONGATE_ARCS(icon_gate) = (IconArc_list *)reverse((chain_list *)ICONGATE_ARCS(icon_gate));
	ICONGATE_CONNECTORS(icon_gate) = (IconCon_list *)reverse((chain_list *)ICONGATE_CONNECTORS(icon_gate));
	/* write connectors */
	{
		IconCon_list * iconcon;
		
		for (iconcon = ICONGATE_CONNECTORS(icon_gate); iconcon; iconcon = ICONCON_NEXT(iconcon))
		{
			fprintf (out, "C %d,%d,%c,%s,%s,%d,%d,%c%c,%c\n",
					 UNSCALE_TO_INT(scale, ICONCON_X(iconcon)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONCON_Y(iconcon)) / SCALE_X,
					 SideToAi(ICONCON_SIDE(iconcon)),
					 LoDirToAi(ICONCON_DIRECTION(iconcon)),
					 ICONCON_NAME(iconcon),
					 UNSCALE_TO_INT(scale, ICONCON_X_NAME(iconcon)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONCON_Y_NAME(iconcon)) / SCALE_X,
					 HAlignToAi(ICONCON_HALIGN_NAME(iconcon)),
					 VAlignToAi(ICONCON_VALIGN_NAME(iconcon)),
					 DirectionToAi(ICONCON_DIRECTION_NAME(iconcon)));
		}
	}
	/* write lines */
	{
		IconLine_list * iconline;
		
		for (iconline = ICONGATE_LINES(icon_gate); iconline; iconline = ICONLINE_NEXT(iconline))
		{
			fprintf (out, "L %d,%d,%d,%d\n",
					 UNSCALE_TO_INT(scale, ICONLINE_X0(iconline)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONLINE_Y0(iconline)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONLINE_X1(iconline)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONLINE_Y1(iconline)) / SCALE_X);
		}
	}
	
	/* write shapes */
	{
		IconShape_list * iconshape;
		IconComp_list * iconcomp;
		
		for (iconshape = ICONGATE_SHAPES(icon_gate); iconshape; iconshape = ICONSHAPE_NEXT(iconshape))
		{
			fprintf (out, "S %d\n", ICONSHAPE_NBCOMP(iconshape));
			
			for (iconcomp = ICONSHAPE_FIRSTCOMP(iconshape); iconcomp;
				 iconcomp = ICONSHAPE_NEXTCOMP(iconcomp))
			{
				fprintf (out, "P %d,%d,%c\n",
						 UNSCALE_TO_INT(scale, ICONSHAPE_X_COMP(iconcomp)) / SCALE_X,
						 UNSCALE_TO_INT(scale, ICONSHAPE_Y_COMP(iconcomp)) / SCALE_X,
						 TypeToAi(ICONSHAPE_TYPE_COMP(iconcomp)));
			}
		}
	}
	
	/* write circles */
	{
		IconCircle_list * iconcircle;
		
		for (iconcircle = ICONGATE_CIRCLES(icon_gate); iconcircle; iconcircle = ICONCIRCLE_NEXT(iconcircle))
		{
			fprintf (out, "R %d,%d,%d,%d\n",
					 UNSCALE_TO_INT(scale, ICONCIRCLE_X0(iconcircle)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONCIRCLE_Y0(iconcircle)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONCIRCLE_WIDTH(iconcircle)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONCIRCLE_HEIGHT(iconcircle)) / SCALE_X);
		}
	}
	
	/* write arcs */
	{
		IconArc_list * iconarc;

		for (iconarc = ICONGATE_ARCS(icon_gate); iconarc; iconarc = ICONARC_NEXT(iconarc))
		{
			fprintf (out, "A %d,%d,%d,%d,%d,%d\n",
					 UNSCALE_TO_INT(scale, ICONARC_X0(iconarc)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONARC_Y0(iconarc)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONARC_WIDTH(iconarc)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONARC_HEIGHT(iconarc)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONARC_ANGLE1(iconarc)) / SCALE_X,
					 UNSCALE_TO_INT(scale, ICONARC_ANGLE2(iconarc)) / SCALE_X);
		}
	}
	/* reverse all list */
	ICONGATE_LINES(icon_gate) = (IconLine_list *)reverse((chain_list *)ICONGATE_LINES(icon_gate));
	ICONGATE_SHAPES(icon_gate) = (IconShape_list *)reverse((chain_list *)ICONGATE_SHAPES(icon_gate));
	ICONGATE_CIRCLES(icon_gate) = (IconCircle_list *)reverse((chain_list *)ICONGATE_CIRCLES(icon_gate));
	ICONGATE_ARCS(icon_gate) = (IconArc_list *)reverse((chain_list *)ICONGATE_ARCS(icon_gate));
	ICONGATE_CONNECTORS(icon_gate) = (IconCon_list *)reverse((chain_list *)ICONGATE_CONNECTORS(icon_gate));

	/* write end of file, and close it */
	fprintf (out, "EOF\n");
	fclose (out);
	return OK;
} /* saveaiicon */
