/****************************************************************************/
/*                                                                          */
/*                      ALLIANCE CAO & VLSI CAD                             */
/*                                                                          */
/*    Product : (S)ymbolic (2)to (R)eal translater                          */
/*    File    : main.c                                                      */
/*                                                                          */
/*    (c) copyright 1992 MASI laboratory CAO & VLSI team                    */
/*    All Right Reserved                                                    */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/****************************************************************************/
/*                                                                          */
/*              Main of Symbolic to Real                                    */
/*                                                                          */
/****************************************************************************/

#ident "@(#)s2r 3.1 1/12/94 ALLIANCE 2.0 (S)ymbolic (2)to (R)eal converter"

#include "generic.h"
#include  MPH_H
#include  MUT_H
#include  RDS_H
#include  RUT_H
#include  RTL_H
#include  RFM_H
#include  RPR_H
#include "rdsacces+.h"
#include "statistics.h"
#include "postrat.h"

main(argc, argv)
int  argc;
char  **argv;
{
  rdsfig_list *rds_model;
  rdsfig_list *Figure;
  phfig_list  *mbk_model;

/*\
 * banner and parameters 
\*/

  char *source_name     = NULL; /* need default values */
  char *result_name     = NULL; /* need default values */
  int  root_conn        = 1;    /* keep top-level figure connectors by default */
  int  scotch_on        = 1;    /* scotchs are not created by default */
  int  one_level        = 0;    /* all hierarchy level translated by default */
  int  do_post_treat    = 1;    /* post-treatment is done by default */
  int  do_replace_cells = 1;    /* cells_replacement is done by default */
  int  verbose          = 0;    /* verbose mode desarmed by default */
  int  flat             = 0;    /* flat mode desarmed by default */
  int  physical         = 0;    /* physical mode desarmed by default */
  int  split_layer      = 0;    /* split_layer mode desarmed by default */

  alliancebanner("s2r", VERSION, "Symbolic to Real layout converter", 
                 "91-94", ALLIANCE_VERSION);

  if(argc < 2) {
    USAGE:
    fprintf(stderr, "\tUsage : %s [-cs1trv] source [result]\n\n", argv[0]);
/*
 *  fprintf(stderr, "\tUsage : %s [-cs1trvlfp] source [result]\n\n", argv[0]);
 */
    fprintf(stderr, "\tsource\t: filename of symbolic layout circuit\n");
    fprintf(stderr, "\t\t  to translate to real layout\n");
    fprintf(stderr, "\tresult\t: result filename of real layout circuit\n");
    fprintf(stderr, "\t\t  source name is used, if result is absent\n\n");
    fprintf(stderr, "\toptionnal options (any order, any occurence) :\n");
    fprintf(stderr, "\t-c\t: deletes top-level (c)onnectors\n");
    fprintf(stderr, "\t-s\t: (s)cotchs are not created\n");
    fprintf(stderr, "\t-1\t: only (1) level is translated, all otherwise.\n");
    fprintf(stderr, "\t-t\t: layout is just (t)ranslated, not post-treated\n");
    fprintf(stderr, "\t-r\t: black boxes are not (r)eplaced\n");
    fprintf(stderr, "\t-v\t: (v)erbose mode armed\n");
/*
 *  fprintf(stderr, "\t-f\t: (f)lattening before post-treating\n");
 *  fprintf(stderr, "\t-p\t: (p)hysical format parsing\n");
 *  fprintf(stderr, "\t-l\t: split (l)ayers\n\n");
 */
    exit(1);
  }

  {
    int shift = 1;
    for (; shift < argc; shift++) {
      char *arg = argv[shift];
      if (*arg == '-') {
	while (*++arg) {
	  switch (*arg) {
	    case 'c': root_conn        = 0; break;
	    case 's': scotch_on        = 0; break;
	    case '1': one_level        = 1; break;
	    case 't': do_post_treat    = 0; break;
	    case 'r': do_replace_cells = 0; break;
	    case 'v': verbose          = 1; break;
	    case 'l': split_layer      = 1; break;
	    case 'f': flat             = 1; break;
	    case 'p': physical         = 1; break;
	    default : goto USAGE ;
	  }
	}
      } else {
	if ( !source_name)
	  source_name = namealloc(argv[shift]);
	else if ( !result_name)
	  result_name = namealloc(argv[shift]);
	else
	  goto USAGE ;
	continue;
      }
    }
    if ( !result_name) {
       result_name = source_name;
    }
  }

/*\
 * setting environement 
 * MBK_CATAL_NAME    : file where file name to be replaced are put
 * MBK_CATA_LIB      : where cells, catal file and techno file are
 * MBK_WORK_LIB      : where result file is written or where techno file is
 *                     WORK_LIB is watched before CATA_LIB
 * MBK_WORK_LIB      : where result file is placed
 * MBK_IN_PH         : file format of symbolic figure
 * RDS_TECHNO_NAME   : techno file name
 * RDS_IN            : file format of real figures to replace
 * RDS_OUT           : file format of result file
\*/
  mbkenv();
  rdsenv();

/*\
 * Read the techno file 
\*/
  printf("\n\to loading technology file : %s\n", RDS_TECHNO_NAME);
  fflush(stdout);
  loadrdsparam();

/*\
 * Read the model file 
\*/
  if (physical) {

    printf("\to loading %s level of real layout : %s\n", 
	   one_level ? "one" : "all", source_name);
    fflush(stdout);
    rds_model = getrdsfig( source_name, one_level ? 'P':'A', 0 );

  } else {

    printf("\to loading %s level of symbolic layout : %s\n", 
	   one_level ? "one" : "all", source_name);
    fflush(stdout);

    mbk_model = getphfig(source_name, 'A');
    if(!root_conn)
      mbk_model->PHCON = NULL;
    rds_model = S2Rfigmbkrds( mbk_model, one_level ? 0 : 1 );

    /* Removing symbolic data structure */

    printf("\to removing symbolic data structure \n");
    rds_mbk_kill();
  }

/*\
 * flattening
\*/
  if (flat) {
        printf("\to flattening figure\n");
	rflattenrdsfig( rds_model, RDS_NO, RDS_NO );
  }

/*\
 * post treatement 
\*/
  rds_model = rds_model_out( source_name);

  if(do_post_treat) {
    printf("\to layout post-treating ");
    if( root_conn) printf("with connectors, ");
    else           printf("without connector, ");
    if( scotch_on) printf("with scotchs.\n");
    else           printf("without scotch.\n");
    post_treat( rds_model, scotch_on, verbose);
    fflush(stdout);
  } 

/*\
 * Replace cells 
\*/

  if(do_replace_cells) {
    replace_cells(verbose);
  }

/*\
 * save file 
\*/
  printf("\to saving %s.%s\n", result_name,RDS_OUT);
  rds_model->NAME = result_name;

  if (split_layer) {

    char *RDS_CIF_LAYER_TABLE_BAK [ RDS_MAX_LAYER ][ RDS_CIF_LAYER_FIELD ];
    char  RDS_GDS_LAYER_TABLE_BAK [ RDS_MAX_LAYER ][ RDS_GDS_LAYER_FIELD ];
    char  WORK_LIB_TMP [256];
    char  WORK_LIB_BAK [256];
    int   layer;

    strcpy( WORK_LIB_BAK, WORK_LIB);
    for ( layer = 0; layer < RDS_MAX_LAYER; layer++ ) {
      *strchr( RDS_LAYER_NAME [layer], ' ') = '\0';
      RDS_CIF_LAYER_TABLE_BAK [layer] [0] = RDS_CIF_LAYER_TABLE [layer] [0];
      RDS_GDS_LAYER_TABLE_BAK [layer] [0] = RDS_GDS_LAYER_TABLE [layer] [0];
      RDS_GDS_LAYER_TABLE [layer] [0] = RDS_GDS_LAYER_EMPTY;
      RDS_CIF_LAYER_TABLE [layer] [0] = RDS_CIF_LAYER_EMPTY;
    }
    for ( layer = 0; layer < RDS_MAX_LAYER; layer++ ) {
      if (!strcmp( RDS_OUT, "gds")) {
	if ( RDS_GDS_LAYER_TABLE_BAK [layer] [0] != RDS_GDS_LAYER_EMPTY ) {

	  sprintf( WORK_LIB_TMP, "%s/%s/", WORK_LIB_BAK, RDS_LAYER_NAME[layer]);
	  WORK_LIB = WORK_LIB_TMP;
	  if (verbose) {printf("\t  - %s\n",WORK_LIB); fflush(stdout);}

	  RDS_GDS_LAYER_TABLE [layer] [0] = RDS_GDS_LAYER_TABLE_BAK [layer] [0];
	  saverdsfig( rds_model );
	  RDS_GDS_LAYER_TABLE [layer] [0] = RDS_GDS_LAYER_EMPTY;
	}
      } else {
	if ( RDS_CIF_LAYER_TABLE_BAK [layer] [0] != RDS_CIF_LAYER_EMPTY ) {

	  sprintf( WORK_LIB_TMP, "%s/%s/", WORK_LIB_BAK, RDS_LAYER_NAME[layer]);
	  WORK_LIB = WORK_LIB_TMP;
	  if (verbose) {printf("\t  - %s\n",WORK_LIB); fflush(stdout);}

	  RDS_CIF_LAYER_TABLE [layer] [0] = RDS_CIF_LAYER_TABLE_BAK [layer] [0];
	  saverdsfig( rds_model );
	  RDS_CIF_LAYER_TABLE [layer] [0] = RDS_CIF_LAYER_EMPTY;
	}
      }
    }
  } else 
    saverdsfig( rds_model );
  
  if( verbose)
    print_statistics(scotch_on); 

  return(0);
}
