
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include MUT_H
#include RSA_H

#define  TRUE   (1)
#define  FALSE  (0)

/*
 *      Les seules raisons d'etre de la fonction main() est de commencer un programme, et de verifier les parametres d'entrees
 *   et pour finir d'appeler la fonction principale.
 */
 


main(argc,argv)
int argc;
char *argv[];
{
 int   i,ind;
 char *s;

 int   n,cin,cout,overn,over,not;
 int   csa,sub,addsub;
 int   deci,stretch,stretch2;
 char  *name ;
 int   msb0,virtual;
 int   layout,icon,vhdl,patterns,datasheet,outline, netlist,perf;


   if(argc==1){
      fprintf(stderr, "Usage : rsa bits [-cin] [-cout] [-overn] [-not]\n" ) ;
      fprintf(stderr, "                 [-csa] [-sub] [-addsub]\n" ) ;
      fprintf(stderr, "                 [-over] [-deci] [-stretch] [-strech2]\n" ) ;
      fprintf(stderr, "                 [-msb0] [-virtual]\n" ) ;
      fprintf(stderr, "                 [-layout] [-icon] [-vhdl] [-patterns] [-datasheet]\n");
      fprintf(stderr, "                 [-physicalbox] [-logicalbox] [-perf]\n");
      fprintf(stderr, "                 [-o blockname]\n" ) ;
      exit(1);
     }

   for(s=argv[1];*s!='\0';s++)
      if(*s<'0' || *s>'9'){
         fprintf(stderr,"The first argument must be a number of bits\n");
         exit(2);
        }

   n=atoi(argv[1]);

   cin=cout=over=overn=not=FALSE;
   csa=sub=addsub=FALSE;
   deci=stretch=stretch2=FALSE;
   name=NULL;
   msb0=virtual=FALSE;
   layout=icon=vhdl=patterns=datasheet=outline=netlist=perf=FALSE;

   for(ind=2;ind<argc;ind++)
      if( strcmp( argv[ ind ], "-cin" ) == 0 )    cin = TRUE ;
      else
      if( strcmp( argv[ ind ], "-cout" ) == 0 )    cout = TRUE ;
      else
      if( strcmp( argv[ ind ], "-overn" ) == 0 )    overn = TRUE ;
      else
      if( strcmp( argv[ ind ], "-over" ) == 0 )    over = TRUE ;
      else
      if( strcmp( argv[ ind ], "-not" ) == 0 )    not = TRUE ;
      else
      if( strcmp( argv[ ind ], "-csa" ) == 0 )    csa = TRUE ;
      else
      if( strcmp( argv[ ind ], "-sub" ) == 0 )    sub = TRUE ;
      else
      if( strcmp( argv[ ind ], "-addsub" ) == 0 )    addsub = TRUE ;
      else
      if( strcmp( argv[ ind ], "-deci" ) == 0 )    deci = TRUE ;
      else
      if( strcmp( argv[ ind ], "-stretch" ) == 0 )    stretch = TRUE ;
      else
      if( strcmp( argv[ ind ], "-stretch2" ) == 0 )    stretch2 = TRUE ;
      else
      if(strcmp(argv[ind],"-o")==0)
         if(++ind==argc) {
            fprintf( stderr, "A name must be specified after -o option\n" ) ;
            exit( 3 ) ;
           }
         else name=argv[ind];
      else
      if( strcmp( argv[ ind ], "-msb0" ) == 0 )    msb0 = TRUE ;
      else
      if( strcmp( argv[ ind ], "-virtual" ) == 0 )    virtual = TRUE ;
      else
      if( strcmp( argv[ ind ], "-layout" ) == 0 )    layout = TRUE ;
      else
      if( strcmp( argv[ ind ], "-icon" ) == 0 )    icon = TRUE ;
      else
      if( strcmp( argv[ ind ], "-vhdl" ) == 0 )   vhdl = TRUE ;
      else
      if( strcmp( argv[ ind ], "-patterns" ) == 0 )    patterns = TRUE ;
      else
      if( strcmp( argv[ ind ], "-datasheet" ) == 0 )    datasheet = TRUE ;
      else
      if( strcmp( argv[ ind ], "-logicalbox" ) == 0 )    netlist = TRUE ;
      else
      if( strcmp( argv[ ind ], "-physicalbox" ) == 0 )   outline = TRUE ;
      else
      if( strcmp( argv[ ind ], "-perf" ) == 0 )    perf = TRUE ;
      else
          {
             fprintf( stderr, "Invalid parameter : %s\n", argv[ ind ] ) ;
             exit( 4 ) ;
          }

   alliancebanner("RSA","3.00","Recurrence Solver Adder","1990-91-92-93",ALC);

   rsa(n,cin,cout,overn,not,
         csa,sub,addsub,
         over,deci,stretch,stretch2,
         msb0,virtual,
         layout,icon,vhdl,patterns,datasheet,
         outline,netlist,perf,
         name);

   return 0 ;
}
