/*******************************************************************/
/*******************************************************************/
/**                                                               **/
/**  RFG_VHDL                                                     **/
/**                                                               **/
/**  Version 6.03                                                 **/
/**                                                               **/
/*******************************************************************/
/*******************************************************************/

static char *ident_vhdl="@(#)(RFG) VHDL view generation, version 6.03 (03/12/1993)";

/*******************************************************************/
/* DEC_BIN ( val, max_bit, result )                                */
/*******************************************************************/

static void rfg_dec_bin(val, max_bit, result)
  long val, max_bit;
  char *result;

{
/* Convert val in a binary string [max_bit .. 0]. */
long i;

for(i=max_bit; i>=0; i--)
  {
  result[i]='0'+(val&1);
  val>>=1;
  }
result[max_bit+1]=0;
}

/*******************************************************************/
/* DEC_BIN_DECO ( val, max_bit, result )                           */
/*******************************************************************/

static void rfg_dec_bin_deco(val, max_bit, result)
  long val, max_bit;
  char *result;

{
/* generate a string of binary value : [max_bit .. 0].     */
/* if val >= 0 : put '0' in val position all other are '1' */
/* else all are '1'                                        */
long i;

for(i=max_bit; i>=0; i--)
  result[i]='1';
if(val>=0)
  result[max_bit-val]='0';
result[max_bit+1]=0;
}

/*******************************************************************/
/*******************************************************************/
/**                                                               **/
/**  RFG_VHDL ( width, high, n_bus, flip_flop, inverse_data,      **/
/**             low_power, write_enable, inverse_we, stuck, msb,  **/
/**             block_type )                                      **/
/**                                                               **/
/*******************************************************************/
/*******************************************************************/

static void rfg_vhdl (width, high, n_bus, flip_flop /*, inverse_data*/ ,
               low_power, write_enable, inverse_we, stuck, msb,
               block_type)

  long width, high, n_bus, flip_flop /*, inverse_data*/ ;
  long low_power, write_enable, inverse_we, stuck, msb;
  long block_type;

{
long i, j;

char addr_bin[rfg_sba];
char word_err[rfg_sbw];
char word_stuck[rfg_sbw];
char deco_bin[rfg_sbd];

FILE *out_vbe;

/********** Create comportemental file **********/

if((out_vbe=mbkfopen(rfg_name_pref, "vbe", "w"))==NULL)
  {
  (void) fprintf(stderr, "Unable to open output file \"%s.%s\" !!!\n", rfg_name_pref, "vbe");
  exit(1);
  }

(void) fprintf  (out_vbe, "---------------------------------------------------------\n");
if((block_type==rfg_reg_only) || (block_type==rfg_reg_sep))
  (void) fprintf(out_vbe, "----------------  Registers description  ----------------\n");
if(block_type==rfg_dec_sep)
  (void) fprintf(out_vbe, "----------------  Decoders  description  ----------------\n");
if(block_type==rfg_bank)
  (void) fprintf(out_vbe, "----------------    Bank  description    ----------------\n");
(void) fprintf  (out_vbe, "---------------------------------------------------------\n\n");


(void) fprintf(out_vbe, "-- To use this file out of ASIMUT, supress \"--\" in the two following lines\n");
(void) fprintf(out_vbe, "-- LIBRARY pkg;\n");
(void) fprintf(out_vbe, "-- USE pkg.p6b_pkg.all;\n\n");

/********** Declare connectors. **********/

(void) fprintf(out_vbe, "ENTITY %s IS\n", rfg_name_pref);
(void) fprintf(out_vbe, "  PORT(\n");

     /***** First connector. *****/
RFG_FIRST_CON();

#ifdef rfg_alims_vbe
if(RFG_TEST_CON())
#else
if((RFG_TEST_CON()) && (RFG_CON_TYPE()&rfg_con_supply))
#endif

  {
  if(RFG_CON_VECTOR())
    (void) fprintf(out_vbe, "    %s : %s BIT_VECTOR (%ld %s %ld)",
      RFG_CON_NAME(),
      RFG_CON_TYPE()&rfg_con_in ? "IN" : "OUT",
      RFG_CON_START_INDEX(), RFG_CON_TEST_INDEX() ? "to" : "downto", RFG_CON_END_INDEX());
  else
    (void) fprintf(out_vbe, "    %s : %s BIT", RFG_CON_NAME(),
      RFG_CON_TYPE()&rfg_con_in ? "IN" : "OUT");
  RFG_NEXT_CON();
  }

     /***** Other connectors. *****/
for(; RFG_TEST_CON(); RFG_NEXT_CON())
  {

#ifndef rfg_alims_vbe
  if(!(RFG_CON_TYPE()&rfg_con_supply))
#endif

    {
    if(RFG_CON_VECTOR())
      (void) fprintf(out_vbe, ";\n    %s : %s BIT_VECTOR (%ld %s %ld)",
        RFG_CON_NAME(),
        RFG_CON_TYPE()&rfg_con_in ? "IN" : "OUT",
        RFG_CON_START_INDEX(), RFG_CON_TEST_INDEX() ? "to" : "downto", RFG_CON_END_INDEX());
    else
      (void) fprintf(out_vbe, ";\n    %s : %s BIT", RFG_CON_NAME(),
        RFG_CON_TYPE()&rfg_con_in ? "IN" : "OUT");
    }
  }

(void) fprintf(out_vbe, "\n  );\n");
(void) fprintf(out_vbe, "END %s;\n\n", rfg_name_pref);

(void) fprintf(out_vbe, "ARCHITECTURE dataflow_view OF %s IS\n", rfg_name_pref);

/********** Declare internal signals. **********/

if((block_type==rfg_dec_sep) || (block_type==rfg_bank))
  {
  if(write_enable)
    (void) fprintf(out_vbe, "  SIGNAL val_we : BIT;\n");
  }

if(block_type==rfg_bank)
  {
  (void) fprintf(out_vbe, "  SIGNAL r_a : BIT_VECTOR (0 to %ld);\n", width-1);
  if(n_bus)
    (void) fprintf(out_vbe, "  SIGNAL r_b : BIT_VECTOR (0 to %ld);\n", width-1);
  if(rfg_nbr_block)
    {
    (void) fprintf(out_vbe, "  SIGNAL s_a : BIT_VECTOR (0 to %ld);\n", rfg_nbr_block);
    if(n_bus)
      (void) fprintf(out_vbe, "  SIGNAL s_b : BIT_VECTOR (0 to %ld);\n", rfg_nbr_block);
    }
  (void) fprintf(out_vbe, "  SIGNAL w : BIT_VECTOR (0 to %ld);\n", width-1);
  if(flip_flop)
    {
    (void) fprintf(out_vbe, "  SIGNAL w_r_a : BIT;\n");
    if(n_bus)
      (void) fprintf(out_vbe, "  SIGNAL w_r_b : BIT;\n");
    }
  }

if((block_type==rfg_reg_only) || (block_type==rfg_reg_sep))
  {
  (void) fprintf(out_vbe, "  SIGNAL test_r_a : BIT_VECTOR (0 to %ld);\n", rfg_nbr_block);
  if(n_bus)
    (void) fprintf(out_vbe, "  SIGNAL test_r_b : BIT_VECTOR (0 to %ld);\n", rfg_nbr_block);
  if(width>rfg_wblock)
    {
    (void) fprintf(out_vbe, "  SIGNAL test_s_a : BIT;\n");
    if(n_bus)
      (void) fprintf(out_vbe, "  SIGNAL test_s_b : BIT;\n");
    }
  }

if((block_type==rfg_reg_only) || (block_type==rfg_reg_sep) || (block_type==rfg_bank))
  {
  (void) fprintf(out_vbe, "  SIGNAL val_in : BIT_VECTOR (0 to %ld);\n", high-1);
  if(stuck)
    i=1;
  else
    i=0;
  for(; i<width; i++)
    (void) fprintf(out_vbe, "  SIGNAL latch%ld : REG_VECTOR (0 to %ld) REGISTER;\n", i, high-1);
  (void) fprintf(out_vbe, "  SIGNAL val_r_a : BIT_VECTOR (0 to %ld);\n", high-1);
  if(n_bus)
    (void) fprintf(out_vbe, "  SIGNAL val_r_b : BIT_VECTOR (0 to %ld);\n", high-1);
  if(flip_flop)
    {
    (void) fprintf(out_vbe, "  SIGNAL latch_out_a : REG_VECTOR (0 to %ld) REGISTER;\n", high-1);
    if(n_bus)
      (void) fprintf(out_vbe, "  SIGNAL latch_out_b : REG_VECTOR (0 to %ld) REGISTER;\n", high-1);
    }
  }

(void) fprintf(out_vbe, "BEGIN\n\n");

/********** Decoders part. **********/

if((block_type==rfg_dec_sep) || (block_type==rfg_bank))
  {
  (void) fprintf(out_vbe, "  ----------------  Decoders  part  ----------------\n\n");
  if(write_enable)
    if(inverse_we)
      (void) fprintf(out_vbe, "  val_we <= NOT(we);\n\n");
    else
      (void) fprintf(out_vbe, "  val_we <= we;\n\n");

  for(i=0; i<width; i++)
    {
    rfg_dec_bin(i, rfg_addr_size, addr_bin);
    if(write_enable)
      (void) fprintf(out_vbe, "  w(%ld) <= '0' WHEN (ck_m='1' AND val_we='1' AND ad_w=\"%s\") ELSE '1';\n",
        i, addr_bin);
    else
      (void) fprintf(out_vbe, "  w(%ld) <= '0' WHEN (ck_m='1' AND ad_w=\"%s\") ELSE '1';\n", i, addr_bin);

    if(low_power)
      {
      rfg_dec_bin(i, rfg_addr_size, addr_bin);
      (void) fprintf(out_vbe, "  r_a(%ld) <= '0' WHEN (ad_r_a=\"%s\") ELSE '1';\n", i, addr_bin);
      if(n_bus)
        (void) fprintf(out_vbe, "  r_b(%ld) <= '0' WHEN (ad_r_b=\"%s\") ELSE '1';\n", i, addr_bin);
      }
    else
      {
      rfg_dec_bin(i%rfg_wblock, rfg_nand_l, addr_bin);
      if(msb)
        (void) fprintf(out_vbe, "  r_a(%ld) <= '0' WHEN (ad_r_a(%ld to %ld)=\"%s\") ELSE '1';\n",
          i, rfg_addr_size-rfg_nand_l, rfg_addr_size, addr_bin);
      else
        (void) fprintf(out_vbe, "  r_a(%ld) <= '0' WHEN (ad_r_a(%ld downto %ld)=\"%s\") ELSE '1';\n",
          i, rfg_nand_l, 0L, addr_bin);
      if(n_bus)
        if(msb)
          (void) fprintf(out_vbe, "  r_b(%ld) <= '0' WHEN (ad_r_b(%ld to %ld)=\"%s\") ELSE '1';\n",
            i, rfg_addr_size-rfg_nand_l, rfg_addr_size, addr_bin);
        else
          (void) fprintf(out_vbe, "  r_b(%ld) <= '0' WHEN (ad_r_b(%ld downto %ld)=\"%s\") ELSE '1';\n",
            i, rfg_nand_l, 0L, addr_bin);
      }
    }
  (void) fprintf(out_vbe, "\n");

  if(rfg_nbr_block>0)
    {
    for(i=0; i<=rfg_nbr_block; i++)
      {
      rfg_dec_bin(i, rfg_addr_size-4L, addr_bin);
      if(msb)
        (void) fprintf(out_vbe, "  s_a(%ld) <= '0' WHEN (ad_r_a(%d to %ld)=\"%s\") ELSE '1';\n",
          i, 0L, rfg_addr_size-4L, addr_bin);
      else
        (void) fprintf(out_vbe, "  s_a(%ld) <= '0' WHEN (ad_r_a(%d downto %ld)=\"%s\") ELSE '1';\n",
          i, rfg_addr_size, 4L, addr_bin);
    if(n_bus)
      if(msb)
        (void) fprintf(out_vbe, "  s_b(%ld) <= '0' WHEN (ad_r_b(%d to %ld)=\"%s\") ELSE '1';\n",
          i, 0L, rfg_addr_size-4L, addr_bin);
      else
        (void) fprintf(out_vbe, "  s_b(%ld) <= '0' WHEN (ad_r_b(%d downto %ld)=\"%s\") ELSE '1';\n",
          i, rfg_addr_size, 4L, addr_bin);
      }
    (void) fprintf(out_vbe, "\n");
    }
  
  if(flip_flop)
    {
    (void) fprintf(out_vbe, "  w_r_a <= NOT(NOT(ck_m));\n");
    if(n_bus)
      (void) fprintf(out_vbe, "  w_r_b <= NOT(NOT(ck_m));\n");
    }
  (void) fprintf(out_vbe, "\n");
  }

/********** Registers part. **********/

if((block_type==rfg_reg_only) || (block_type==rfg_reg_sep) || (block_type==rfg_bank))
  {
  (void) fprintf(out_vbe, "  ----------------  Registers part  ----------------\n\n");
  if(stuck)
    if((high-1)<=rfg_long_bits)
      {
      rfg_dec_bin(rfg_low_high_cell==0L ? 0L : ~0L, high-1, word_stuck);
      }
    else
      {
      rfg_dec_bin(rfg_low_high_cell==0L ? 0L : ~0L, (high-1)-rfg_long_bits, word_stuck);
      rfg_dec_bin(rfg_low_high_cell==0L ? 0L : ~0L, rfg_long_bits-1L, &(word_stuck[high-rfg_long_bits]));
      }

  if((high-1)<=rfg_long_bits)
    {
    rfg_dec_bin(rfg_err_pattern, high-1, word_err);
    }
  else
    {
    rfg_dec_bin(rfg_err_pattern, (high-1)-rfg_long_bits, word_err);
    rfg_dec_bin(rfg_err_pattern, rfg_long_bits-1L, &(word_err[high-rfg_long_bits]));
    }

  if(rfg_inv_data_cell)
    (void) fprintf(out_vbe, "  val_in <= in_a;\n\n");
  else
    (void) fprintf(out_vbe, "  val_in <= NOT (in_a);\n\n");

  if(stuck)
    i=1;
  else
    i=0;
  for(; i<width; i++)
    {
    (void) fprintf(out_vbe, "  l_%ld : BLOCK (w(%ld)='0') BEGIN\n", i, i);

#ifdef rfg_convert
    (void) fprintf(out_vbe, "    latch%ld <= GUARDED convert(val_in);\n", i);
#else
    (void) fprintf(out_vbe, "    latch%ld <= GUARDED val_in;\n", i);
#endif

    (void) fprintf(out_vbe, "  END BLOCK;\n");
    }
  (void) fprintf(out_vbe, "\n");

  if(rfg_nbr_block)
    {

#ifdef rfg_convert
    if(stuck)
      (void) fprintf(out_vbe, "  val_r_a <= convert(\"%s\") WHEN (r_a(0)='0' AND s_a(0)='0') ELSE\n",
        word_stuck);
    else
      (void) fprintf(out_vbe, "  val_r_a <= convert(latch0) WHEN (r_a(0)='0' AND s_a(0)='0') ELSE\n");
#else
    if(stuck)
      (void) fprintf(out_vbe, "  val_r_a <= \"%s\" WHEN (r_a(0)='0' AND s_a(0)='0') ELSE\n",
        word_stuck);
    else
      (void) fprintf(out_vbe, "  val_r_a <= latch0 WHEN (r_a(0)='0' AND s_a(0)='0') ELSE\n");
#endif

    for(i=1; i<width; i++)

#ifdef rfg_convert
      (void) fprintf(out_vbe, "             convert(latch%ld) WHEN (r_a(%ld)='0' AND s_a(%ld)='0') ELSE\n", i, i, i/rfg_wblock);
#else
      (void) fprintf(out_vbe, "             latch%ld WHEN (r_a(%ld)='0' AND s_a(%ld)='0') ELSE\n", i, i, i/rfg_wblock);
#endif

    (void) fprintf  (out_vbe, "             \"%s\";\n", word_err);

    if(n_bus)
      {

#ifdef rfg_convert
    if(stuck)
      (void) fprintf  (out_vbe, "  val_r_b <= convert(\"%s\") WHEN (r_b(0)='0' AND s_b(0)='0') ELSE\n",
        word_stuck);
    else
      (void) fprintf  (out_vbe, "  val_r_b <= convert(latch0) WHEN (r_b(0)='0' AND s_b(0)='0') ELSE\n");
#else
    if(stuck)
      (void) fprintf  (out_vbe, "  val_r_b <= \"%s\" WHEN (r_b(0)='0' AND s_b(0)='0') ELSE\n",
        word_stuck);
    else
      (void) fprintf  (out_vbe, "  val_r_b <= latch0 WHEN (r_b(0)='0' AND s_b(0)='0') ELSE\n");
#endif

      for(i=1; i<width; i++)

#ifdef rfg_convert
        (void) fprintf(out_vbe, "             convert(latch%ld) WHEN (r_b(%ld)='0' AND s_b(%ld)='0') ELSE\n", i, i, i/rfg_wblock);
#else
        (void) fprintf(out_vbe, "             latch%ld WHEN (r_b(%ld)='0' AND s_b(%ld)='0') ELSE\n", i, i, i/rfg_wblock);
#endif

      (void) fprintf  (out_vbe, "             \"%s\";\n", word_err);
      }
    }
  else
    {

#ifdef rfg_convert
    if(stuck)
      (void) fprintf(out_vbe, "  val_r_a <= convert(\"%s\") WHEN (r_a(0)='0') ELSE\n",
        word_stuck);
    else
      (void) fprintf(out_vbe, "  val_r_a <= convert(latch0) WHEN (r_a(0)='0') ELSE\n");
#else
    if(stuck)
      (void) fprintf(out_vbe, "  val_r_a <= \"%s\" WHEN (r_a(0)='0') ELSE\n",
        word_stuck);
    else
      (void) fprintf(out_vbe, "  val_r_a <= latch0 WHEN (r_a(0)='0') ELSE\n");
#endif

    for(i=1; i<width; i++)

#ifdef rfg_convert
      (void) fprintf(out_vbe, "             convert(latch%ld) WHEN (r_a(%ld)='0') ELSE\n", i, i);
#else
      (void) fprintf(out_vbe, "             latch%ld WHEN (r_a(%ld)='0') ELSE\n", i, i);
#endif

    (void) fprintf  (out_vbe, "             \"%s\";\n", word_err);

    if(n_bus)
      {

#ifdef rfg_convert
    if(stuck)
      (void) fprintf  (out_vbe, "  val_r_b <= convert(\"%s\") WHEN (r_b(0)='0') ELSE\n",
        word_stuck);
    else
      (void) fprintf  (out_vbe, "  val_r_b <= convert(latch0) WHEN (r_b(0)='0') ELSE\n");
#else
    if(stuck)
      (void) fprintf  (out_vbe, "  val_r_b <= \"%s\" WHEN (r_b(0)='0') ELSE\n",
        word_stuck);
    else
      (void) fprintf  (out_vbe, "  val_r_b <= latch0 WHEN (r_b(0)='0') ELSE\n");
#endif

      for(i=1; i<width; i++)

#ifdef rfg_convert
        (void) fprintf(out_vbe, "             convert(latch%ld) WHEN (r_b(%ld)='0') ELSE\n", i, i);
#else
        (void) fprintf(out_vbe, "             latch%ld WHEN (r_b(%ld)='0') ELSE\n", i, i);
#endif

      (void) fprintf  (out_vbe, "             \"%s\";\n", word_err);
      }
    }
  (void) fprintf(out_vbe, "\n");

  if(rfg_nbr_block)
    {
    rfg_dec_bin_deco(-1L, rfg_wblock-1, deco_bin);
    (void) fprintf(out_vbe, "  ASSERT NOT( ");
    for(i=0; i<rfg_nbr_block_p; i++)
      {
      if(i!=0)
        (void) fprintf(out_vbe, " AND\n              ");
      (void) fprintf(out_vbe, "(s_a(%ld)='1' OR r_a(%ld to %ld)=\"%s\")", i, i*rfg_wblock, ((i+1)*rfg_wblock)-1, deco_bin);
      }
    if(rfg_width_f)
      {
      rfg_dec_bin_deco(-1L, rfg_width_f-1, deco_bin);
      if(i!=0)
        (void) fprintf(out_vbe, " AND\n              ");
      (void) fprintf(out_vbe, "(s_a(%ld)='1' OR r_a(%ld to %ld)=\"%s\")", i, i*rfg_wblock, width-1, deco_bin);
      }
    (void) fprintf(out_vbe, " )\n");
    if(flip_flop)
      (void) fprintf(out_vbe, "  REPORT \"output latch a is not driven by any register !!!\"\n");
    else
      (void) fprintf(out_vbe, "  REPORT \"output bus a is not driven by any register !!!\"\n");
    (void) fprintf(out_vbe, "  SEVERITY WARNING;\n");

    if(n_bus)
      {
      rfg_dec_bin_deco(-1L, rfg_wblock-1, deco_bin);
      (void) fprintf(out_vbe, "  ASSERT NOT( ");
      for(i=0; i<rfg_nbr_block_p; i++)
        {
        if(i!=0)
          (void) fprintf(out_vbe, " AND\n              ");
        (void) fprintf(out_vbe, "(s_b(%ld)='1' OR r_b(%ld to %ld)=\"%s\")", i, i*rfg_wblock, ((i+1)*rfg_wblock)-1, deco_bin);
        }
      if(rfg_width_f)
        {
        rfg_dec_bin_deco(-1L, rfg_width_f-1, deco_bin);
        if(i!=0)
          (void) fprintf(out_vbe, " AND\n              ");
        (void) fprintf(out_vbe, "(s_b(%ld)='1' OR r_b(%ld to %ld)=\"%s\")", i, i*rfg_wblock, width-1, deco_bin);
        }
      (void) fprintf(out_vbe, " )\n");
      if(flip_flop)
        (void) fprintf(out_vbe, "  REPORT \"output latch b is not driven by any register !!!\"\n");
      else
        (void) fprintf(out_vbe, "  REPORT \"output bus b is not driven by any register !!!\"\n");
      (void) fprintf(out_vbe, "  SEVERITY WARNING;\n");
      }
    }
  else
    {
    rfg_dec_bin_deco(-1L, width-1, deco_bin);
    (void) fprintf(out_vbe, "  ASSERT (NOT(r_a=\"%s\"))\n", deco_bin);
    if(flip_flop)
      (void) fprintf(out_vbe, "  REPORT \"output latch a is not driven by any register !!!\"\n");
    else
      (void) fprintf(out_vbe, "  REPORT \"output bus a is not driven by any register !!!\"\n");
    (void) fprintf(out_vbe, "  SEVERITY WARNING;\n");
    if(n_bus)
      {
      rfg_dec_bin_deco(-1L, width-1, deco_bin);
      (void) fprintf(out_vbe, "  ASSERT (NOT(r_b=\"%s\"))\n", deco_bin);
      if(flip_flop)
        (void) fprintf(out_vbe, "  REPORT \"output latch b is not driven by any register !!!\"\n");
      else
        (void) fprintf(out_vbe, "  REPORT \"output bus b is not driven by any register !!!\"\n");
      (void) fprintf(out_vbe, "  SEVERITY WARNING;\n");
      }
    }
  (void) fprintf(out_vbe, "\n");

  if((block_type==rfg_reg_only) || (block_type==rfg_reg_sep))
    {
    for(j=0; j<rfg_nbr_block_p; j++)
      {
      (void) fprintf(out_vbe, "  WITH r_a(%ld to %ld) SELECT\n", j*rfg_wblock, ((j+1)*rfg_wblock)-1);
      rfg_dec_bin_deco(-1L, rfg_wblock-1, deco_bin);
      (void) fprintf(out_vbe, "    test_r_a(%ld) <= '0' WHEN \"%s\"", j, deco_bin);
      for(i=0; i<rfg_wblock; i++)
        {
        rfg_dec_bin_deco(i, rfg_wblock-1, deco_bin);
        (void) fprintf(out_vbe, " |\n                            \"%s\"", deco_bin);
        }
      (void) fprintf(out_vbe, ",\n                   '1' WHEN OTHERS;\n");
      (void) fprintf(out_vbe, "  ASSERT (test_r_a(%ld)='0')\n", j);
      if(flip_flop)
        (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output latch a !!!\"\n");
      else
        (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output bus a !!!\"\n");
      (void) fprintf(out_vbe, "  SEVERITY ERROR;\n");
      }
    if(rfg_width_f)
      {
      (void) fprintf(out_vbe, "  WITH r_a(%ld to %ld)SELECT\n", j*rfg_wblock, width-1);
      rfg_dec_bin_deco(-1L, rfg_width_f-1, deco_bin);
      (void) fprintf(out_vbe, "    test_r_a(%ld) <= '0' WHEN \"%s\"", j, deco_bin);
      for(i=0; i<rfg_width_f; i++)
        {
        rfg_dec_bin_deco(i, rfg_width_f-1, deco_bin);
        (void) fprintf(out_vbe, " |\n                            \"%s\"", deco_bin);
        }
      (void) fprintf(out_vbe, ",\n                   '1' WHEN OTHERS;\n");
      (void) fprintf(out_vbe, "  ASSERT (test_r_a(%ld)='0')\n", j);
      if(flip_flop)
        (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output latch a !!!\"\n");
      else
        (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output bus a !!!\"\n");
      (void) fprintf(out_vbe, "  SEVERITY ERROR;\n");
      }

    if(rfg_nbr_block)
      {
      (void) fprintf(out_vbe, "  WITH s_a SELECT\n");
      rfg_dec_bin_deco(-1L, rfg_nbr_block, deco_bin);
      (void) fprintf(out_vbe, "    test_s_a <= '0' WHEN \"%s\"", deco_bin);
      for(i=0; i<=rfg_nbr_block; i++)
        {
        rfg_dec_bin_deco(i, rfg_nbr_block, deco_bin);
        (void) fprintf(out_vbe, " |\n                         \"%s\"", deco_bin);
        }
      (void) fprintf(out_vbe, ",\n                '1' WHEN OTHERS;\n");
      (void) fprintf(out_vbe, "  ASSERT (test_s_a='0')\n");
      if(flip_flop)
        (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output latch a !!!\"\n");
      else
        (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output bus a !!!\"\n");
      (void) fprintf(out_vbe, "  SEVERITY ERROR;\n");
      }

    if(n_bus)
      {
      for(j=0; j<rfg_nbr_block_p; j++)
        {
        (void) fprintf(out_vbe, "  WITH r_b(%ld to %ld) SELECT\n", j*rfg_wblock, ((j+1)*rfg_wblock)-1);
        rfg_dec_bin_deco(-1L, rfg_wblock-1, deco_bin);
        (void) fprintf(out_vbe, "    test_r_b(%ld) <= '0' WHEN \"%s\"", j, deco_bin);
        for(i=0; i<rfg_wblock; i++)
          {
          rfg_dec_bin_deco(i, rfg_wblock-1, deco_bin);
          (void) fprintf(out_vbe, " |\n                            \"%s\"", deco_bin);
          }
        (void) fprintf(out_vbe, ",\n                   '1' WHEN OTHERS;\n");
        (void) fprintf(out_vbe, "  ASSERT (test_r_b(%ld)='0')\n", j);
        if(flip_flop)
          (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output latch b !!!\"\n");
        else
          (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output bus b !!!\"\n");
        (void) fprintf(out_vbe, "  SEVERITY ERROR;\n");
        }
      if(rfg_width_f)
        {
        (void) fprintf(out_vbe, "  WITH r_b(%ld to %ld)SELECT\n", j*rfg_wblock, width-1);
        rfg_dec_bin_deco(-1L, rfg_width_f-1, deco_bin);
        (void) fprintf(out_vbe, "    test_r_b(%ld) <= '0' WHEN \"%s\"", j, deco_bin);
        for(i=0; i<rfg_width_f; i++)
          {
          rfg_dec_bin_deco(i, rfg_width_f-1, deco_bin);
          (void) fprintf(out_vbe, " |\n                            \"%s\"", deco_bin);
          }
        (void) fprintf(out_vbe, ",\n                   '1' WHEN OTHERS;\n");
        (void) fprintf(out_vbe, "  ASSERT (test_r_b(%ld)='0')\n", j);
        if(flip_flop)
          (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output latch b !!!\"\n");
        else
          (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output bus b !!!\"\n");
        (void) fprintf(out_vbe, "  SEVERITY ERROR;\n");
        }

      if(rfg_nbr_block)
        {
        (void) fprintf(out_vbe, "  WITH s_b SELECT\n");
        rfg_dec_bin_deco(-1L, rfg_nbr_block, deco_bin);
        (void) fprintf(out_vbe, "    test_s_b <= '0' WHEN \"%s\"", deco_bin);
        for(i=0; i<=rfg_nbr_block; i++)
          {
          rfg_dec_bin_deco(i, rfg_nbr_block, deco_bin);
          (void) fprintf(out_vbe, " |\n                         \"%s\"", deco_bin);
          }
        (void) fprintf(out_vbe, ",\n                '1' WHEN OTHERS;\n");
        (void) fprintf(out_vbe, "  ASSERT (test_s_b='0')\n");
        if(flip_flop)
          (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output latch b !!!\"\n");
        else
          (void) fprintf(out_vbe, "  REPORT \"more than one register is attemping to drive output bus b !!!\"\n");
        (void) fprintf(out_vbe, "  SEVERITY ERROR;\n");
        }
      }
    (void) fprintf(out_vbe, "\n");
    }

  if(flip_flop)
    {
    if(rfg_nbr_block)
      {
      (void) fprintf(out_vbe, "  l_out_a_r : BLOCK (w_r_a='0') BEGIN\n");

#ifdef rfg_convert
      (void) fprintf(out_vbe, "    latch_out_a <= GUARDED convert(val_r_a);\n");
#else
      (void) fprintf(out_vbe, "    latch_out_a <= GUARDED val_r_a;\n");
#endif

      (void) fprintf(out_vbe, "  END BLOCK;\n");
      }
    else
      {
      (void) fprintf(out_vbe, "  l_out_a_r : BLOCK (w_r_a='0') BEGIN\n");

#ifdef rfg_convert
      (void) fprintf(out_vbe, "    latch_out_a <= GUARDED NOT convert(val_r_a);\n");
#else
      (void) fprintf(out_vbe, "    latch_out_a <= GUARDED NOT val_r_a;\n");
#endif

      (void) fprintf(out_vbe, "  END BLOCK;\n");
      }
    if(n_bus)
      {
      if(rfg_nbr_block)
        {
        (void) fprintf(out_vbe, "  l_out_b_r : BLOCK (w_r_b='0') BEGIN\n");

#ifdef rfg_convert
        (void) fprintf(out_vbe, "    latch_out_b <= GUARDED convert(val_r_b);\n");
#else
        (void) fprintf(out_vbe, "    latch_out_b <= GUARDED val_r_b;\n");
#endif

        (void) fprintf(out_vbe, "  END BLOCK;\n");
        }
      else
        {
        (void) fprintf(out_vbe, "  l_out_b_r : BLOCK (w_r_b='0') BEGIN\n");

#ifdef rfg_convert
        (void) fprintf(out_vbe, "    latch_out_b <= GUARDED NOT convert(val_r_b);\n");
#else
        (void) fprintf(out_vbe, "    latch_out_b <= GUARDED NOT val_r_b;\n");
#endif

        (void) fprintf(out_vbe, "  END BLOCK;\n");
        }
      }
    (void) fprintf(out_vbe, "\n");

#ifdef rfg_convert
    (void) fprintf(out_vbe, "  out_a <= convert(latch_out_a);\n");
#else
    (void) fprintf(out_vbe, "  out_a <= latch_out_a;\n");
#endif

    if(n_bus)

#ifdef rfg_convert
      (void) fprintf(out_vbe, "  out_b <= convert(latch_out_b);\n");
#else
      (void) fprintf(out_vbe, "  out_b <= latch_out_b;\n");
#endif

    (void) fprintf(out_vbe, "\n");
    }
  else
    {
    if(rfg_nbr_block)
      (void) fprintf(out_vbe, "  out_a <= NOT val_r_a;\n");
    else
      (void) fprintf(out_vbe, "  out_a <= val_r_a;\n");
    if(n_bus)
      if(rfg_nbr_block)
        (void) fprintf(out_vbe, "  out_b <= NOT val_r_b;\n");
      else
        (void) fprintf(out_vbe, "  out_b <= val_r_b;\n");
    (void) fprintf(out_vbe, "\n");
    }
  }

#ifdef rfg_alims_vbe
if(rfg_cell_alims)
  {
  (void) fprintf(out_vbe, "  ASSERT (vss = '0')\n");
  (void) fprintf(out_vbe, "  REPORT   \"Power supply is missing on vss !!!\"\n");
  (void) fprintf(out_vbe, "  SEVERITY ERROR;\n");
  (void) fprintf(out_vbe, "  ASSERT (vdd = '1')\n");
  (void) fprintf(out_vbe, "  REPORT   \"Power supply is missing on vdd !!!\"\n");
  (void) fprintf(out_vbe, "  SEVERITY ERROR;\n");
  }
else
  {
  for(i=0; i<=rfg_num_slices ; i++)
    {
    if(i&1)
      {
      (void) fprintf(out_vbe, "  ASSERT (vdd%ld = '1')\n", i);
      (void) fprintf(out_vbe, "  REPORT   \"Power supply is missing on vdd%ld !!!\"\n", i);
      }
    else
      {
      (void) fprintf(out_vbe, "  ASSERT (vss%ld = '0')\n", i);
      (void) fprintf(out_vbe, "  REPORT   \"Power supply is missing on vss%ld !!!\"\n", i);
      }
    (void) fprintf(out_vbe, "  SEVERITY ERROR;\n");
    }
  }

(void) fprintf(out_vbe, "\n");
#endif

(void) fprintf(out_vbe, "END dataflow_view;\n");

(void) fclose(out_vbe);
}

/*******************************************************************/
