/*******************************************************************/
/*******************************************************************/
/**                                                               **/
/**  RFG_PATE                                                     **/
/**                                                               **/
/**  Version 6.03                                                 **/
/**                                                               **/
/*******************************************************************/
/*******************************************************************/

static char *ident_patt="@(#)(RFG) patterns view generation, version 6.03 (03/12/1993)";

/*******************************************************************/

#define rfg_h(a) (a/rfg_wblock)
#define rfg_l(a) (a%rfg_wblock)

/*******************************************************************/
/* LONG_HEX_IN ( val, num_bit )                                    */
/*******************************************************************/

static char rfg_hex_tab[16]=
  {
  '0', '1', '2', '3', '4', '5', '6', '7',
  '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
  };

static char *rfg_long_hex_in(val, num_bit)
  long val, num_bit;

{
/* Convert a long word in a hexadecimal string for .pat input signals. */
static rfg_string result[rfg_max_value];
static long      i;
long             tmp;

i=(i+1)%rfg_max_value;
tmp=(num_bit-1)>>2; /* number of digits to print */
result[i].line[tmp+1]='\0';
while(tmp>=0)
  {
  result[i].line[tmp--]=rfg_hex_tab[val&0xF];
  val>>=4;
  }
return(&result[i].line[0]);
}

/*******************************************************************/
/* LONG_HEX_OUT ( val, num_bit, not_first )                        */
/*******************************************************************/

static char *rfg_long_hex_out(val, num_bit, not_first)
  long val, num_bit, not_first;

{
/* Convert a long word in a hexadecimal string for .pat output signals. */
static rfg_string result[rfg_max_value];
static long      i;
long             tmp;

i=(i+1)%rfg_max_value;
tmp=((num_bit-1)>>2)+1; /* number of digits to print + 1 (for ?) */
result[i].line[0]='?';
result[i].line[tmp+1]='\0';
while(tmp>=1)
  {
  result[i].line[tmp--]=rfg_hex_tab[val&0xF];
  val>>=4;
  }
if(not_first==0)
  return(&result[i].line[0]);
else
  return(&result[i].line[1]);
}
 
/*******************************************************************/
/* UNKNOW_OUT ( num_bit, not_first )                               */
/*******************************************************************/

static char *rfg_unknow_out(num_bit, not_first)
  long num_bit, not_first;

{
/* Create a unknow vector of num_bit for .pat output signals. */
static rfg_string result[rfg_max_value];
static long      i;
long             tmp;

i=(i+1)%rfg_max_value;
tmp=((num_bit-1)>>2)+1; /* number of digits to print + 1 (for ?) */
result[i].line[0]='?';
result[i].line[tmp+1]='\0';
while(tmp>=1)
  {
  result[i].line[tmp--]='*';
  }
if(not_first==0)
  return(&result[i].line[0]);
else
  return(&result[i].line[1]);
}
 
/********************************************************************/
 
/* Convert a one bit signal in a binary string for .pat input signals. */
#define rfg_bit_bin_in(a) ((a)==0 ? "0" : "1")
/* Convert a one bit signal in a binary string for .pat output signals. */
#define rfg_bit_bin_out(a) ((a)==0 ? "-" : "+")
 
/*******************************************************************/
/* LONG_BIN_DECO_IN ( val, num_bit )                               */
/*******************************************************************/

static char *rfg_long_bin_deco_in(val, num_bit)
  long val, num_bit;

{
/* Convert a long word in a binary string for .pat input signals. */
/* generate a string of binary value : [num_bit-1 .. 0].          */
/* if val >= 0 : put '0' in val position all other are '1'        */
/* else all are '1'                                               */
static rfg_string result[rfg_max_value];
static long i;
long tmp;

i=(i+1)%rfg_max_value;
for(tmp=0; tmp<num_bit; )
  {
  result[i].line[tmp++]='1';
  }
if((val>=0) && (val<num_bit))
  result[i].line[val]='0';
result[i].line[num_bit]='\0';
return(&result[i].line[0]);
}

/*******************************************************************/
/* LONG_BIN_DECO_OUT ( val, num_bit, not_first )                   */
/*******************************************************************/

static char *rfg_long_bin_deco_out(val, num_bit, not_first)
  long val, num_bit, not_first;

{
/* Convert a long word in a binary string for .pat output signals. */
/* generate a string of binary value : [0 .. num_bit-1].           */
/* if val >= 0 : put '0' in val position all other are '1'         */
/* else all are '1'                                                */
static rfg_string result[rfg_max_value];
static long i;
long tmp;

i=(i+1)%rfg_max_value;
result[i].line[0]='?';
for(tmp=1; tmp<=num_bit; )
  {
  result[i].line[tmp++]='1';
  }
if((val>=0) && (val<num_bit))
  result[i].line[val+1]='0';
result[i].line[num_bit+1]='\0';
if(not_first==0)
  return(&result[i].line[0]);
else
  return(&result[i].line[1]);
}

/*******************************************************************/
/* WRITE_PAT ( )                                                   */
/*******************************************************************/

static void rfg_write_pat(num_vector, phase, ad_r_a, ad_r_b, we, ad_w,
                  r_a, r_b, s_a, s_b, w, w_r_a, w_r_b,
                  in_a_h, in_a_l,
                  out_a_h, out_a_l, valid_a, out_b_h, out_b_l, valid_b,
                  ck_m,
                  out_pat, width, high, n_bus, flip_flop,
                  inverse_data, low_power, write_enable, inverse_we,
                  block_type)

  long num_vector;
  long phase;
  long ad_r_a;
  long ad_r_b;
  long we;
  long ad_w;
  long r_a;
  long r_b;
  long s_a;
  long s_b;
  long w;
  long w_r_a;
  long w_r_b;
  long in_a_h;
  long in_a_l;
  long out_a_h;
  long out_a_l;
  long valid_a;
  long out_b_h;
  long out_b_l;
  long valid_b;
  long ck_m;
  FILE *out_pat;
  long width;
  long high;
  long n_bus;
  long flip_flop;
  long inverse_data;
  long low_power;
  long write_enable;
  long inverse_we;
  long block_type;

{
static char phase_tab[4][3]=
  {
  "S0", "S1", "M0", "M1"
  };

long i;

(void) fprintf(out_pat, "PAT_%010d_%s : ", num_vector, phase_tab[phase]);

if((block_type==rfg_dec_sep) || (block_type==rfg_bank))
  {
  (void) fprintf(out_pat, "%s ", rfg_long_hex_in(ad_r_a, rfg_addr_size+1));
  if(n_bus)
    (void) fprintf(out_pat, "%s ", rfg_long_hex_in(ad_r_b, rfg_addr_size+1));
  if(write_enable)
    (void) fprintf(out_pat, "%s ", rfg_bit_bin_in(we));
  (void) fprintf(out_pat, "%s ", rfg_long_hex_in(ad_w, rfg_addr_size+1));
  }

if(block_type==rfg_dec_sep)
  {
  for(i=0; i<rfg_nbr_block_p; i++)
    if((!low_power) || (i==s_a))
      (void) fprintf(out_pat, "%s", rfg_long_bin_deco_out(r_a, rfg_wblock, i));
    else
      (void) fprintf(out_pat, "%s", rfg_long_bin_deco_out(-1L, rfg_wblock, i));
  if(rfg_width_f)
    if((!low_power) || (i==s_a)) 
      (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_out(r_a, rfg_width_f, i));
    else
      (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_out(-1L, rfg_width_f, i));
  else
    (void) fprintf(out_pat, " ");
  
  if(n_bus)
    {
    for(i=0; i<rfg_nbr_block_p; i++)
      if((!low_power) || (i==s_b))
        (void) fprintf(out_pat, "%s", rfg_long_bin_deco_out(r_b, rfg_wblock, i));
      else
        (void) fprintf(out_pat, "%s", rfg_long_bin_deco_out(-1L, rfg_wblock, i));
    if(rfg_width_f)
      if((!low_power) || (i==s_b)) 
        (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_out(r_b, rfg_width_f, i));
      else
        (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_out(-1L, rfg_width_f, i));
    else
      (void) fprintf(out_pat, " ");
    }

  if(rfg_nbr_block)
    {
    (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_out(s_a, rfg_nbr_block+1, 0L));
    if(n_bus)
      (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_out(s_b, rfg_nbr_block+1, 0L));
    }
  for(i=0; i<rfg_nbr_block_p; i++)
    if(i==(w/rfg_wblock))
      (void) fprintf(out_pat, "%s", rfg_long_bin_deco_out((w%rfg_wblock), rfg_wblock, i));
    else
      (void) fprintf(out_pat, "%s", rfg_long_bin_deco_out(-1L, rfg_wblock, i));
  if(rfg_width_f)
    if(i==(w/rfg_wblock))
      (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_out((w%rfg_wblock), rfg_width_f, i));
    else
      (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_out(-1L, rfg_width_f, i));
  else
    (void) fprintf(out_pat, " ");

  if(flip_flop)
    {
    (void) fprintf(out_pat, "%s ", rfg_bit_bin_out(w_r_a));
    if(n_bus)
      (void) fprintf(out_pat, "%s ", rfg_bit_bin_out(w_r_b));
    }
  }

if((block_type==rfg_reg_only) || (block_type==rfg_reg_sep) || (block_type==rfg_bank))
  {
  if((high-1)<=rfg_long_bits)
    {
    (void) fprintf(out_pat, "%s ", rfg_long_hex_in(in_a_l, high));
    if(valid_a)
      (void) fprintf(out_pat, "%s ", rfg_long_hex_out(out_a_l, high, 0L));
    else
      (void) fprintf(out_pat, "%s ", rfg_unknow_out(high, 0L));
    if(n_bus)
      if(valid_b)
        (void) fprintf(out_pat, "%s ", rfg_long_hex_out(out_b_l, high, 0L));
      else
        (void) fprintf(out_pat, "%s ", rfg_unknow_out(high, 0L));
    }
  else
    {
    (void) fprintf(out_pat, "%s%s ",
      rfg_long_hex_in(in_a_h, high-rfg_long_bits),
      rfg_long_hex_in(in_a_l, rfg_long_bits));
    if(valid_a)
      (void) fprintf(out_pat, "%s%s ",
        rfg_long_hex_out(out_a_h, high-rfg_long_bits, 0L),
        rfg_long_hex_out(out_a_l, rfg_long_bits, 1L));
    else
      (void) fprintf(out_pat, "%s%s ",
        rfg_unknow_out(high-rfg_long_bits, 0L),
        rfg_unknow_out(rfg_long_bits, 1L));
    if(n_bus)
      if(valid_b)
        (void) fprintf(out_pat, "%s%s ",
          rfg_long_hex_out(out_b_h, high-rfg_long_bits, 0L),
          rfg_long_hex_out(out_b_l, rfg_long_bits, 1L));
      else
        (void) fprintf(out_pat, "%s%s ",
          rfg_unknow_out(high-rfg_long_bits, 0L),
          rfg_unknow_out(rfg_long_bits, 1L));
    }
  }

if((block_type==rfg_dec_sep) || (block_type==rfg_bank))
  {
  (void) fprintf(out_pat, "%s ", rfg_bit_bin_in(ck_m));
  }

if((block_type==rfg_reg_only) || (block_type==rfg_reg_sep))
  {
  for(i=0; i<rfg_nbr_block_p; i++)
    if((!low_power) || (i==s_a))
      (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(r_a, rfg_wblock));
    else
      (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(-1L, rfg_wblock));
  if(rfg_width_f)
    if((!low_power) || (i==s_a))
        (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(r_a, rfg_width_f));
      else
        (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(-1L, rfg_width_f));
  if(n_bus)
    {
    for(i=0; i<rfg_nbr_block_p; i++)
      if((!low_power) || (i==s_b))
        (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(r_b, rfg_wblock));
      else
        (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(-1L, rfg_wblock));
    if(rfg_width_f)
      if((!low_power) || (i==s_b))
          (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(r_b, rfg_width_f));
        else
          (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(-1L, rfg_width_f));
    }
  if(rfg_nbr_block)
    {
    (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(s_a, rfg_nbr_block+1));
    if(n_bus)
      (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(s_b, rfg_nbr_block+1));
    }
  for(i=0; i<rfg_nbr_block_p; i++)
    if(i==(w/rfg_wblock))
      (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in((w%rfg_wblock), rfg_wblock));
    else
      (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(-1L, rfg_wblock));
  if(rfg_width_f)
    if(i==(w/rfg_wblock))
        (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in((w%rfg_wblock), rfg_width_f));
      else
        (void) fprintf(out_pat, "%s ", rfg_long_bin_deco_in(-1L, rfg_width_f));
  if(flip_flop)
    {
    (void) fprintf(out_pat, "%s ", rfg_bit_bin_in(w_r_a));
    if(n_bus)
      (void) fprintf(out_pat, "%s ", rfg_bit_bin_in(w_r_b));
    }
  }

#ifdef rfg_alims_vbe
if(rfg_cell_alims)
  {
  (void) fprintf(out_pat, "1");
  (void) fprintf(out_pat, "0");
  }
else
  {
  for(i=0; i<=rfg_num_slices ; i++)
    {
    if(i&1)
      (void) fprintf(out_pat, "1");
    else
      (void) fprintf(out_pat, "0");
    }
  }
#endif

if(phase>2)
  (void) fprintf(out_pat, ";\n\n");
else
  (void) fprintf(out_pat, ";\n");
}

/*******************************************************************/
/*******************************************************************/
/**                                                               **/
/**  RFG_PAT ( width, high, n_bus, flip_flop, inverse_data,       **/
/**            low_power, write_enable, inverse_we, stuck, msb,   **/
/**            block_type )                                       **/
/**                                                               **/
/*******************************************************************/
/*******************************************************************/

static void rfg_pat (width, high, n_bus, flip_flop, inverse_data,
              low_power, write_enable, inverse_we, stuck /*, msb*/ ,
              block_type)

  long width, high, n_bus, flip_flop, inverse_data;
  long low_power, write_enable, inverse_we, stuck /*, msb*/ ;
  long block_type;

{
long i;
long num_vector;
long max_addr;   /* 2^(rfg_addr_size+1)-1 */
long max_addr_l;
long max_addr_h;
long addr_0w, addr_1w;
long addr_0a, addr_1a;
long addr_0b, addr_1b;
long valid_0a, valid_1a;
long valid_0b, valid_1b;
long data_0w, data_1w;
long data_0a, data_1a;
long data_0b, data_1b;

FILE *out_pat;

/********** Create vectors file **********/

if((out_pat=mbkfopen(rfg_name_pref, "pat", "w"))==NULL)
  {
  (void) fprintf(stderr, "Unable to open output file \"%s.%s\" !!!\n", rfg_name_pref, "pat");
  exit(1);
  }
     /***** Interface declaration *****/
(void) fprintf  (out_pat, "#-------------------------------------------------------\n");
if((block_type==rfg_reg_only) || (block_type==rfg_reg_sep))
  (void) fprintf(out_pat, "#----------------  Registers interface  ----------------\n");
if(block_type==rfg_dec_sep)
  (void) fprintf(out_pat, "#----------------  Decoders  interface  ----------------\n");
if(block_type==rfg_bank)
  (void) fprintf(out_pat, "#----------------    Bank  interface    ----------------\n");
(void) fprintf  (out_pat, "#-------------------------------------------------------\n\n");

for(RFG_FIRST_CON(); RFG_TEST_CON(); RFG_NEXT_CON())
  {

#ifndef rfg_alims_vbe
  if(!(RFG_CON_TYPE()&rfg_con_supply))
#endif

    {
    if(RFG_CON_VECTOR())
      if(RFG_CON_RANGE())
        (void) fprintf(out_pat, "%s %s(%ld %s %ld) %c;;\n",
          RFG_CON_TYPE()&rfg_con_in ? "IN " : "OUT",
          RFG_CON_NAME(), RFG_CON_START_INDEX(), 
          RFG_CON_TEST_INDEX() ? "to" : "downto", RFG_CON_END_INDEX(),
          RFG_CON_FORMAT());
      else
        (void) fprintf(out_pat, "%s %s(%ld) B;;\n",
          RFG_CON_TYPE()&rfg_con_in ? "IN " : "OUT",
          RFG_CON_NAME(), RFG_CON_START_INDEX());
    else
      (void) fprintf(out_pat, "%s %s B;;\n",
        RFG_CON_TYPE()&rfg_con_in ? "IN " : "OUT",
        RFG_CON_NAME());
    }
  }

     /***** Vectors *****/

(void) fprintf  (out_pat, "\nbegin\n\n");

(void) fprintf  (out_pat, "\n#-------------------------------------------------------\n");
if((block_type==rfg_reg_only) || (block_type==rfg_reg_sep))
  (void) fprintf(out_pat, "#----------------   Registers vectors   ----------------\n");
if(block_type==rfg_dec_sep)
  (void) fprintf(out_pat, "#----------------   Decoders  vectors   ----------------\n");
if(block_type==rfg_bank)
  (void) fprintf(out_pat, "#----------------     Bank  vectors     ----------------\n");
(void) fprintf  (out_pat, "#-------------------------------------------------------\n\n");

num_vector=0;
max_addr=(2<<rfg_addr_size)-1;
max_addr_l=rfg_l(max_addr);
max_addr_h=rfg_h(max_addr);

switch(block_type)
  {

/********** Test decoders only blocks **********/

  case rfg_dec_sep :

     /***** Test each decoder output *****/

    (void) fprintf(out_pat, "  #--------  Test each decoder output  --------\n\n");
    for(i=0L; i<=max_addr; i++)
      {
          /***** Test A read decoders *****/
      rfg_write_pat(num_vector++, 0L, i, max_addr, 1L^inverse_we, max_addr,
                   rfg_l(i), max_addr_l, rfg_h(i), max_addr_h, -1L, flip_flop, flip_flop,
                   0L, 0L,
                   0L, 0L, 0L, 0L, 0L, 0L,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      if(n_bus)
        {
          /***** Test B read decoders *****/
        rfg_write_pat(num_vector++, 0L, max_addr, i, 1L^inverse_we, max_addr,
                     max_addr_l, rfg_l(i), max_addr_h, rfg_h(i), -1L, flip_flop, flip_flop,
                     0L, 0L,
                     0L, 0L, 0L, 0L, 0L, 0L,
                     0L,
                     out_pat, width, high, n_bus, flip_flop,
                     inverse_data, low_power, write_enable, inverse_we,
                     block_type);
        }
          /***** Test write decoders ck_m true, we true *****/
      rfg_write_pat(num_vector++, 3L, max_addr, max_addr, 1L^inverse_we, i,
                   max_addr_l, max_addr_l, max_addr_h, max_addr_h, i, flip_flop, flip_flop,
                   0L, 0L,
                   0L, 0L, 0L, 0L, 0L, 0L,
                   1L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
          /***** Test write decoders ck_m false, we true *****/
      rfg_write_pat(num_vector++, 0L, max_addr, max_addr, 1L^inverse_we, i,
                   max_addr_l, max_addr_l, max_addr_h, max_addr_h, -1L, flip_flop, flip_flop,
                   0L, 0L,
                   0L, 0L, 0L, 0L, 0L, 0L,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      if(write_enable)
        {
          /***** Test write decoders ck_m true, we false *****/
        rfg_write_pat(num_vector++, 3L, max_addr, max_addr, 0L^inverse_we, i,
                     max_addr_l, max_addr_l, max_addr_h, max_addr_h, -1L, flip_flop, flip_flop,
                     0L, 0L,
                     0L, 0L, 0L, 0L, 0L, 0L,
                     1L,
                     out_pat, width, high, n_bus, flip_flop,
                     inverse_data, low_power, write_enable, inverse_we,
                     block_type);
          /***** Test write decoders ck_m false, we false *****/
        rfg_write_pat(num_vector++, 0L, max_addr, max_addr, 0L^inverse_we, i,
                     max_addr_l, max_addr_l, max_addr_h, max_addr_h, -1L, flip_flop, flip_flop,
                     0L, 0L,
                     0L, 0L, 0L, 0L, 0L, 0L,
                     0L,
                     out_pat, width, high, n_bus, flip_flop,
                     inverse_data, low_power, write_enable, inverse_we,
                     block_type);
        }
      }

     /***** Test special signals *****/

          /***** Test W_R_x *****/
    if(flip_flop)
      {
      (void) fprintf(out_pat, "  #--------  Test latch_out write signals  --------\n\n");
      rfg_write_pat(num_vector++, 1L, 0L, 0L, 0L^inverse_we, 0L,
                   0L, 0L, 0L, 0L, -1L, 0L, 0L,
                   0L, 0L,
                   0L, 0L, 0L, 0L, 0L, 0L,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      }
    break;

/********** Test registers blocks **********/

  case rfg_reg_only :
  case rfg_reg_sep :
  case rfg_bank :
	  
     /***** Test all registers *****/

          /***** Write w(i)=i, if high>32 write w[0..high-33](i)=i      *****/
          /*****                          write w[high-32..high-1](i)=i *****/
    (void) fprintf(out_pat, "  #--------  Write w(i)=i  --------\n\n");
    addr_0w=0L;
    addr_1w=addr_0w;
    addr_0a=0L;
    addr_0b=0L;
    addr_1a=addr_0a;
    addr_1b=addr_0b;
    valid_0a=0L;
    valid_0b=0L;
    valid_1a=0L;
    valid_1b=0L;
    data_0w=0L;
    data_1w=data_0w;
    if(inverse_data && (!stuck))
      {
      data_0a=~0L;
      data_0b=~0L;
      data_1a=~0L;
      data_1b=~0L;
      }
    else
      {
      data_0a=0L;
      data_0b=0L;
      data_1a=0L;
      data_1b=0L;
      }
    for(i=0L; i<=max_addr; i++)
      {
      addr_0w=i;
      data_0w=i;
#ifdef rfg_phase_s0
      rfg_write_pat(num_vector, 0L, addr_1a, addr_1b, 1L^inverse_we, addr_1w,
                   0L, 0L, 0L, 0L, -1L, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
#endif
      if(flip_flop)
        {
        valid_1a=valid_0a;
        valid_1b=valid_0b;
        }
      rfg_write_pat(num_vector, 1L, addr_1a, addr_1b, 1L^inverse_we, addr_1w,
                   0L, 0L, 0L, 0L, -1L, 0L, 0L,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      addr_1w=addr_0w;
      data_1w=data_0w;
#ifdef rfg_phase_m0
      rfg_write_pat(num_vector, 2L, addr_1a, addr_1b, 1L^inverse_we, addr_1w,
                   0L, 0L, 0L, 0L, -1L, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
#endif
      valid_0a=1L;
      valid_0b=1L;
      if(!flip_flop)
        {
        valid_1a=valid_0a;
        valid_1b=valid_0b;
        }
      rfg_write_pat(num_vector++, 3L, addr_1a, addr_1b, 1L^inverse_we, addr_1w,
                   0L, 0L, 0L, 0L, i, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   1L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      if(write_enable)
        {
        data_0w=~0L;
#ifdef rfg_phase_s0
        rfg_write_pat(num_vector, 0L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                     0L, 0L, 0L, 0L, -1L, 0L|flip_flop, 0L|flip_flop,
                     data_1w, data_1w,
                     data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                     0L,
                     out_pat, width, high, n_bus, flip_flop,
                     inverse_data, low_power, write_enable, inverse_we,
                     block_type);
#endif
        if(flip_flop)
          {
          valid_1a=valid_0a;
          valid_1b=valid_0b;
          }
        rfg_write_pat(num_vector, 1L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                     0L, 0L, 0L, 0L, -1L, 0L, 0L,
                     data_1w, data_1w,
                     data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                     0L,
                     out_pat, width, high, n_bus, flip_flop,
                     inverse_data, low_power, write_enable, inverse_we,
                     block_type);
        addr_1w=addr_0w;
        data_1w=data_0w;
#ifdef rfg_phase_m0
        rfg_write_pat(num_vector, 2L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                     0L, 0L, 0L, 0L, -1L, 0L, 0L,
                     data_1w, data_1w,
                     data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                     0L,
                     out_pat, width, high, n_bus, flip_flop,
                     inverse_data, low_power, write_enable, inverse_we,
                     block_type);
#endif
        rfg_write_pat(num_vector++, 3L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                     0L, 0L, 0L, 0L, -1L, 0L, 0L,
                     data_1w, data_1w,
                     data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                     1L,
                     out_pat, width, high, n_bus, flip_flop,
                     inverse_data, low_power, write_enable, inverse_we,
                     block_type);
        }
      }
          /***** Read a(i)=i b(max_addr-i)=max_addr-i *****/
    if(n_bus)
      (void) fprintf(out_pat, "  #--------  Read a(i)=i and b(max_addr-i)=max_addr-i  --------\n\n");
    else
      (void) fprintf(out_pat, "  #--------  Read a(i)=i  --------\n\n");
    addr_0w=0L;
    data_0w=0L;
    for(i=0L; i<=max_addr; i++)
      {
      addr_0a=i;
      addr_0b=max_addr-i;
      addr_1a=addr_0a;
      addr_1b=addr_0b;
      if(i<width)
        valid_0a=1L;
      else
        valid_0a=0L;
      if((max_addr-i)<width)
        valid_0b=1L;
      else
        valid_0b=0L;
      if(stuck && ((i==0) || (max_addr-i==0)))
        {
        if(i==0)
          { /* i = 0 */
          data_0a=0L; /* register 0 = 0 */
          if(inverse_data)
            data_0b=~(max_addr-i);
          else
            data_0b=max_addr-i;
          }
        else
          { /* max_addr-i = 0 */
          if(inverse_data)
            data_0a=~i;
          else
            data_0a=i;
          data_0b=0L; /* register 0 = 0 */
          }
        }
      else
        if(inverse_data)
          {
          data_0a=~i;
          data_0b=~(max_addr-i);
          }
        else
          {
          data_0a=i;
          data_0b=max_addr-i;
          }
      if(!flip_flop)
        {
        valid_1a=valid_0a;
        valid_1b=valid_0b;
        data_1a=data_0a;
        data_1b=data_0b;
        }
#ifdef rfg_phase_s0
      rfg_write_pat(num_vector, 0L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                   rfg_l(i), rfg_l(max_addr-i), rfg_h(i), rfg_h(max_addr-i), -1L, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
#endif
      if(flip_flop)
        {
        valid_1a=valid_0a;
        valid_1b=valid_0b;
        data_1a=data_0a;
        data_1b=data_0b;
        }
      rfg_write_pat(num_vector, 1L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                   rfg_l(i), rfg_l(max_addr-i), rfg_h(i), rfg_h(max_addr-i), -1L, 0L, 0L,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      addr_1w=addr_0w;
      data_1w=data_0w;
#ifdef rfg_phase_m0
      rfg_write_pat(num_vector, 2L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                   rfg_l(i), rfg_l(max_addr-i), rfg_h(i), rfg_h(max_addr-i), -1L, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
#endif
      rfg_write_pat(num_vector++, 3L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                   rfg_l(i), rfg_l(max_addr-i), rfg_h(i), rfg_h(max_addr-i), 0L, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   1L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      }
          /***** Write w(i)=~i *****/
    (void) fprintf(out_pat, "  #--------  Write w(i)=~i  --------\n\n");
    addr_0a=0L;
    addr_0b=0L;
    addr_1a=addr_0a;
    addr_1b=addr_0b;
    valid_0a=1L;
    valid_0b=1L;
    if(inverse_data && (!stuck))
      {
      data_0a=~0L;
      data_0b=~0L;
      }
    else
      {
      data_0a=0L;
      data_0b=0L;
      }
    if(!flip_flop)
      {
      valid_1a=valid_0a;
      valid_1b=valid_0b;
      data_1a=data_0a;
      data_1b=data_0b;
      }
    for(i=0L; i<=max_addr; i++)
      {
      addr_0w=i;
      data_0w=~i;
#ifdef rfg_phase_s0
      rfg_write_pat(num_vector, 0L, addr_1a, addr_1b, 1L^inverse_we, addr_1w,
                   0L, 0L, 0L, 0L, -1L, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
#endif
      if(flip_flop)
        {
        valid_1a=valid_0a;
        valid_1b=valid_0b;
        data_1a=data_0a;
        data_1b=data_0b;
        }
      rfg_write_pat(num_vector, 1L, addr_1a, addr_1b, 1L^inverse_we, addr_1w,
                   0L, 0L, 0L, 0L, -1L, 0L, 0L,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      addr_1w=addr_0w;
      data_1w=data_0w;
#ifdef rfg_phase_m0
      rfg_write_pat(num_vector, 2L, addr_1a, addr_1b, 1L^inverse_we, addr_1w,
                   0L, 0L, 0L, 0L, -1L, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
#endif
      if(!stuck)
        if(inverse_data)
          {
          data_0a=0L;
          data_0b=0L;
          }
        else
          {
          data_0a=~0L;
          data_0b=~0L;
          }
      if(!flip_flop)
        {
        data_1a=data_0a;
        data_1b=data_0b;
        }
      rfg_write_pat(num_vector++, 3L, addr_1a, addr_1b, 1L^inverse_we, addr_1w,
                   0L, 0L, 0L, 0L, i, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   1L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      }
          /***** Read a(i)=~i b(max_addr-i)=~(max_addr-i) *****/
    if(n_bus)
      (void) fprintf(out_pat, "  #--------  Read a(i)=~i and b(max_addr-i)=~(max_addr-i)  --------\n\n");
    else
      (void) fprintf(out_pat, "  #--------  Read a(i)=~i  --------\n\n");
    addr_0w=0L;
    data_0w=~0L;
    for(i=0L; i<=max_addr; i++)
      {
      addr_0a=i;
      addr_0b=max_addr-i;
      addr_1a=addr_0a;
      addr_1b=addr_0b;
      if(i<width)
        valid_0a=1L;
      else
        valid_0a=0L;
      if((max_addr-i)<width)
        valid_0b=1L;
      else
        valid_0b=0L;
      if(stuck && ((i==0) || (max_addr-i==0)))
        {
        if(i==0)
          { /* i = 0 */
          data_0a=0L; /* register 0 = 0 */
          if(inverse_data)
            data_0b=max_addr-i;
          else
            data_0b=~(max_addr-i);
          }
        else
          { /* max_addr-i = 0 */
          if(inverse_data)
            data_0a=i;
          else
            data_0a=~i;
          data_0b=0L; /* register 0 = 0 */
          }
        }
      else
        if(inverse_data)
          {
          data_0a=i;
          data_0b=max_addr-i;
          }
        else
          {
          data_0a=~i;
          data_0b=~(max_addr-i);
          }
      if(!flip_flop)
        {
        valid_1a=valid_0a;
        valid_1b=valid_0b;
        data_1a=data_0a;
        data_1b=data_0b;
        }
#ifdef rfg_phase_s0
      rfg_write_pat(num_vector, 0L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                   rfg_l(i), rfg_l(max_addr-i), rfg_h(i), rfg_h(max_addr-i), -1L, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
#endif
      if(flip_flop)
        {
        valid_1a=valid_0a;
        valid_1b=valid_0b;
        data_1a=data_0a;
        data_1b=data_0b;
        }
      rfg_write_pat(num_vector, 1L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                   rfg_l(i), rfg_l(max_addr-i), rfg_h(i), rfg_h(max_addr-i), -1L, 0L, 0L,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      addr_1w=addr_0w;
      data_1w=data_0w;
#ifdef rfg_phase_m0
      rfg_write_pat(num_vector, 2L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                   rfg_l(i), rfg_l(max_addr-i), rfg_h(i), rfg_h(max_addr-i), -1L, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   0L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
#endif
      rfg_write_pat(num_vector++, 3L, addr_1a, addr_1b, 0L^inverse_we, addr_1w,
                   rfg_l(i), rfg_l(max_addr-i), rfg_h(i), rfg_h(max_addr-i), 0L, 0L|flip_flop, 0L|flip_flop,
                   data_1w, data_1w,
                   data_1a, data_1a, valid_1a, data_1b, data_1b, valid_1b,
                   1L,
                   out_pat, width, high, n_bus, flip_flop,
                   inverse_data, low_power, write_enable, inverse_we,
                   block_type);
      }
    break;
  }

(void) fprintf(out_pat, "END;\n");

(void) fclose(out_pat);
}

/*******************************************************************/
