#ifndef rfg_head_h
#define rfg_head_h

/*******************************************************************/
/*******************************************************************/
/**                                                               **/
/**  RFG_HEAD                                                     **/
/**                                                               **/
/**  Version 6.03                                                 **/
/**                                                               **/
/*******************************************************************/
/*******************************************************************/

static char *ident_head="@(#)(RFG) header, version 6.03 (03/12/1993)";

/*******************************************************************/

/* if rfg_crunch_name if defined : 7 characters block name are generated, */
/* else long block name are generated. */

/*
#define rfg_crunch_name
*/

/*******************************************************************/

/* if rfg_alims_vbe is defined : alims appears in interface, */
/* else no alims are declare. */

#define rfg_alims_vbe

/*******************************************************************/

/* if rfg_convert is defined : convert function is explicitly */
/* call, else all conversion are implicit. */

/*
#define rfg_convert
*/

/*******************************************************************/

/*                ___          */
/* CK_S       ___|   |________ */
/*                        ___  */
/* CK_M       ___________|   | */
/*                             */
/* phase name  S0  S1  M0  M1  */

/* if rfg_quad is defined : 4 phases by cycle for simulation (S0, S1, M0 and M1) */
/* else 2 phases by cycle (S1 and M1). */

/*
#define rfg_quad
*/

#ifdef  rfg_quad
#define rfg_phase_s0 /* add a S0 phase */
#define rfg_phase_m0 /* add a M0 phase */
#else
/*
#define rfg_phase_s0
*/
#define rfg_phase_m0
#endif

/*******************************************************************/

#ifdef rfg_crunch_name
#define rfg_pref_length 9 /* Max size of files's prefix. */
#endif

/*******************************************************************/

#ifdef Wall
int fprintf();
int getpid();
int printf();
int fclose();
int sscanf();
#endif

/*******************************************************************/

#define rfg_WIDTH_MIN   2L
#define rfg_WIDTH_MAX   256L
#define rfg_HIGH_MIN    2L
#define rfg_HIGH_MAX    64L

#define rfg_reg_only    0L
#define rfg_reg_sep     1L
#define rfg_dec_sep     2L
#define rfg_bank        3L

/*******************************************************************/

#endif
