/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  (R)ectangle (D)ata (S)tructure (2)to (P)ost(S)cript driver */
/*    Fichier :  drive_ps.h                                                 */
/*                                                                          */
/*    (c) copyright 1991-94 Laboratoire MASI equipe CAO & VLSI              */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  Gilles-Eric DESCAMPS                 le : 23/03/1993     */
/*                                                                          */
/*    Modifie par :  Gilles-Eric DESCAMPS               le : 30/01/1994     */
/*                                                                          */
/****************************************************************************/

typedef struct rps_pages
{
	struct rps_param	*param;
	struct rps_pages	*next;
	FILE			*f;
	char			*fname;
	long			nb_bytes_written;
	long			nb_last_written;
	long			ps_x;
	long			ps_y;
	long			ps_w;
	long			ps_h;
	long			rds_x;
	long			rds_y;
	long			rds_w;
	long			rds_h;
} rps_pge;

typedef struct rps_param
{
	char		*figname;
	rdsfig_list	*fig;
	long		draw_w;
	long		draw_h;
	long		paper_x;
	long		paper_y;
	long		paper_w;
	long		paper_h;
	char		papername[16];
	char		verbose;
	char		a3tray;
	char		couleur;
	char		flatten;
	char		tilcatal;
	char		header;
	char		landscape;
	char		real;
	long		resol;
	int		nbx_pages;
	int		nby_pages;
	double		tops;
	char		dictfilename[256];
              /* The rest of the structure doesn't have to be completed */
	char		width_first;
	long		rds_x;
	long		rds_y;
	long		rds_w;
	long		rds_h;
	long		rds_dx;
	long		rds_dy;
	rps_pge		*headpages;
	char		err[128];
	char		cmdline[1024];
} rps_par;

#ifndef DRIVE2PS
#ifdef __STDC__		/* We're ANSI */
	extern void saveps (struct rps_param *param);
	extern void rps_GetBoundingBox (rdsfig_list *fig);
#else
	extern saveps ();
	extern rps_GetBoundingBox ();
#endif
#endif
