/*------------------------------------------------------------\
|                                                             |
| Tool    :                     RDS                           |
|                                                             |
| File    :                  Rds Windows                      |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   01.08.93                        |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef RWI_103
# define RWI_103

# define RWI_MAX_REC       8
# define RWI_MAX_LAYER     RDS_ABOX

/*------------------------------------------------------------\
|                                                             |
|                        Flags for window                     |
|                                                             |
\------------------------------------------------------------*/

# define RDS_ONE_WINDOW      (long)0x00010000

/*------------------------------------------------------------\
|                                                             |
|                            Macros                           |
|                                                             |
\------------------------------------------------------------*/

# define IsRdsOneWindow( Rectangle )        \
                                            \
   ( ( Rectangle )->FLAGS & RDS_ONE_WINDOW )

# define SetRdsOneWindow( Rectangle )       \
                                            \
   ( ( Rectangle )->FLAGS |= RDS_ONE_WINDOW )

# define ClearRdsOneWindow( Rectangle )      \
                                             \
   ( ( Rectangle )->FLAGS &= ~RDS_ONE_WINDOW )

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                  Rds Window, Rectangle List                 |
|                                                             |
\------------------------------------------------------------*/

  typedef struct rdswinrec_list   

  {
    struct rdswinrec_list *NEXT; 
    rdsrec_list           *RECTAB[ RWI_MAX_REC ];

  } rdswinrec_list;

/*------------------------------------------------------------\
|                                                             |
|                      Rds Window list                        |
|                                                             |
\------------------------------------------------------------*/

  typedef struct rdswin_list

  {
    struct rdswinrec_list *LAYERTAB[ RWI_MAX_LAYER ];

  } rdswin_list;

/*------------------------------------------------------------\
|                                                             |
|                  Rds rectangle, Window List                 |
|                                                             |
\------------------------------------------------------------*/

  typedef struct rdsrecwin_list 

  {
    struct rdsrecwin_list *NEXT;
    struct rdswin_list    *WINDOW;
    
  } rdsrecwin_list;

/*------------------------------------------------------------\
|                                                             |
|                         Rds Window                          |
|                                                             |
\------------------------------------------------------------*/

  typedef struct rdswindow

  {
    long          XMIN;
    long          YMIN;
    long          XMAX;
    long          YMAX;
    long          MASK;
    long          DX;
    long          DY;
    long          SIDE;
    long          SIZE;
    rdswin_list  *WINTAB;
    
  } rdswindow;

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       Alloc functions                       |
|                                                             |
\------------------------------------------------------------*/

  extern rdswinrec_list *allocrdswinrec();
  extern rdsrecwin_list *allocrdsrecwin();
  extern rdswin_list    *allocrdswin();
  extern rdswindow      *allocrdswindow();
  
/*------------------------------------------------------------\
|                                                             |
|                     Get functions                           |
|                                                             |
\------------------------------------------------------------*/

  extern chain_list *getrdswindow();
   
/*------------------------------------------------------------\
|                                                             |
|                 Build & Destroy functions                   |
|                                                             |
\------------------------------------------------------------*/
   
  extern void        addrdsrecwindow();
  extern void        delrdsrecwindow();
  extern rdswindow  *buildrdswindow();
  extern void        destroyrdswindow();
  extern void        viewrdswindow();

# endif
