/*------------------------------------------------------------\
|                                                             |
| Tool    :                     RDS                           |
|                                                             |
| File    :                  Rprparse.h                       |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   01.08.93                        |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef RPR_PARSE
# define RPR_PARSE

# define RPR_MAX_RDS_UNIT      100000L
# define RPR_EPSILON           ((double)0.001)
# define RPR_MAX_BUFFER        512
# define RPR_MAX_KEYWORD       66

# define RPR_SEPARATORS_STRING " \t\n"
# define RPR_COMMENT_CHAR      '#'
# define RPR_NULL              NULL

/*------------------------------------------------------------\
|                                                             |
|                        Keyword Constants                    |
|                                                             |
\------------------------------------------------------------*/

# define DEFINE_KEYWORD          "DEFINE"
# define TABLE_KEYWORD           "TABLE" 
# define END_TABLE_KEYWORD       "END"
# define END_RECORD_KEYWORD       NULL
# define LAMBDA_KEYWORD          "LAMBDA"
# define PHYSICAL_GRID_KEYWORD   "PHYSICAL_GRID"
# define SEGMENT_KEYWORD         "MBK_TO_RDS_SEGMENT"
# define VIA_KEYWORD             "MBK_TO_RDS_VIA"
# define CONNECTOR_KEYWORD       "MBK_TO_RDS_CONNECTOR"
# define REFERENCE_KEYWORD       "MBK_TO_RDS_REFERENCE"
# define CIF_LAYER_KEYWORD       "CIF_LAYER"
# define GDS_LAYER_KEYWORD       "GDS_LAYER" 
# define S2R_POST_TREAT_KEYWORD  "S2R_POST_TREAT"
# define S2R_OVERSIZE_KEYWORD    "S2R_OVERSIZE_DENOTCH"
# define S2R_RING_WIDTH_KEYWORD  "S2R_BLOC_RING_WIDTH"
# define S2R_LAYER_WIDTH_KEYWORD "S2R_MINIMUM_LAYER_WIDTH"
# define LYNX_GRAPH_KEYWORD      "LYNX_GRAPH"
# define LYNX_CAPA_KEYWORD       "LYNX_CAPA"

# define RPR_LAMBDA_MASK            0x0001
# define RPR_PHYSICAL_GRID_MASK     0x0002
# define RPR_SEGMENT_MASK           0x0004
# define RPR_VIA_MASK               0x0008
# define RPR_CONNECTOR_MASK         0x0010
# define RPR_REFERENCE_MASK         0x0020
# define RPR_CIF_LAYER_MASK         0x0040
# define RPR_GDS_LAYER_MASK         0x0080
# define RPR_S2R_POST_TREAT_MASK    0x0100
# define RPR_S2R_OVERSIZE_MASK      0x0200
# define RPR_S2R_RING_WIDTH_MASK    0x0400
# define RPR_S2R_LAYER_WIDTH_MASK   0x0800
# define RPR_LYNX_GRAPH_MASK        0x1000
# define RPR_LYNX_CAPA_MASK         0x2000
                                         
# define RPR_ALL_DEFINED_MASK       0x3FFF

/*------------------------------------------------------------\
|                                                             |
|                           Macros                            |
|                                                             |
\------------------------------------------------------------*/

# define RprEqual(a,b)                                       \
                                                             \
     ((((a)-RPR_EPSILON) <= (b)) && (((b)) <= (a)+RPR_EPSILON))

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/

  typedef struct keyword
  {
    char *NAME;
    char  VALUE;

  } keyword;

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

# endif
