/*------------------------------------------------------------\
|                                                             |
| Tool    :                     RDS                           |
|                                                             |
| File    :                   Rut203.h                        |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   01.08.93                        |
|                                                             |
\------------------------------------------------------------*/

# ifndef RUT_203
# define RUT_203

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# define RDS_YES     1
# define RDS_NO      0

/*------------------------------------------------------------\
|                                                             |
|                             Macros                          |
|                                                             |
\------------------------------------------------------------*/

# define CheckPhysicalGridAligned(c) ((c) % RDS_PHYSICAL_GRID)

/*------------------------------------------------------------\
|                                                             |
|                             Type                            |
|                                                             |
\------------------------------------------------------------*/


  typedef struct coord_t
  {
    long X;
    long Y;

  } coord_t;

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  extern char RDS_SYMMETRY_TABLE[ RDS_MAX_TRANSF ][ RDS_MAX_TRANSF ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern rdsfig_list *searchrdsfig();
  extern rdsins_list *searchrdsins();
  extern ptype_list  *getrdsmodellist();
  extern void         applyrdssym();
  extern void         applyrdsmode();
  extern void         flattenrdsfig();
  extern void         rflattenrdsfig();

  extern void         diag2rec();
  extern void         poly2diag();
  extern int          ispolyrec();

# endif
