/*------------------------------------------------------------\
|                                                             |
| Tool    :                     RDS                           |
|                                                             |
| File    :                   Rfm 203                         |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   01.08.93                        |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef RFM_203
# define RFM_203

/*------------------------------------------------------------\
|                                                             |
|                       Special Macros                        |
|                                                             |
\------------------------------------------------------------*/

# define RfmRoundHigh(X)                                \
                                                        \
    (((X)>=0) ? ((((X) + ( RDS_PHYSICAL_GRID >> 1 ))    \
                       / RDS_PHYSICAL_GRID ) *          \
                         RDS_PHYSICAL_GRID )            \
              :  (((X) / RDS_PHYSICAL_GRID ) *          \
                         RDS_PHYSICAL_GRID )            )

# define RfmRoundLow(X)                                 \
                                                        \
    (((X)>=0) ? (((X) / RDS_PHYSICAL_GRID ) *           \
                        RDS_PHYSICAL_GRID )             \
              : ((((X) - ( RDS_PHYSICAL_GRID >> 1 ))    \
                       /  RDS_PHYSICAL_GRID ) *         \
                          RDS_PHYSICAL_GRID )           )

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern rdsrec_list *segmbkrds();
  extern rdsrec_list *viambkrds();
  extern rdsrec_list *refmbkrds();
  extern rdsrec_list *conmbkrds();
  extern rdsrec_list *aboxmbkrds();

  extern rdsrec_list *insconmbkrds();
  extern rdsrec_list *insviambkrds();
  extern rdsrec_list *insrefmbkrds();
  extern rdsrec_list *inssegmbkrds();

  extern rdsins_list *insmbkrds();
  extern rdsfig_list *figmbkrds();
  extern rdsfig_list *modelmbkrds();

  extern void         viewrfmrec();
  extern void         viewrfmseg();
  extern void         viewrfmvia();
  extern void         viewrfmref();
  extern void         viewrfmcon();
  extern void         viewrfmins();
  extern void         viewrfmfig();
 
  extern void         roundrdsrec();

# endif
