/*------------------------------------------------------\
|                                                       |
|  Title   :   Structures and fonctions for RDS         |
|                                                       |
|  Date    :            01.08.93                        |
|                                                       |
|  Author  :        Jacomme Ludovic                     |
|                                                       |
\------------------------------------------------------*/

/*------------------------------------------------------\
|                                                       |
|                      Constants                        |
|                                                       |
\------------------------------------------------------*/

# ifndef RDS_203
# define RDS_203

/*------------------------------------------------------\
|                                                       |
|                          Alloc                        |
|                                                       |
\------------------------------------------------------*/

# define RDS_ALLOC_BLOCK   0
# define RDS_ALLOC_HEAP    1

/*------------------------------------------------------\
|                                                       |
|                     Instance Symmetry                 |
|                                                       |
\------------------------------------------------------*/

# define RDS_NOSYM  0
# define RDS_ROT_P  1
# define RDS_SYMXY  2
# define RDS_ROT_M  3
# define RDS_SYM_X  4
# define RDS_SY_RM  5
# define RDS_SYM_Y  6
# define RDS_SY_RP  7

# define RDS_MAX_TRANSF ( RDS_SY_RP + 1 )

/*------------------------------------------------------\
|                                                       |
|                        Rds Layers                     |
|                                                       |
\------------------------------------------------------*/

# define RDS_NWELL   0
# define RDS_PWELL   1
# define RDS_NIMP    2
# define RDS_PIMP    3
# define RDS_ACTIV   4
# define RDS_NDIF    5
# define RDS_PDIF    6
# define RDS_NTIE    7
# define RDS_PTIE    8
# define RDS_POLY    9
# define RDS_GATE    10
# define RDS_TPOLY   11
# define RDS_CONT    12
# define RDS_ALU1    13
# define RDS_TALU1   14
# define RDS_VIA1    15
# define RDS_ALU2    16
# define RDS_TALU2   17
# define RDS_VIA2    18
# define RDS_ALU3    19
# define RDS_TALU3   20
# define RDS_VIA3    21
# define RDS_ALU4    22
# define RDS_CPAS    23
# define RDS_REF     24
# define RDS_USER0   25
# define RDS_USER1   26
# define RDS_USER2   27
# define RDS_ABOX    28

# define RDS_MAX_LAYER   ( RDS_ABOX + 1 )

/*------------------------------------------------------\
|                                                       |
|                       Layer Macros                    |
|                                                       |
\------------------------------------------------------*/

# define GetRdsLayer( Rectangle )                       \
                                                        \
         ( (char)( (Rectangle->FLAGS) & 0xFF ) )

# define SetRdsLayer( Rectangle, Layer )                \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS & ~0xFF) | Layer )

/*------------------------------------------------------\
|                                                       |
|                         Mbk Type                      |
|                                                       |
\------------------------------------------------------*/

# define MBK_CONNECTOR   (long)(0x00000100)
# define MBK_SEGMENT     (long)(0x00000200)
# define MBK_REFERENCE   (long)(0x00000300)
# define MBK_VIA         (long)(0x00000400)
# define MBK_INSTANCE    (long)(0x00000500)
# define MBK_FIGURE      (long)(0x00000600)

# define RDS_MBK_TYPE    (long)(0x00000F00)

/*------------------------------------------------------\
|                                                       |
|                     Mbk Type Macros                   |
|                                                       |
\------------------------------------------------------*/

# define GetRdsMbkType( Rectangle )                     \
                                                        \
   ( (Rectangle)->FLAGS & RDS_MBK_TYPE                  )

# define SetRdsMbkType( Rectangle, MbkType )            \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
        & ~RDS_MBK_TYPE) | (MbkType)                    )

/*------------------------------------------------------\
|                                                       |
|                       Is Mbk Type                     |
|                                                       |
\------------------------------------------------------*/

# define IsRdsConnector( Rectangle )                    \
                                                        \
  (((Rectangle)->FLAGS & RDS_MBK_TYPE) == MBK_CONNECTOR )

# define IsRdsSegment( Rectangle )                      \
                                                        \
  (((Rectangle)->FLAGS & RDS_MBK_TYPE) == MBK_SEGMENT   )

# define IsRdsReference( Rectangle )                    \
                                                        \
  (((Rectangle)->FLAGS & RDS_MBK_TYPE) == MBK_REFERENCE )

# define IsRdsVia( Rectangle )                          \
                                                        \
  (((Rectangle)->FLAGS & RDS_MBK_TYPE) == MBK_VIA       )

# define IsRdsInstance( Rectangle )                     \
                                                        \
  (((Rectangle)->FLAGS & RDS_MBK_TYPE) == MBK_INSTANCE  )

# define IsRdsFigure( Rectangle )                       \
                                                        \
  (((Rectangle)->FLAGS & RDS_MBK_TYPE) == MBK_FIGURE    )

/*------------------------------------------------------\
|                                                       |
|                       Set Mbk Type                    |
|                                                       |
\------------------------------------------------------*/

# define SetRdsConnector( Rectangle )                   \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
        & ~RDS_MBK_TYPE) | MBK_CONNECTOR )

# define SetRdsSegment( Rectangle )                     \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
        & ~RDS_MBK_TYPE) | MBK_SEGMENT   )

# define SetRdsReference( Rectangle )                   \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
        & ~RDS_MBK_TYPE) | MBK_REFERENCE )

# define SetRdsVia( Rectangle )                         \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
        & ~RDS_MBK_TYPE) | MBK_VIA                      )

# define SetRdsInstance( Rectangle )                    \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
        & ~RDS_MBK_TYPE) | MBK_INSTANCE                 )

# define SetRdsFigure( Rectangle )                      \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
        & ~RDS_MBK_TYPE) | MBK_FIGURE                   )

/*------------------------------------------------------\
|                                                       |
|                      Extract Type                     |
|                                                       |
\------------------------------------------------------*/

# define RDS_FIG_REC         (long)(0x00008000)

# define RDS_CON_EXTER       (long)(0x00001000)
# define RDS_CON_INTER       (long)(0x00002000)
# define RDS_REF_REF         (long)(0x00003000)
# define RDS_REF_CON         (long)(0x00004000)

# define RDS_EXTRACT_TYPE    (long)(0x00007000)

/*------------------------------------------------------\
|                                                       |
|                  Extract Type Macros                  |
|                                                       |
\------------------------------------------------------*/


# define GetRdsExtractType( Rectangle )                 \
                                                        \
   ( (Rectangle)->FLAGS & RDS_EXTRACT_TYPE              )

# define SetRdsExtractType( Rectangle, ExtractType )    \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
        & ~RDS_EXTRACT_TYPE) | (ExtractType)            )

/*------------------------------------------------------\
|                                                       |
|                    Is Extract Type                    |
|                                                       |
\------------------------------------------------------*/

# define IsRdsConExter( Rectangle )                     \
                                                        \
  (((Rectangle)->FLAGS & RDS_EXTRACT_TYPE) == RDS_CON_EXTER )

# define IsRdsConInter( Rectangle )                     \
                                                        \
  (((Rectangle)->FLAGS & RDS_EXTRACT_TYPE) == RDS_CON_INTER )

# define IsRdsRefRef( Rectangle )                       \
                                                        \
  (((Rectangle)->FLAGS & RDS_EXTRACT_TYPE) == RDS_REF_REF )
 
# define IsRdsRefCon( Rectangle )                       \
                                                        \
  (((Rectangle)->FLAGS & RDS_EXTRACT_TYPE) == RDS_REF_CON )

# define IsRdsFigRec( Rectangle )                       \
                                                        \
   ((Rectangle)->FLAGS & RDS_FIG_REC )

/*------------------------------------------------------\
|                                                       |
|                   Set Extract Type                    |
|                                                       |
\------------------------------------------------------*/

# define SetRdsConExter( Rectangle )                    \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
     & ~RDS_EXTRACT_TYPE) | RDS_CON_EXTER               )

# define SetRdsConInter( Rectangle )                    \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
     & ~RDS_EXTRACT_TYPE) | RDS_CON_INTER               )

# define SetRdsRefRef( Rectangle )                      \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
     & ~RDS_EXTRACT_TYPE) | RDS_REF_REF                 )

# define SetRdsRefCon( Rectangle )                      \
                                                        \
   ( (Rectangle)->FLAGS = ((Rectangle)->FLAGS           \
                                                        \
     & ~RDS_EXTRACT_TYPE) | RDS_REF_CON                 )

# define SetRdsFigRec( Rectangle )                      \
                                                        \
   ( (Rectangle)->FLAGS |= RDS_FIG_REC )

# define ClearRdsFigRec( Rectangle )                    \
                                                        \
   ( (Rectangle)->FLAGS &= ~RDS_FIG_REC )

/*------------------------------------------------------\
|                                                       |
|                       Structures                      |
|                                                       |
\------------------------------------------------------*/

  typedef struct rdsrec_list

  {
    struct rdsrec_list *NEXT;
    long                X;
    long                Y;
    long                DX;
    long                DY;
    long                FLAGS;
    char               *NAME;
    void               *USER;

  } rdsrec_list;


  typedef struct rdsins_list

  {
    struct rdsins_list *NEXT;
    char               *FIGNAME;
    char               *INSNAME;
    long                X;
    long                Y;
    char                TRANSF;
    unsigned int        SIZE;
    char                FLAGS;
    struct rdsrec_list *LAYERTAB[ RDS_MAX_LAYER ];
    struct rdsrec_list *COURONNE[ RDS_MAX_LAYER ];
    void               *USER;

  } rdsins_list;

  typedef struct rdsfig_list
 
  {
    struct rdsfig_list   *NEXT;
    char                 *NAME;
    struct rdsrec_list   *LAYERTAB[ RDS_MAX_LAYER ];
    struct rdsins_list   *INSTANCE;
    char                  MODE;
    unsigned int          SIZE;
    char                  FLAGS;
    char                  FLAGTAB[ RDS_MAX_LAYER ];
    struct rdsrec_list   *BBOXTAB[ RDS_MAX_LAYER ];
    void                 *USER;

  } rdsfig_list;
 
/*------------------------------------------------------\
|                                                       |
|                     Global Variables                  |
|                                                       |
\------------------------------------------------------*/

 extern rdsfig_list *HEAD_RDSFIG;
 extern char         RDS_LAYER_NAME  [ RDS_MAX_LAYER  ][ 12 ];
 extern char         RDS_TRANSF_NAME [ RDS_MAX_TRANSF ][ 8  ];

/*------------------------------------------------------\
|                                                       |
|                        Functions                      |
|                                                       |
\------------------------------------------------------*/
/*------------------------------------------------------\
|                                                       |
|                      Alloc Functions                  |
|                                                       |
\------------------------------------------------------*/

  extern char        *rdsalloc();
  extern rdsfig_list *allocrdsfig();
  extern rdsins_list *allocrdsins();
  extern rdsrec_list *allocrdsrec();

/*------------------------------------------------------\
|                                                       |
|                      Free  Functions                  |
|                                                       |
\------------------------------------------------------*/

  extern void  rdsfree();
  extern void  freerdsfig();
  extern void  freerdsins();
  extern void  freerdsrec();

/*------------------------------------------------------\
|                                                       |
|                       Add  Functions                  |
|                                                       |
\------------------------------------------------------*/

  extern rdsrec_list *addrdsfigrec();
  extern rdsrec_list *addrdsinsrec();
  extern rdsins_list *addrdsins();
  extern rdsfig_list *addrdsfig();

/*------------------------------------------------------\
|                                                       |
|                       Del  Functions                  |
|                                                       |
\------------------------------------------------------*/

  extern int delrdsfigrec();
  extern int delrdsinsrec();
  extern int delrdsins();
  extern int delrdsfig();

/*------------------------------------------------------\
|                                                       |
|                      View  Functions                  |
|                                                       |
\------------------------------------------------------*/

  extern void viewrdsrec(); 
  extern void viewrdsins();
  extern void viewrdsfig();

# endif 
