#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <genlib.h>

#include IAC_H
#include ICN_H
#include ICU_H

/* some defines :
   for normalisation purposes
   to ease the description */
/* to use the usual system of coordinates */
#define ICONX  30
#define ICONY -30
/* to make homogeneous connector placement */
#define CON_NORTH(d) SAX_NORTH, d, SAX_CENTER, SAX_UP,     SAX_HORIZONTAL
#define CON_SOUTH(d) SAX_SOUTH, d, SAX_CENTER, SAX_DOWN,   SAX_HORIZONTAL
#define CON_WEST(d)  SAX_WEST,  d, SAX_LEFT,   SAX_CENTER, SAX_HORIZONTAL
#define CON_EAST(d)  SAX_EAST,  d, SAX_RIGHT,  SAX_CENTER, SAX_HORIZONTAL
/* globals for the use of the macros */
IconGate_list *icon;
IconComp_list *comp = NULL;
#define ADDICONGATE(name, xm, ym, xi, yi, xl, yl)                    \
        (icon = addicongate(name, (xm) * ICONX, (ym) * ICONY,        \
                             SAX_CENTER, SAX_CENTER, SAX_HORIZONTAL, \
                             (xi) * ICONX, (yi) * ICONY,             \
                             SAX_CENTER, SAX_CENTER, SAX_HORIZONTAL, \
                             (xl) * ICONX, (yl) * ICONY,             \
                             SAX_CENTER, SAX_CENTER, SAX_HORIZONTAL))
#define ADDICONCON(name, xc, yc, face, dir) \
        do {                           \
            switch (face) { \
               case SAX_NORTH: \
                            addiconcon(icon, name, (xc) * ICONX, (yc) * ICONY, \
                             CON_NORTH(dir), \
                             (xc) * ICONX, ((yc) - 22) * ICONY); \
                  break; \
               case SAX_SOUTH: \
                            addiconcon(icon, name, (xc) * ICONX, (yc) * ICONY, \
                             CON_SOUTH(dir), \
                             (xc) * ICONX, ((yc) + 22) * ICONY); \
                  break; \
               case SAX_EAST: \
                            addiconcon(icon, name, (xc) * ICONX, (yc) * ICONY, \
                                                           CON_EAST(dir), \
                             ((xc) - 22) * ICONX, (yc) * ICONY); \
                  break; \
               case SAX_WEST: \
                            addiconcon(icon, name, (xc) * ICONX, (yc) * ICONY, \
                             CON_WEST(dir), \
                             ((xc) + 22) * ICONX, (yc) * ICONY); \
                  break; \
            } \
         } while (0)
#define ADDICONLINE(x0, y0, x1, y1) \
        addiconline(icon, (x0) * ICONX, (y0) * ICONY, \
                    (x1) * ICONX, (y1) * ICONY)
#define ADDICONSHAPE() do { \
                          addiconshape(icon, comp); \
                          comp = NULL; \
                       } while(0)
#define ADDICONCOMP(type, x, y) \
        (comp = addiconcomp(comp, type, (x) * ICONX, (y) * ICONY))
#define SAVEICON() do { \
                      mbkenv(); \
                      update_icon(icon); \
                      saveicon(icon); \
                   } while(0)


#define rage_t_name ("espcd10")
#define rage_t_mic (1.0) 

#define rage_tc_gate (1670e-6)
#define rage_tc_poly (160e-6)
#define rage_tc_alu1 (160e-6)
#define rage_tc_alu2 (160e-6)

char valeur();
char TRANSF;
int taille, L, C, i, j, bpm, bpm2, X, Y, M, col, tr, un;

main(argc,argv)
int argc;
char *argv[] ;
{
 int a, c, i, bits, words, factor, uni, tras, lay, net, outl, vhdl, data, icon, wrd;
 char *s;
 char *name, car;

 i = present();

 if( argc < 3 ) {
                  printf(
                  "Usage : rage <bits> <words> [-n |-m |-w] [-u] [-t<n>] [-o blockname] [-layout] [-vhdl] [-datasheet] [-icon] [-logicalbox] [-physicalbox] \n");
                  exit(1);
                 }

 for( i=1;i<3;i++)
 for( s = argv[i] ; *s !='\0' ; s++ )
 if( *s < '0' || *s > '9' ){
 if ( i == 1 ) {
                printf("Omitted bits per word \n");
               } 
 else {
       printf("Omitted number of words \n");
      }
 exit( 2 );
 }

 bits = atoi(argv[1]);
 words = atoi(argv[2]);

 factor = uni = tras = lay = net = outl = vhdl = data = icon = 0;
 car = '\0';
 name = &car;
 for(i=3; i<argc ; i++)
 {
  if( strcmp( argv[ i ], "-n" ) == 0) factor = 0;
  else
  if( strcmp( argv[ i ], "-m" ) == 0) factor = 1;
  else
  if( strcmp( argv[ i ], "-w" ) == 0) factor = 2;
  else
  if( strcmp( argv[ i ], "-u" ) == 0) uni = 1;
  else
  if( strcmp( argv[ i ], "-t1" ) == 0) tras = 1;
  else
  if( strcmp( argv[ i ], "-t2" ) == 0) tras = 2;
  else
  if( strcmp( argv[ i ], "-layout" ) == 0) lay = 1;
  else
  if( strcmp( argv[ i ], "-netlist" ) == 0) net = 1;
  else
  if( strcmp( argv[ i ], "-physicalbox" ) == 0) outl = outl+1;
  else
  if( strcmp( argv[ i ], "-logicalbox" ) == 0) outl = outl+10;
  else
  if( strcmp( argv[ i ], "-vhdl" ) == 0) vhdl = 1;
  else
  if( strcmp( argv[ i ], "-datasheet" ) == 0) data = 1;
  else
  if( strcmp( argv[ i ], "-icon" ) == 0) icon = 1;
  else
  if( strcmp( argv[ i ], "-o" ) == 0){
        name = argv[i+1];
        if(*name == '\0'){
             printf(
             "The name must be included after the [-o] option \n"); 
             exit( 3 );
        }
  }
 }

 if( bits > 128 || bits < 2 ){
                              printf("Number of bits out of range [2-128]\n"); 
                              exit(4);
                             }
 i = bits /2;
 i = i*2;
 if( bits != i ){
                 printf("bits must be even \n");
                 exit(5);
                }
/*
 if( words < 7 || words > 12 ){
                               printf("words out of range [7-12]\n");  
                               exit(6);
                              }
*/
switch(words)
{
 case 128:{
           wrd = 7;
           break;
          }
 case 256:{
           wrd = 8;
           break;
          }
 case 512:{
           wrd = 9;
           break;
          }
 case 1024:{
           wrd = 10;
           break;
          }
 case 2048:{
           wrd = 11;
           break;
          }
 case 4096:{
           wrd = 12;
           break;
          }
 default:{
          if( words < 128 || words > 4096 ){
                                            printf("words out of range [128-4096]\n");
                                           }
          else {
                printf("illegal size: size must be a power of 2[128, 256, .. ,4096]\n");
               }
                                            exit(6);
         }
}

 switch(wrd)
 {
  case 7 :{
           a = 1;
           c = 6;
           break;
          }
  case 8 :{
           switch(factor)
           {
             case 0:{ 
                     a = 1;
                     c = 7;
                     break;
                    }
             default:{ 
                      a = 2;
                      c = 6;
                      break;
                     }
           }
           break;
          }
  case 9 :{
           switch(factor)
           {
             case 0:{ 
                     a = 1;
                     c = 8;
                     break;
                    }
             case 1:{ 
                     a = 2;
                     c = 7;
                     break;
                    }
             default:{ 
                      a = 3;
                      c = 6;
                      break;
                     }
           }
           break;
          }
  case 10:{
           switch(factor)
           {
             case 0:{ 
                     a = 2;
                     c = 8;
                     break;
                    }
             case 1:{ 
                     a = 3;
                     c = 7;
                     break;
                    }
             default:{ 
                      a = 4;
                      c = 6;
                      break;
                     }
           }
           break;
          }
  case 11:{
           switch(factor)
           {
             case 0:{ 
                     a = 3;
                     c = 8;
                     break;
                    }
             default:{ 
                      a = 4;
                      c = 7;
                      break;
                     }
           }
           break;
          }
  case 12:{
           a = 4;
           c = 8;
           break;
          }
  default: break;
 } 

  i = gram(a,bits,c,uni,tras,lay,net,outl,vhdl,data,icon,name); 
  
  exit(0);
}

 
/*   a: correspond a la taille du mux de la RAM  en puiss de 2  */
/*   b: correspond a la taille du mot de la RAM                 */
/*   c: correspond au nombre de lignes de la RAM  en puiss de 2 */
/*                                                              */
/*   d: uni ou bi-dir                                           */
     
     
gram(a,b,c,d,e,f,g,h,r,s,t,name)
int a, b, c, d, e, f, g, h, r, s, t;
char *name;
{
  int i,j,k,l,x,y;
  char  nom[12], *p;
  taille = a+c;
  bpm = b;
  bpm2 = (int) bpm/2;
  L = c;
  C = a;
  tr = e;
  un = d;
  if(*name != '\0'){
                    i = 0;
                    p = name;
                    while(*p != '\0')
                    {
                     nom[i++] = *p++;
                    }
                     nom[i] = '\0';
                   }
  else {
        nom[0] = 'm';
        nom[1] = 'e';
        nom[2] = 'm';
        nom[3] = '_';
        nom[4] = valeur(L);
        nom[5] = '_';
        nom[6] = valeur(C);
        nom[7] = '\0';
       }
  
  if((f==1) || (h==1) || (h==11)){ 
      i = bit_col();
      y= Y + 56; 
      x = puiss(C)*18;
      switch(tr)
      {
       case 0 :{ x += 10;
                 break;
               }
       case 1 :{ x += 12;
                 break;
               }
       case 2 :{ x += 15;
                 break;
               }
       default: break;
      }
      x = x * bpm;
      i = decgen();
      x += 421;
      DEF_PHFIG(nom);
      i = genram();
      DEF_AB(0, 0, 0, 0);
      i = copcon();
      if(((h==1) || (h==11)) && (f==0)) i = outline();
      SAVE_PHFIG();
            }
  if (r==1) i=vhdl(nom);
  if (s==1) i=data(nom);
  if (t==1) i=rage_icon(nom);
  if (h>=10) i=logical(nom);
}
  

genram()
 {
int i,j,k,y;

PLACE(NAME("rbit_col_%d_%d",L,C),"rbit_0_0",NOSYM,0,0);
for(i=1; i<bpm2; i++)
PLACE_RIGHT(NAME("rbit_col_%d_%d",L,C),NAME("rbit_%d_0",i),NOSYM);

PLACE_RIGHT(NAME("decoder_%d_%d",L,C), "decod",NOSYM);

for(i=0; i<bpm2; i++)
PLACE_RIGHT(NAME("rbit_col_%d_%d",L,C),NAME("rbit_%d_1",i),SYM_X);
}


decod()
{
 int i, j, k, l, m;

 M = 13;
 m = puiss(L-2);
 for(i=0;i<m;i++)
 {
   PLACE(NAME("dtdcg%d_c",L), NAME("DECG_%d", i), NOSYM, M, Y);
   PLACE_RIGHT("dtcmb_c",NAME("ADR_%d",i),NOSYM);
   PLACE_RIGHT(NAME("dtdcd%d_c",L), NAME("DECD_%d", i), NOSYM);
   Y+=104;
 }
  return(0);
}

puiss(i)
 int i;
{
 if (i==0) return(1);
 else return(2*puiss(i-1));
}
    
data(name)
char *name;
{
int t, height, width;
float heightm, widthm;
FILE *out;

out=stdout;
fprintf(out,"Name :  \"%s\" \n\n",name);
fprintf(out,"Function : Static Random Access Memory of ");

t= L+C;
switch(t)
{
 case 7:
 case 8:
 case 9:{ fprintf(out,"%d words of %d bits size\n",puiss(t),bpm);
          break;
        }
 case 10:
 case 11:
 case 12:{ fprintf(out,"%dK-words of %d bits size\n",puiss(t-10),bpm);
          break;
        }
 default:break;
}
if(un==1) fprintf(out,"           with unidirectionnal Datain and Dataout Buses\n\n");
else fprintf(out,"           with bidirectionnal Datain/Dataout Bus\n\n");


fprintf(out,"Technology : \"%s\" \n\n",rage_t_name);

switch(C)
{
 case 1:{ if(un==1) height = 810;
          else height = 868;
          break;
        }
 default:{ height = 670;
           break;
         }
}
height += puiss(L)*26 + 56;

width= puiss(C)*18;

switch(tr)
{
 case 0:{ width +=10;
          break;
        }
 case 1:{ width +=12;
          break;
        }
 case 2:{ width +=15;
          break;
        }
 default:break;
}
width = width * bpm + 421;

widthm = width * rage_t_mic;
heightm = height * rage_t_mic;

fprintf(out, "Dimensions :\n");
fprintf(out, "              Height  Width      Area\n");
fprintf(out, "Lambdas        %5d  %5d%10d\n",
  height, width, height*width);
fprintf(out, "Microns        %5.0f  %5.0f%10.0f\n\n",
  heightm, widthm, heightm*widthm);

fprintf(out, "List of signals connectors :\n");
fprintf(out, "****************************\n\n");
fprintf(out, "  entries :\n");
fprintf(out, "  ---------\n");

fprintf(out, "    adr[%d:0];\n", L+C-1);
fprintf(out, "    ck;\n");
fprintf(out, "    write;\n");
if(un==1) fprintf(out, "    din[%d:0];\n", bpm-1);

fprintf(out, "\n  outputs :\n");
fprintf(out, "  ---------\n");

fprintf(out, "    dout[%d:0];\n", bpm-1);
}

logical(name)
char *name;
{
 int i;

 DEF_LOFIG(name);

  LOCON(NAME("adr[%d:0]",(L+C-1)),'I',NAME("adr[%d:0]",(L+C-1)));
 if(un==0){
  {
  LOCON(NAME("dout[%d:0]",bpm-1),'X',NAME("dout[%d:0]",bpm-1));
  }
          }
 else {
  LOCON(NAME("dout[%d:0]",bpm-1),'O',NAME("dout[%d:0]",bpm-1));
  LOCON(NAME("din[%d:0]",bpm-1),'I',NAME("din[%d:0]",bpm-1));
      }
  LOCON("ck",'I',"ck");
  LOCON("write",'I',"write");
  LOCON("vdd",'I',"vdd");
  LOCON("vss",'I',"vss");

 SAVE_LOFIG();   
}

bit_col()
{ int i,j,k;
  char TRANS;
  long x;

 DEF_PHFIG(NAME("ibit_%d",C));
 
 switch (C)
  {
    case 1:{
       	    if(un==0) {
                       PLACE("dtio2_c","IO_1", NOSYM, 0, 0);
                       Y = 616;
                      }
       	    else {
                  PLACE("dtio0_c","IO_1", NOSYM, 0, 0);
                  Y = 558;
                 }
            PLACE_TOP("dtio_c","IO_0", NOSYM);
            break;
           }
    case 2:
    case 3:
    case 4:{
       	    if(un==0) PLACE("dtio3_c","IO_0", NOSYM, 0, 0);
       	    else PLACE("dtio4_c","IO_0", NOSYM, 0, 0);
            Y = 418;
            break;
           }
    default: break;
  }


 for(i=0;i<puiss(C-1);i++)
 {
  if(i==0) PLACE("dtmx0_c","MUX0",NOSYM,0,Y);
  else
  if(i==(puiss(C-1)-1)) PLACE_RIGHT("dtmxm_c",NAME("MUX%d",i),NOSYM);
  else
  PLACE_RIGHT("dtmxi_c",NAME("MUX%d",i),NOSYM);
 }


 Y += 134;
 PLACE("dtali1_c", "alim1_0", NOSYM, 0,Y);
 for(i=1;i<puiss(C-1);i++)
 PLACE_RIGHT("dtali1_c", NAME("alim1_%d", i), NOSYM);


 DEF_AB(0,0,0,0);

 for(i=0;i<puiss(C-1);i++)
 {
  PLACE_VIA_REF(NAME("MUX%d",i),NAME("sl%d",2*i),CONT_VIA);
  WIRE1(ALU2,2,NAME("MUX%d",i),NAME("sl%d",2*i),0,NAME("MUX%d",i),"rsel0",0);
  PLACE_VIA_REF(NAME("MUX%d",i),NAME("sl%d",2*i+1),CONT_VIA);
  WIRE1(ALU2,2,NAME("MUX%d",i),NAME("sl%d",2*i+1),0,NAME("MUX%d",i),"rsel1",0);
  for(j=0;j<puiss(C);j++)
  {
   WIRE1(ALU1,1,NAME("MUX%d",i),NAME("sl_1_%d",j),0,NAME("MUX%d",i),NAME("sl_2_%d",j),0);
  }
 }

  for(j=0;j<puiss(C);j++)
  {
   PLACE_CON_REF("MUX0",NAME("sl_2_%d",j),NAME("sel%d",j),ALU1,1,WEST);
   PLACE_CON_REF(NAME("MUX%d",puiss(C-1)-1),NAME("sl_1_%d",j),NAME("sel%d",j),ALU1,1,EAST);
  }



 switch (C)
  {
    case 1:{
       	    COPY_UP_ALL_CON(EAST,"IO_0", NO);
       	    COPY_UP_ALL_CON(EAST,"IO_1", NO);
       	    COPY_UP_ALL_CON(WEST,"IO_0", NO);
       	    COPY_UP_ALL_CON(WEST,"IO_1", NO);
       	    COPY_UP_ALL_CON(SOUTH,"IO_1", NO);
            break;
           }
    case 2:
    case 3:
    case 4:{
       	    COPY_UP_ALL_CON(EAST,"IO_0", NO);
       	    COPY_UP_ALL_CON(WEST,"IO_0", NO);
       	    COPY_UP_ALL_CON(SOUTH,"IO_0", NO);
            break;
           }
    default: break;
  }
 for(i=0;i<puiss(C-1);i++)
 {
  for(j=0;j<2;j++)
  {
   COPY_UP_CON_FACE(NORTH,NAME("bit%d",j),NAME("alim1_%d",i),NAME("bit_%d",i*2+j));
   COPY_UP_CON_FACE(NORTH,NAME("n_bit%d",j),NAME("alim1_%d",i),NAME("nbit_%d",i*2+j));
  }
 }
 COPY_UP_CON_FACE(EAST,"vdd",NAME("alim1_%d",puiss(C-1)-1),"vdd");
 COPY_UP_CON_FACE(EAST,"vss",NAME("alim1_%d",puiss(C-1)-1),"vss");
 COPY_UP_CON_FACE(WEST,"vdd","alim1_0","vdd");
 COPY_UP_CON_FACE(WEST,"vss","alim1_0","vss");

 SAVE_PHFIG();

 DEF_PHFIG(NAME("rbit_col_%d_%d",L,C));

 PLACE(NAME("ibit_%d",C),"io_bit",0,0,NOSYM);
 
 switch(C)
 {
  case 1:{
          if(un==0) Y=868;
          else Y = 810;
          break;
         }
  case 2:
  case 3:
  case 4:{
          Y = 670;
          break;
         }
  default:break;
 }

 TRANS = NOSYM;
 k = 0;
 for(i=0;i< puiss(L);i++)
 {
  PLACE("dtram_c",NAME("ram_%d_0",i), TRANS,0,Y);
  for(j=1;j<puiss(C);j++)
  PLACE_RIGHT("dtram_c",NAME("ram_%d_%d",i,j),TRANS);
  PLACE_RIGHT(NAME("dttr%d_c",tr),NAME("trans_%d",i),TRANS);
  Y += 26;
  if (k==0) { k=1;
              TRANS = SYM_Y;
            }
  else { k = 0;
         TRANS = NOSYM;
       }
 }

 PLACE("dtpre_c", "prech_0", NOSYM, 0,Y);
 for(i=1;i< puiss(C-1);i++)
 PLACE_RIGHT("dtpre_c", NAME("prech_%d", i), NOSYM);

 DEF_AB(0,0,0,0);
 
 COPY_UP_ALL_CON(EAST,"io_bit",NO);
 COPY_UP_ALL_CON(WEST,"io_bit",NO);
 COPY_UP_ALL_CON(SOUTH,"io_bit",NO);
 for(i=0;i<tr;i++)
 {
  x = GET_REF_X("trans_0",NAME("ch%d",i+1));
  THRU_V(TALU1,2,x);
  COPY_UP_REF(NAME("ch%d",i+1),"trans_0",NAME("ch%d",i+1));
 }

 for(i=0;i<puiss(L);i++)
 {
  COPY_UP_CON_FACE(WEST,"wl",NAME("ram_%d_0",i),NAME("wl%d",i));
  COPY_UP_CON_FACE(WEST,"wlp",NAME("ram_%d_0",i),NAME("wl%d",i));
  COPY_UP_CON_FACE(EAST,"wl",NAME("trans_%d",i),NAME("wl%d",i));
 }
 for(i=0;i<puiss(L);i+=2)
 {
  COPY_UP_CON_FACE(WEST,"vdd",NAME("ram_%d_0",i),NAME("vdd%d",i+10));
  COPY_UP_CON_FACE(EAST,"vdd",NAME("trans_%d",i),NAME("vdd%d",i+10));
 }
  COPY_UP_CON_FACE(WEST,"pcom","prech_0","ckp");
  COPY_UP_CON_FACE(WEST,"vdd","prech_0",NAME("vdd%d",puiss(L)+10));
  COPY_UP_CON_FACE(EAST,"pcom",NAME("prech_%d",puiss(C-1)-1),"ckp");
  COPY_UP_CON_FACE(EAST,"vdd",NAME("prech_%d",puiss(C-1)-1),NAME("vdd%d",puiss(L)+10));
 for(i=0;i<puiss(C-1);i++)
 {
  COPY_UP_CON_FACE(NORTH,"vss",NAME("prech_%d",i),"vss");
  COPY_UP_CON_FACE(NORTH,"vss1",NAME("prech_%d",i),"vss");
  COPY_UP_CON_FACE(NORTH,"vss2",NAME("prech_%d",i),"vss");
  COPY_UP_CON_FACE(NORTH,"vdd",NAME("prech_%d",i),NAME("vdd%d",puiss(L)+10));
 }

 SAVE_PHFIG();
 return(0);
}

decgen()
{
 int i,j,k,l,m,num,p,x,y;

 DEF_PHFIG(NAME("predec_%d_%d",L,C));
 
 PLACE("dtinv_c","inv",NOSYM,0,0);
 PLACE_TOP("dtcmp_c","cprech",NOSYM);
 PLACE_TOP("dtcmw_c","write",NOSYM);
 PLACE_TOP("dtcms_c","csel",NOSYM);
 switch(C)
 {
  case 1:{
          if(un==1) Y = 277;
          else Y = 335;
          PLACE("dtpdc0_c","pdec",NOSYM,0,Y);
          break;
         }
  default:{
           Y = 0;
           PLACE_TOP(NAME("dtpdc%d_c",(C-1)),"pdec",NOSYM);
           break;
          }
 }
 PLACE_TOP("dtpdcl_c","pdecl",SYM_X);
 for(i=0; i<= (L-3);i++)
  PLACE_TOP(NAME("dtbadr%d_c",i), NAME("bufl%d",i), NOSYM);
 PLACE_TOP(NAME("dtext%d_c",(L-3)),"ext",NOSYM);


 if(C==1) Y += 293;
 else Y += 426;
/*
 switch(C)
 {
  case 1:{ Y = 618;
           break;
         }
  default:{ Y = 426;
            break;
          }
 }
*/

k=0;
switch(C)
{
 case 4:{
         for(i=0; i<2; i++)
         {
          PLACE("dtbmxl2_c", NAME("mlbuf_%d",i), NOSYM, 0,k+Y);
          PLACE_RIGHT("dtbmxr3_c", NAME("mrbuf_%d", i), SYM_X);
          k+=32;
         }
         for(i=2; i<4; i++)
         {
          PLACE("dtbmxl2y_c", NAME("mlbuf_%d",5-i), SYM_Y, 0,k+Y);
          PLACE_RIGHT("dtbmxr3y_c", NAME("mrbuf_%d",5-i), SYMXY);
          k+=32;
         }
         break;
        }
 case 3:{
         PLACE("dtbmxl2_c", "mlbuf_0", NOSYM, 0,Y);
         PLACE_RIGHT("dtbmxr2_c", "mrbuf_0", SYM_X);
         PLACE("dtbmxe2_c","mbuf_0", NOSYM, 0,Y+32);
         PLACE("dtbmxl2y_c", "mlbuf_1", SYM_Y, 0,Y+93);
         PLACE_RIGHT("dtbmxr2y_c", "mrbuf_1", SYMXY);
        break;
        }
 case 2:{
         PLACE("dtbmxl1_c", "mlbuf_0", NOSYM, 0,Y);
         PLACE_RIGHT("dtbmxr1_c", "mrbuf_0", SYM_X);
         PLACE("dtbmxe1_c","mbuf_0", NOSYM, 0,Y+32);
        break;
        }
 case 1:{
         PLACE("dtbmxl0_c", "mlbuf_0", NOSYM, 0,Y);
         PLACE_RIGHT("dtbmxr0_c", "mrbuf_0", SYM_X);
         PLACE("dtbmxe0_c","mbuf_0", NOSYM, 0,Y+31);
        break;
        }
 default: break;
}

 Y += 125;
 if(C==1) Y -= 4;
 PLACE("dtali2_c","ali",NOSYM,0,Y);

 DEF_AB(0,0,0,0);

 switch(C)
 {
 	case 4: {
		  for(i=0;i<4;i++)
		  {
  		   PLACE_VIA_REF(NAME("mrbuf_%d",i),NAME("v%d",i),CONT_VIA);
		   if(i>1){
 		           WIRE1(ALU1,1,NAME("mrbuf_%d",i),NAME("v%d",i),0,NAME("mrbuf_%d",i),"v1",0);
                          }
		  }
		  for(j=5;j<(L-1);j++)
		  {
		   for(i=0;i<4;i++)
                   {
 		    WIRE1(ALU2,2,NAME("mlbuf_%d",i),NAME("l%dd",j),0,NAME("mlbuf_%d",i),NAME("l%du",j),0);
 		    WIRE1(ALU2,2,NAME("mlbuf_%d",i),NAME("ln%dd",j),0,NAME("mlbuf_%d",i),NAME("ln%du",j),0);
		   }
		  }
                  break;
		}
 	case 3: {
		  for(i=0;i<2;i++)
  		   PLACE_VIA_REF(NAME("mrbuf_%d",i),NAME("v%d",i),CONT_VIA);
		  for(j=5;j<(L-1);j++)
		  {
		   for(i=0;i<2;i++)
                   {
 		    WIRE1(ALU2,2,NAME("mlbuf_%d",i),NAME("l%dd",j),0,NAME("mlbuf_%d",i),NAME("l%du",j),0);
 		    WIRE1(ALU2,2,NAME("mlbuf_%d",i),NAME("ln%dd",j),0,NAME("mlbuf_%d",i),NAME("ln%du",j),0);
		   }
 		    WIRE1(ALU2,2,"mbuf_0",NAME("l%dd",j),0,"mbuf_0",NAME("l%du",j),0);
 		    WIRE1(ALU2,2,"mbuf_0",NAME("ln%dd",j),0,"mbuf_0",NAME("ln%du",j),0);
                  }
                  break;
		}
	case 2:
 	case 1: {
		   for(j=5;j<(L-1);j++)
                   {
 		    WIRE1(ALU2,2,"mlbuf_0",NAME("l%dd",j),0,"mlbuf_0",NAME("l%du",j),0);
 		    WIRE1(ALU2,2,"mlbuf_0",NAME("ln%dd",j),0,"mlbuf_0",NAME("ln%du",j),0);
 		    WIRE1(ALU2,2,"mbuf_0",NAME("l%dd",j),0,"mbuf_0",NAME("l%du",j),0);
 		    WIRE1(ALU2,2,"mbuf_0",NAME("ln%dd",j),0,"mbuf_0",NAME("ln%du",j),0);
		   }
 		    WIRE1(ALU2,50,"csel","vdd",1,"pdec","vdd",0);
 		    WIRE1(ALU2,50,"csel","vdd2",1,"pdec","vdd2",0);
 		    WIRE1(ALU2,50,"csel","vss",1,"pdec","vss",0);
 		    WIRE1(ALU2,50,"csel","vss2",1,"pdec","vss2",0);
 		    WIRE1(ALU2,2,"csel","a0",1,"pdec","a0",0);
 		    WIRE1(ALU2,2,"csel","a1",1,"pdec","a1",0);
 		    WIRE1(ALU2,2,"csel","a2",1,"pdec","a2",0);
 		    WIRE1(ALU2,2,"csel","a3",1,"pdec","a3",0);
                    for(k=0;k<L-6;k++)
                    {
 		     WIRE1(ALU2,2,"csel",NAME("l%du",k+5),0,"pdec",NAME("l%dd",k+5),0);
                    }
 		    WIRE1(ALU2,2,"csel","c0",1,"pdec","c0",0);
 		    WIRE1(ALU2,2,"csel","c1",1,"pdec","c1",0);
 		    WIRE1(ALU2,2,"csel","nck",1,"pdec","nck",0);
 		    WIRE1(ALU2,2,"csel","ck",1,"pdec","ck",0);
 		    WIRE1(ALU2,2,"pdec","in0",0,"csel","l0u",0);
                  break;
		}
	default: break;
 }

 for(j=5;j<(L-1);j++)
 {
  for(i=0;i<(j-1);i++)
  {
   WIRE1(ALU2,2,NAME("bufl%d",i),NAME("l%dd",j),0,NAME("bufl%d",i),NAME("l%du",j),0);
  }
 }

 for(i=5;i<(L-1);i++)
 {
  WIRE1(ALU2,2,"inv",NAME("l%dd",i),0,"inv",NAME("l%du",i),0);
  WIRE1(ALU2,2,"csel",NAME("l%dd",i),0,"csel",NAME("l%du",i),0);
  WIRE1(ALU2,2,"write",NAME("l%dd",i),0,"write",NAME("l%du",i),0);
  WIRE1(ALU2,2,"cprech",NAME("l%dd",i),0,"cprech",NAME("l%du",i),0);
  WIRE1(ALU2,2,"pdec",NAME("l%dd",i),0,"pdec",NAME("l%du",i),0);
  WIRE1(ALU2,2,"pdecl",NAME("l%dd",i),0,"pdecl",NAME("l%du",i),0);
  WIRE1(ALU2,2,"ali",NAME("l%dd",i),0,"ali",NAME("l%dw",i),0);
  WIRE1(ALU2,2,"ali",NAME("l%dw",i),0,"ali",NAME("l%de",i),0);
  WIRE1(ALU2,2,"ali",NAME("l%de",i),0,"ali",NAME("l%du",i),0);
  WIRE1(ALU2,2,"ali",NAME("ln%dd",i),0,"ali",NAME("ln%dw",i),0);
  WIRE1(ALU2,2,"ali",NAME("ln%dw",i),0,"ali",NAME("ln%de",i),0);
  WIRE1(ALU2,2,"ali",NAME("ln%de",i),0,"ali",NAME("ln%du",i),0);
 }

 switch(C)
 {
  case 4:
  case 3:{
          WIRE1(ALU2,2,"ali","vd",0,"ali","vdu",0);
          WIRE1(ALU2,2,"ali","vd1d",0,"ali","vd1u",0);
          WIRE1(ALU2,2,"ali","vsd",0,"ali","vsw",0);
          WIRE1(ALU2,2,"ali","vsw",0,"ali","vse",0);
          WIRE1(ALU2,2,"ali","vse",0,"ali","vsu",0);
          WIRE1(ALU2,2,"ali","vs2d",0,"ali","vs2u",0);
          for(i=1;i<=4;i++)
          {
           PLACE_VIA_REF("ali",NAME("cv%d",i),CONT_VIA);
           PLACE_VIA_REF("ali",NAME("cv%d",i+10),CONT_VIA);
           PLACE_VIA_REF("ali",NAME("cv%d",i+20),CONT_VIA);
           PLACE_VIA_REF("ali",NAME("cv%d",i+30),CONT_VIA);
          }
          break;
         }
  default:break;
 }
          
 for(i=0;i<C;i++)
 {
  WIRE1(ALU2,2,"inv",NAME("l%dd",i),0,"csel",NAME("l%du",i),0);
 }
 for(i=0;i<(C*2);i++)
 {
  WIRE1(ALU2,2,"pdecl",NAME("mm%d",i),0,"ext",NAME("mm%d",i),0);
 }
 switch(C)
 {
  case 4:
  case 3:{
          for(i=0;i<2;i++)
          {
           x = GET_REF_X("inv",NAME("l%d",i));
           PHCON(ALU2,2,NAME("adr[%d]",i+1),SOUTH,x,0);
          }
          for(i=0;i<C-2;i++)
          {
           x = GET_REF_X("inv",NAME("l%d",i+2));
           PHCON(ALU2,2,NAME("adr[%d]",i*3),SOUTH,x,0);
          }
          break;
         }
  case 2:
  case 1:{
          for(i=0;i<C;i++)
          {
           x = GET_REF_X("inv",NAME("l%d",i));
           PHCON(ALU2,2,NAME("adr[%d]",i),SOUTH,x,0);
          }
          break;
         }
  default: break;
 }

  x = GET_REF_X("inv","cp0");
  PHCON(ALU2,2,NAME("adr[%d]",C),SOUTH,x,0);
  x = GET_REF_X("inv","cp1");
  PHCON(ALU2,2,NAME("adr[%d]",C+1),SOUTH,x,0);
 j= C+2;
 switch(L)
 {
  case 8:{
          x = GET_REF_X("inv","l6");
          PHCON(ALU2,2,NAME("adr[%d]",j),SOUTH,x,0);
          x = GET_REF_X("inv","l5");
          PHCON(ALU2,2,NAME("adr[%d]",j+1),SOUTH,x,0);
          j+=2;
          break;
         }
  case 7:{
          x = GET_REF_X("inv","l5");
          PHCON(ALU2,2,NAME("adr[%d]",j),SOUTH,x,0);
          j++;
          break;
         }
  default:break;
 }
 for(i=0;i<4;i++)
 {
  x = GET_REF_X("inv",NAME("l%d",10+i));
  PHCON(ALU2,2,NAME("adr[%d]",i+j),SOUTH,x,0);
 }

 COPY_UP_CON(0,"vdd","inv","vdd");
 COPY_UP_CON(0,"vdd2","inv","vdd");
 COPY_UP_CON(0,"vss","inv","vss");
 COPY_UP_CON(0,"vss2","inv","vss");
 COPY_UP_CON(0,"write","inv","write");
 COPY_UP_CON(0,"ck","inv","ck");
 COPY_UP_CON(0,"cpr","cprech","cpr");
 COPY_UP_CON(0,"cpl","cprech","cpl");
 COPY_UP_CON(0,"cwr","write","cwr");
 COPY_UP_CON(0,"cwl","write","cwl");
 COPY_UP_CON(0,"csr","csel","csr");
 COPY_UP_CON(0,"csl","csel","csl");

 switch(C)
 {
  case 4:
  case 3:{
          for(i=0;i<2;i++)
          {
           for(j=0;j<C-2;j++)
           {
            for(k=0;k<4;k++)
            {
             COPY_UP_CON_FACE(WEST,NAME("s%d",k),NAME("mlbuf_%d",i*(C-2)+j),NAME("sel_%d",j*8+k*2+1-i));
             COPY_UP_CON_FACE(EAST,NAME("s%d",k),NAME("mrbuf_%d",i*(C-2)+j),NAME("sel_%d",j*8+k*2+1-i));
            } 
           }
          }
          break;
         }
  case 2:{
          COPY_UP_CON_FACE(WEST,"s0","mlbuf_0","sel_0");
          COPY_UP_CON_FACE(EAST,"s0","mrbuf_0","sel_0");
          COPY_UP_CON_FACE(WEST,"s1","mlbuf_0","sel_1");
          COPY_UP_CON_FACE(EAST,"s1","mrbuf_0","sel_1");
          COPY_UP_CON_FACE(WEST,"s2","mlbuf_0","sel_2");
          COPY_UP_CON_FACE(EAST,"s3","mrbuf_0","sel_3");
          COPY_UP_CON_FACE(WEST,"sel0","mbuf_0","sel_3");
          COPY_UP_CON_FACE(EAST,"sel1","mbuf_0","sel_2");
          break;
         }
  case 1:{
          COPY_UP_CON_FACE(WEST,"s0","mlbuf_0","sel_1");
          COPY_UP_CON_FACE(EAST,"s0","mrbuf_0","sel_1");
          COPY_UP_CON_FACE(WEST,"sel0","mbuf_0","sel_0");
          COPY_UP_CON_FACE(EAST,"sel1","mbuf_0","sel_0");
          break;
         }
   default: break;
 }
 for(i=0;i<4;i++)
 {
  COPY_UP_CON_FACE(NORTH,NAME("ba%d",i),"ali",NAME("ba_%d",i));
  COPY_UP_CON_FACE(NORTH,NAME("bna%d",i),"ali",NAME("bna_%d",i));
  COPY_UP_CON_FACE(NORTH,NAME("cp%d",i),"ali",NAME("cp%d",i));
 }
 COPY_UP_CON_FACE(NORTH,"nck","ali","nck");
 COPY_UP_CON_FACE(NORTH,"ck","ali","ck");
 COPY_UP_CON_FACE(EAST,"vdd","ali","vdd");
 COPY_UP_CON_FACE(WEST,"vdd","ali","vdd");
 COPY_UP_CON_FACE(EAST,"vss","ali","vss");
 COPY_UP_CON_FACE(WEST,"vss","ali","vss");
 COPY_UP_CON_FACE(NORTH,"vdd","ali","vdd");
 COPY_UP_CON_FACE(NORTH,"vss","ali","vss");

 for(i=4;i<L-2;i++)
 {
  x = GET_REF_X("ali",NAME("l%du",i+1));
  y = GET_REF_Y("ali",NAME("l%du",i+1));
  PHCON(ALU2,2,NAME("ba_%d",i),NORTH,x,y);
  x = GET_REF_X("ali",NAME("ln%du",i+1));
  y = GET_REF_Y("ali",NAME("ln%du",i+1));
  PHCON(ALU2,2,NAME("bna_%d",i),NORTH,x,y);
 }

/*
 FLATTEN_PHFIG("inv",YES);
 FLATTEN_PHFIG("csel",YES);
 FLATTEN_PHFIG("write",YES);
 FLATTEN_PHFIG("cprech",YES);
 FLATTEN_PHFIG("pdec",YES);
 FLATTEN_PHFIG("pdecl",YES);
 for(i=0;i<(L-2);i++)
 {
  FLATTEN_PHFIG(NAME("bufl%d",i),YES);
 }
 FLATTEN_PHFIG("ext",YES);

 switch(C)
 {
    case 4:{
            for(i=0;i<4;i++)
            {
             FLATTEN_PHFIG(NAME("mlbuf_%d",i),YES);
             FLATTEN_PHFIG(NAME("mrbuf_%d",i),YES);
            }
            break;
           } 
    case 3:{
            for(i=0;i<2;i++)
            {
             FLATTEN_PHFIG(NAME("mlbuf_%d",i),YES);
             FLATTEN_PHFIG(NAME("mrbuf_%d",i),YES);
            }
            FLATTEN_PHFIG("mbuf_0",YES);
            break;
           } 
    case 2:
    case 1:{
            FLATTEN_PHFIG("mlbuf_0",YES);
            FLATTEN_PHFIG("mrbuf_0",YES);
            FLATTEN_PHFIG("mbuf_0",YES);
            break;
           } 
    default: break;
 }
 FLATTEN_PHFIG("ali",YES);
*/


 SAVE_PHFIG();

 DEF_PHFIG(NAME("decoder_%d_%d",L,C));
 if(C==1) {
           if(un==0){
                     PLACE("dtedg0_c","bord1",NOSYM,0,0);
                     PLACE("dtedg0_c","bord2",SYM_X,408,0);
                    }
           else {
                 PLACE("dtedg1_c","bord1",NOSYM,0,0);
                 PLACE("dtedg1_c","bord2",SYM_X,408,0);
                }
          }
 else {
       if(un==0){
                 PLACE("dtedg2_c","bord1",NOSYM,0,0);
                }
       else {
             PLACE("dtedg3_c","bord1",NOSYM,0,0);
            }
      
       PLACE_TOP(NAME("dtmxeg%d_c",C),"mxabg",NOSYM);
       if(un==0){
                 PLACE("dtedg2_c","bord2",SYM_X,408,0);
                }
       else {
             PLACE("dtedg3_c","bord2",SYM_X,408,0);
            }
       PLACE_TOP(NAME("dtmxed%d_c",C),"mxabd",SYM_X);
      }
  

 PLACE(NAME("predec_%d_%d",L,C),"prdecod",NOSYM,13,0);

 Y = 670;
 if (C==1) {
            if(un==0) Y += 198;
            else Y += 140;
           }

 j=decod();
 
 PLACE("dtpcg_c", "COMPG", NOSYM,13,Y);

 DEF_AB(0,0,0,0);

 num=(L-2)*10;

 m= puiss(L-2);

 for(i=0;i<m;i++)
 {
  for(j=5;j<(L-1);j++)
  {
   WIRE1(ALU1,1,NAME("adr_%d",i),NAME("l%de",j),0,NAME("adr_%d",i),NAME("l%dw",j),0);
  }
 }
  
 p=0;
 for(i=1;i<m;i=i*2)
 {
  l=0;
  j=0;
  while(j<m)
  {
   for(k=0;k<i;k++)
   {
    if(l==0)PLACE_VIA_REF(NAME("ADR_%d",j),NAME("c%dn",(num+p)),CONT_VIA);
    else PLACE_VIA_REF(NAME("ADR_%d",j),NAME("c%d",(num+p)),CONT_VIA);
    j++;
   }
   if(l==0)l=1;
   else l=0;
  }
  p++;
 }
 for(i=0;i<(L-6);i++)
 {
  WIRE1(ALU2,2,"adr_0",NAME("l%dd",i+5),0,NAME("adr_%d",puiss(L-2)-1),NAME("l%du",i+5),0);
  WIRE1(ALU2,2,"adr_0",NAME("ln%dd",i+5),0,NAME("adr_%d",puiss(L-2)-1),NAME("ln%du",i+5),0);
 }
 COPY_UP_ALL_CON(SOUTH,"prdecod", NO);
 switch(C)
 {
  case 1:{
          for(i=0;i<puiss(C);i++)
          {
           COPY_UP_CON_FACE(WEST,NAME("sel_%d",i),"prdecod",NAME("sel_%d",i));
           COPY_UP_CON_FACE(EAST,NAME("sel_%d",i),"prdecod",NAME("sel_%d",i));
          }
          break;
         }
  default:{
           for(i=0;i<puiss(C);i++)
           {
            COPY_UP_CON_FACE(WEST,NAME("sel%d",i),"mxabg",NAME("sel[%d]",i));
            COPY_UP_CON_FACE(EAST,NAME("sel%d",i),"mxabd",NAME("sel[%d]",i));
           }
           break;
          }
 }

 switch(C)
 {
  case 1:{
          if(un==0){
                    j= 5;
                    k= 4;
                   }
          else{
               j= 4;
               k= 5;
              }
          break;
         }
  case 2:
  case 3:
  case 4:{
          j= 3;
          k= 2;
          break;
         }
  default: break;
 }
 COPY_UP_CON_FACE(WEST,"vdd","prdecod","vdd");
 COPY_UP_CON_FACE(EAST,"vdd","prdecod","vdd");
 COPY_UP_CON_FACE(WEST,"vss","prdecod","vss");
 COPY_UP_CON_FACE(EAST,"vss","prdecod","vss");
 
 COPY_UP_CON_FACE(WEST,"cw","bord1","cwl");
 COPY_UP_CON_FACE(WEST,"cp","bord1","cpl");
 COPY_UP_CON_FACE(WEST,"cs","bord1","csl");
 COPY_UP_CON_FACE(EAST,"cw","bord2","cwr");
 COPY_UP_CON_FACE(EAST,"cp","bord2","cpr");
 COPY_UP_CON_FACE(EAST,"cs","bord2","csr");

 for(i=1;i<=j;i++)
 {
  COPY_UP_CON_FACE(WEST,NAME("vdd%d",i),"bord1","vdd");
  COPY_UP_CON_FACE(EAST,NAME("vdd%d",i),"bord2","vdd");
 }

 for(i=1;i<=k;i++)
 {
  COPY_UP_CON_FACE(WEST,NAME("vss%d",i),"bord1","vss");
  COPY_UP_CON_FACE(EAST,NAME("vss%d",i),"bord2","vss");
 }

 for(i=0;i<puiss(L-2);i++)
 {
  for(j=0;j<4;j++)
  {
   for(k=0;k<2;k++)
   {
    COPY_UP_CON(k,NAME("wld[%d]",j),NAME("decd_%d",i),NAME("wld[%d]",j+i*4));
    COPY_UP_CON(k,NAME("wlg[%d]",j),NAME("decg_%d",i),NAME("wlg[%d]",j+i*4));
   }
  }
  COPY_UP_CON_FACE(WEST,"vdd",NAME("decg_%d",i),"vdd");
  COPY_UP_CON_FACE(EAST,"vdd",NAME("decd_%d",i),"vdd");
 }
 COPY_UP_CON(0,"ckp","compg","ckp");
 COPY_UP_CON(0,"ckp2","compg","ckp2");
 COPY_UP_CON_FACE(NORTH,"vdd1","compg","vdd");
 COPY_UP_CON_FACE(WEST,"vdd1","compg","vdd");
 COPY_UP_CON_FACE(NORTH,"vdd2","compg","vdd");
 COPY_UP_CON_FACE(EAST,"vdd2","compg","vdd");
 COPY_UP_CON_FACE(NORTH,"vdd3","compg","vdd");
 COPY_UP_CON_FACE(NORTH,"vss1","compg","vss");
 COPY_UP_CON_FACE(NORTH,"vss2","compg","vss");
	
 SAVE_PHFIG();

 return(0);
}

copcon()
{
 int i,j,k;
 long x;

 for(i=0;i<2;i++)
 {
  for(j=0;j<bpm2;j++)
  {
   if(un==1){
             COPY_UP_CON(0,"inn",NAME("rbit_%d_%d",j,i),NAME("din[%d]",j+i*bpm2));
            }
   COPY_UP_CON(0,"dout",NAME("rbit_%d_%d",j,i),NAME("dout[%d]",j+i*bpm2));
   for(k=0;k<tr;k++)
   {
    x = GET_REF_X(NAME("rbit_%d_%d",j,i),NAME("ch%d",k+1));
    THRU_V(TALU1,2,x);
    COPY_UP_REF(NAME("ch%d",k+1),NAME("rbit_%d_%d",j,i),NAME("ch%d",k+1));
   }
   for(k=0;k<puiss(C-1);k++)
   {
    COPY_UP_CON_FACE(NORTH,NAME("vdd%d",puiss(L)+10),NAME("rbit_%d_%d",j,i),"vdd");
   }
   COPY_UP_CON_FACE(NORTH,"vss",NAME("rbit_%d_%d",j,i),"vss");
  }
 }
 COPY_UP_ALL_CON(SOUTH,"decod", NO);
 COPY_UP_ALL_CON(NORTH,"decod", NO);

 COPY_UP_CON_FACE(WEST,"vdd","rbit_0_0","vdd");
 COPY_UP_CON_FACE(WEST,"vss","rbit_0_0","vss");
 COPY_UP_CON_FACE(EAST,"vdd",NAME("rbit_%d_1",bpm2-1),"vdd");
 COPY_UP_CON_FACE(EAST,"vss",NAME("rbit_%d_1",bpm2-1),"vss");
 switch(C)
 {
  case 1:{
          if(un==0){
                    j= 5;
                    k= 5;
                   }
          else{
               j= 4;
               k= 5;
              }
          break;
         }
  case 2:
  case 3:
  case 4:{
          j= 3;
          k= 2;
          break;
         }
  default: break;
 }
 for(i=1;i<=j;i++)
 {
  COPY_UP_CON_FACE(WEST,NAME("vdd%d",i),"rbit_0_0","vdd");
  COPY_UP_CON_FACE(EAST,NAME("vdd%d",i),NAME("rbit_%d_1",bpm2-1),"vdd");
 }
 for(i=1;i<=k;i++)
 {
  COPY_UP_CON_FACE(WEST,NAME("vss%d",i),"rbit_0_0","vss");
  COPY_UP_CON_FACE(EAST,NAME("vss%d",i),NAME("rbit_%d_1",bpm2-1),"vss");
 }

 for(i=10;i<puiss(L)+10;i+=2)
 {
  COPY_UP_CON_FACE(WEST,NAME("vdd%d",i),"rbit_0_0","vdd");
  COPY_UP_CON_FACE(EAST,NAME("vdd%d",i),NAME("rbit_%d_1",bpm2-1),"vdd");
 }

}

outline()
{
 OUTLINE();
}

rage_icon(name)
char *name;
{
 long x,y,a,b;
 int i,j;

 ADDICONGATE(name, 50, 35, 50, 30, 50, 25);

 ADDICONCON(NAME("adr[%d:0]",L+C -1), 30, 80, SAX_NORTH, IN);
 ADDICONCON("ck", 50, 80, SAX_NORTH, IN);
 ADDICONCON("write", 70, 80, SAX_NORTH, IN);
 if(un==1)
 {
 ADDICONCON(NAME("din[%d:0]",bpm -1), 100, 40, SAX_EAST, IN);
 ADDICONCON(NAME("dout[%d:0]",bpm -1), 0, 40, SAX_WEST, OUT);
 }
 else ADDICONCON(NAME("dout[%d:0]",bpm -1), 0, 40, SAX_WEST, INOUT);

 ADDICONCON("vdd", 30, 0, SAX_SOUTH, IN);
 ADDICONCON("vss", 70, 0, SAX_SOUTH, IN);
 x = 37;
 y = 40;
     for(i=1;i<6;i++)
     {
      a=x;
      b=y+i*2-1;
      for(j=1;j<5;j++)
      {
        ADDICONLINE(a,b,a+2,b);
        a+=2;
        ADDICONLINE(a,b,a+1,b-1);
        ADDICONLINE(a,b,a+1,b+1);
        a+=1;
        b-=1;
        ADDICONLINE(a,b,a+2,b);
        a+=2;
        ADDICONLINE(a,b+2,a+1,b+1);
        ADDICONLINE(a,b,a+1,b+1);
        a+=1;
        b+=1;
      }
      ADDICONLINE(a,b,a+2,b);
     }
      a=x+2;
      b=y+9;
      for(j=1;j<5;j++)
      {
        ADDICONLINE(a,b,a+1,b+1);
        a+=1;
        b+=1;
        ADDICONLINE(a,b,a+2,b);
        a+=2;
        ADDICONLINE(a,b,a+1,b-1);
        a+=3;
        b-=1;
      }
        
        ADDICONLINE(30, 0, 30, 20);
        ADDICONLINE(70, 0, 70, 20);
        ADDICONLINE(0, 40, 20, 40);
        ADDICONLINE(30, 60, 30, 80);
        ADDICONLINE(50, 60, 50, 80);
        ADDICONLINE(70, 60, 70, 80);
 if(un==1) ADDICONLINE(80,40,100,40);
        ADDICONCOMP(COMP_ISLINE, 20, 20);
        ADDICONCOMP(COMP_ISLINE, 80 , 20);
        ADDICONCOMP(COMP_ISLINE, 80 , 60);
        ADDICONCOMP(COMP_ISLINE, 20, 60);
        ADDICONSHAPE();
 SAVEICON();
 
}

vhdl(name)
char *name;
{
 int i;
 
 i = decvb(L,C);
 i = gener(L,C,un);
 i = gvst2(L,C,bpm2,un,name);
}

int decvb(l,c)
int l,c;
{
 FILE *fich;
 int i,j,k;
 char name[12];

 name[0] = 'd';
 name[1] = 'e';
 name[2] = 'c';
 name[3] = '_';
 name[4] = valeur(l);
 name[5] = '_';
 name[6] = valeur(c);
 name[7] = '.';
 name[8] = 'v';
 name[9] = 'b';
 name[10] = 'e';
 name[11] = '\0';
 
 fich = fopen(name, "w");
 fprintf(fich,"ENTITY  dec_%d_%d IS\n",l,c);

 fprintf(fich,"PORT (\n"); 
 fprintf(fich,"   adr	:	IN BIT_VECTOR(%d DOWNTO 0);\n",l+c-1);
 fprintf(fich,"   wld	:	OUT BIT_VECTOR(%d DOWNTO 0);\n",puiss(l)-1);
 fprintf(fich,"   wlg	:	OUT BIT_VECTOR(%d DOWNTO 0);\n",puiss(l)-1);
 fprintf(fich,"   sel	:   	OUT BIT_VECTOR(%d DOWNTO 0);\n",puiss(c)-1);
 fprintf(fich,"   write :	IN BIT ;\n");
 fprintf(fich,"   cpl	:	OUT BIT ;\n");
 fprintf(fich,"   cpr	:	OUT BIT ;\n");
 fprintf(fich,"   cwl	:	OUT BIT ;\n");
 fprintf(fich,"   cwr	:	OUT BIT ;\n");
 fprintf(fich,"   csl	:	OUT BIT ;\n");
 fprintf(fich,"   csr	:	OUT BIT ;\n");
 fprintf(fich,"   ckp	:	OUT BIT ;\n");
 fprintf(fich,"   ckp2	:	OUT BIT ;\n");
 fprintf(fich,"   ck	:   	IN BIT ;\n");
 fprintf(fich,"   vdd	:   	IN BIT ;\n");
 fprintf(fich,"   vss	:   	IN BIT) ;\n");
 fprintf(fich,"END dec_%d_%d ;\n",l,c);
 fprintf(fich,"\n\n\n"); 
 fprintf(fich,"ARCHITECTURE decarch OF dec_%d_%d IS \n",l,c);
 for(i=0;i<l-3;i++)
 {
  fprintf(fich," signal wl%d : BIT_VECTOR(%d DOWNTO 0);\n",i,puiss(4+i)-1);
 }
 for(i=0;i<c;i++)
 {
  fprintf(fich," signal sl%d : BIT_VECTOR(%d DOWNTO 0);\n",i,puiss(i+1)-1);
 }
  fprintf(fich," signal vck : BIT_VECTOR(%d DOWNTO 0);\n",puiss(l)-1);

 fprintf(fich,"\n\n\n");
 fprintf(fich,"begin\n");
 fprintf(fich,"--  word-line calculations --\n\n\n");

 fprintf(fich,"  with adr(%d DOWNTO %d) select\n",c+3,c);
 fprintf(fich,"  wl0 <= B\"0000000000000001\" when B\"0000\",\n");
 for(i=1;i<16;i++)
 {
  fprintf(fich,"         B\"");
  for(j=0;j<15-i;j++)
  {
   fprintf(fich,"0");
  }
   fprintf(fich,"1");
  for(j=16-i;j<16;j++)
  {
   fprintf(fich,"0");
  }
  fprintf(fich,"\" when B\"");
  j=i;
  for(k=3;k>=0;k--)
  {
   if(j>=puiss(k)) {
                    fprintf(fich,"1");
                    j = j - puiss(k);
                   }
   else fprintf(fich,"0");
  }
  if(i==15) fprintf(fich,"\";\n");
  else fprintf(fich,"\" ,\n");
 }
 fprintf(fich,"\n\n\n");

 for(i=4;i<l;i++)
 {
  fprintf(fich,"  with adr(%d) select\n",c+i);
  fprintf(fich,"  wl%d <= wl%d(%d DOWNTO 0) & X\"",i-3,i-4,puiss(i)-1);
  for(j=0;j<puiss(i-2);j++)
  {
   fprintf(fich,"0");
  }
  fprintf(fich,"\" when '1',\n");
  fprintf(fich,"         X\"");
  for(j=0;j<puiss(i-2);j++)
  {
   fprintf(fich,"0");
  }
  fprintf(fich,"\" & wl%d(%d DOWNTO 0) when '0';\n",i-4,puiss(i)-1);
  fprintf(fich,"\n");
 } 
 fprintf(fich,"\n");
 fprintf(fich,"  with ck select\n");
 fprintf(fich,"  vck <= X\"");
 for(j=0;j<puiss(l-2);j++)
 {
  fprintf(fich,"0");
 }
 fprintf(fich,"\" when '1',\n");
 fprintf(fich,"         X\"");
 for(j=0;j<puiss(l-2);j++)
 {
  fprintf(fich,"f");
 }
 fprintf(fich,"\" when '0';\n");
 fprintf(fich,"\n");

 fprintf(fich,"\n");
 fprintf(fich,"  wld <= wl%d and vck; \n",l-4);
 fprintf(fich,"  wlg <= wl%d and vck; \n",l-4);
 fprintf(fich,"\n\n\n");
 fprintf(fich,"--  sel-lines calculation --\n\n\n");

 fprintf(fich,"  with adr(0) select\n");
 fprintf(fich,"  sl0 <= B\"01\" when '0',\n");
 fprintf(fich,"         B\"10\" when '1';\n");
 fprintf(fich,"\n");

 for(i=1;i<c;i++)
 {
  fprintf(fich,"  with adr(%d) select\n",i);
  fprintf(fich,"  sl%d <= sl%d(%d DOWNTO 0) & B\"",i,i-1,puiss(i)-1);
  for(j=0;j<puiss(i);j++)
  {
   fprintf(fich,"0");
  }
  fprintf(fich,"\" when '1',\n");
  fprintf(fich,"         B\"");
  for(j=0;j<puiss(i);j++)
  {
   fprintf(fich,"0");
  }
  fprintf(fich,"\" & sl%d(%d DOWNTO 0) when '0';\n",i-1,puiss(i)-1);
  fprintf(fich,"\n");
 } 

 fprintf(fich,"   sel <= sl%d;\n\n",c-1);

 fprintf(fich,"   cpl  <= not(not(ck)) ;\n");
 fprintf(fich,"   cpr  <= not(not(ck)) ;\n");
 fprintf(fich,"   cwl <= not(ck) and write ;\n");
 fprintf(fich,"   cwr <= not(ck) and write ;\n");
 fprintf(fich,"   csl  <= not(ck) and not(write) ;\n");
 fprintf(fich,"   csr  <= not(ck) and not(write) ;\n");
 fprintf(fich,"   ckp  <= not(not(ck)) ;\n");
 fprintf(fich,"   ckp2 <= not(not(ck)) ;\n\n\n");

 fprintf(fich," END decarch ;\n");
 fclose(fich);
}

char valeur(i)
int i;
{
 switch(i)
 {
  case 1:{ return('1'); break;}
  case 2:{ return('2'); break;}
  case 3:{ return('3'); break;}
  case 4:{ return('4'); break;}
  case 5:{ return('5'); break;}
  case 6:{ return('6'); break;}
  case 7:{ return('7'); break;}
  case 8:{ return('8'); break;}
  case 9:{ return('9'); break;}
  case 0:{ return('0'); break;}
  default: break;
 }
}

int gener(l,c,u)
int l,c,u;
{
 FILE *fich;
 int i,j,k;
 char name[13];

 name[0] = 'r';
 name[1] = 'b';
 name[2] = 'i';
 name[3] = 't';
 name[4] = '_';
 name[5] = valeur(l);
 name[6] = '_';
 name[7] = valeur(c);
 name[8] = '.';
 name[9] = 'v';
 name[10] = 'b';
 name[11] = 'e';
 name[12] = '\0';

 fich = fopen(name, "w");
 fprintf(fich,"ENTITY  rbit_%d_%d IS\n",l,c);

 fprintf(fich,"PORT (\n"); 
 fprintf(fich,"   wl	:	IN BIT_VECTOR(0 TO %d);\n",puiss(l)-1);
 fprintf(fich,"   sel	:   	IN BIT_VECTOR(0 TO %d);\n",puiss(c)-1);
 fprintf(fich,"   read	:   	IN BIT ;\n");
 fprintf(fich,"   write :	IN BIT ;\n");
 fprintf(fich,"   ckp   :	IN BIT ;\n");
 if(u==1){
 fprintf(fich,"   ent	:   	IN BIT;\n");
 fprintf(fich,"   sor	:   	OUT BIT;\n");
         }
 else {
 fprintf(fich,"   sor	:   	INOUT MUX_BIT BUS ;\n");
      }
 fprintf(fich,"   vdd	:	IN BIT ;\n");
 fprintf(fich,"   vss	:	IN BIT) ;\n");
 fprintf(fich,"END rbit_%d_%d ;\n",l,c);
 fprintf(fich,"\n\n\n"); 
 fprintf(fich,"ARCHITECTURE rbitarch OF rbit_%d_%d IS \n",l,c);
 for(i=0;i<l;i++)
 {
  fprintf(fich," signal wl%d : BIT_VECTOR(0 TO %d);\n",i,puiss(l-i)-1);
 }
 fprintf(fich," signal wla : BIT_VECTOR(0 TO %d);\n",l-1);
 for(i=0;i<c;i++)
 {
  fprintf(fich," signal sl%d : BIT_VECTOR(0 TO %d);\n",i,puiss(c-i)-1);
 }
 if(c==1) fprintf(fich," signal csa : BIT;\n");
 else fprintf(fich," signal csa : BIT_VECTOR(0 TO %d);\n",c-1);
 for(i=0;i<16;i++)
 {
  fprintf(fich," signal mem%d : REG_VECTOR(0 TO %d) REGISTER ;\n",i,puiss(l+c-4)-1);
 }
 fprintf(fich,"  signal msig0 : BIT_VECTOR(0 TO %d);\n",puiss(l+c-4)-1);
 fprintf(fich,"  signal msig1 : BIT_VECTOR(0 TO %d);\n",puiss(c)-1);
 fprintf(fich,"  signal msig2 : BIT_VECTOR(0 TO %d);\n",puiss(c)-1);
 fprintf(fich,"  signal msig3 : BIT_VECTOR(0 TO %d);\n",puiss(l+c-4)-1);
 if(u==0){
          fprintf(fich,"  signal kar   : BIT; \n");
         }

 fprintf(fich,"begin\n");
 fprintf(fich,"--  Recoding --\n\n\n");

 fprintf(fich,"  wl0 <= wl ;\n");
 for(i=0;i<l;i++)
 {
  fprintf(fich,"  with wl%d(0 TO %d) select\n",i,puiss(l-1-i)-1);
  fprintf(fich,"  wla(%d) <= '0' when ",i);
  if(i>l-3) {
             fprintf(fich,"B\"");
             for(j=0;j<puiss(l-1-i);j++)
              fprintf(fich,"0");
            }
  else {
        fprintf(fich,"X\"");
        for(j=0;j<puiss(l-i-3);j++)
         fprintf(fich,"0");
       }
  fprintf(fich,"\" ,\n");
  fprintf(fich,"            '1' when others ;\n");
  if(i<l-1)
  {
   fprintf(fich,"  with wla(%d) select\n",i);
   fprintf(fich,"  wl%d <= wl%d(0 TO %d) when '1',\n",i+1,i,puiss(l-1-i)-1);
   fprintf(fich,"          wl%d(%d TO %d) when '0';\n",i,puiss(l-1-i),puiss(l-i)-1);
  }
 }

 fprintf(fich,"  sl0 <= sel ;\n");
 for(i=0;i<c;i++)
 {
  fprintf(fich,"  with sl%d(0 TO %d) select\n",i,puiss(c-1-i)-1);
  if(c==1) fprintf(fich,"  csa     <= '1' when B\"");
  else fprintf(fich,"  csa(%d) <= '1' when B\"",i);
  for(j=0;j<puiss(c-i-1);j++)
   fprintf(fich,"0");
  fprintf(fich,"\" ,\n");
  fprintf(fich,"            '0' when others ;\n");
  if(i<c-1)
  {
   fprintf(fich,"  with csa(%d) select\n",i);
   fprintf(fich,"  sl%d <= sl%d(0 TO %d) when '0',\n",i+1,i,puiss(c-1-i)-1);
   fprintf(fich,"          sl%d(%d TO %d) when '1';\n",i,puiss(c-1-i),puiss(c-i)-1);
  }
 }
 fprintf(fich,"\n\n\n-- Read Operation --\n\n");
 fprintf(fich,"  with wla(0 TO 3) select\n");
 fprintf(fich,"  msig0 <= mem0 when B\"0000\",\n");
 for(i=1;i<16;i++)
 {
  fprintf(fich,"           mem%d when B\"",i);
  j=i;
  for(k=3;k>=0;k--)
  {
   if(j>=puiss(k)) {
                    fprintf(fich,"1");
                    j = j - puiss(k);
                   }
   else fprintf(fich,"0");
  }
  if(i==15) fprintf(fich,"\";\n");
  else fprintf(fich,"\",\n");
 }
 fprintf(fich,"\n\n");
 fprintf(fich,"  with wla(4 TO %d) select\n",l-1);
 fprintf(fich,"  msig1 <= msig0(0 TO %d) when B\"",puiss(c)-1);
 for(i=0;i<l-4;i++)
  fprintf(fich,"1");
 fprintf(fich,"\",\n");
 for(i=1;i<puiss(l-4);i++)
 {
  fprintf(fich,"           msig0(%d TO %d) when B\"",puiss(c)*i,puiss(c)*(i+1)-1);
  j=i;
  for(k=l-5;k>=0;k--)
  {
   if(j>=puiss(k)) {
                    fprintf(fich,"0");
                    j = j - puiss(k);
                   }
   else fprintf(fich,"1");
  }
  if(i==puiss(l-4)-1) fprintf(fich,"\";\n");
  else fprintf(fich,"\",\n");
 }
 fprintf(fich,"\n\n");
 if(c==1) fprintf(fich,"  with write & read & csa select\n");
 else fprintf(fich,"  with ckp & write & read & csa(0 TO %d) select\n",c-1);
 if(u==1){
          fprintf(fich,"  sor <= msig1( 3 ) when B\"001");
         }
 else{
      fprintf(fich,"  kar <= msig1( 3 ) when B\"001");
     }
 for(i=0;i<c;i++)
  fprintf(fich,"0");
 fprintf(fich,"\",\n");
 for(i=1;i<puiss(c);i++)
 {
  fprintf(fich,"         msig1( %d ) when B\"001",puiss(c)-1-i);
  j=i;
  for(k=c-1;k>=0;k--)
  {
   if(j>=puiss(k)) {
                    fprintf(fich,"1");
                    j = j - puiss(k);
                   }
   else fprintf(fich,"0");
  }
  fprintf(fich,"\",\n");
 }
 fprintf(fich,"         '0'  when others ;\n");
 fprintf(fich,"\n\n");
 if(u==0){
          fprintf(fich,"  rop:block ( write & read = B\"01\")\n");
          fprintf(fich,"      begin\n");
          fprintf(fich,"            sor <= guarded kar;\n");
          fprintf(fich,"      end block ;\n");
         }
 fprintf(fich,"\n\n");
 fprintf(fich,"-- Write Operation --\n");
 if(u==0){
          name[0]='s';
          name[1]='o';
          name[2]='r';
          name[3]='\0';
         }
 else {
          name[0]='e';
          name[1]='n';
          name[2]='t';
          name[3]='\0';
      }

 switch(c)
 {
   case 1:
          {
           fprintf(fich,"  with write & read & csa select\n");
           fprintf(fich,"  msig2 <= msig1(0) & %s when B\"100\" ,\n",name);
           fprintf(fich,"           %s & msig1(1) when B\"101\" ,\n",name);
           fprintf(fich,"           msig1(0 TO 1)  when others ;\n");
           break;
          }
   case 2:
   case 3:
   case 4:
          {
           fprintf(fich,"  with write & read & csa(0 TO %d) select\n",c-1);
           fprintf(fich,"  msig2 <= msig1(0 TO %d) & %s when B\"10",puiss(c)-2,name);
           for(i=0;i<c;i++)
            fprintf(fich,"0");
           fprintf(fich,"\",\n");
           fprintf(fich,"           msig1(0 TO %d) & %s & msig1(%d) when B\"10",puiss(c)-3,name,puiss(c)-1);
           for(i=0;i<c-1;i++)
            fprintf(fich,"0");
           fprintf(fich,"1\",\n");
           for(i=2;i<puiss(c)-2;i++)
           {
            fprintf(fich,"           msig1(0 TO %d) & %s & msig1(%d TO %d) when B\"10",puiss(c)-i-2,name,puiss(c)-i,puiss(c)-1);
            j=i;
            for(k=c-1;k>=0;k--)
            {
             if(j>=puiss(k)) {
                              fprintf(fich,"1");
                              j = j - puiss(k);
                             }
             else fprintf(fich,"0");
            }
            fprintf(fich,"\" , \n");
           }
            fprintf(fich,"           msig1( 0 ) & %s & msig1(2 TO %d) when B\"10",name,puiss(c)-1);
           for(i=0;i<c-1;i++)
            fprintf(fich,"1");
           fprintf(fich,"0\",\n");
            fprintf(fich,"           %s & msig1(1 TO %d) when B\"10",name,puiss(c)-1);
           for(i=0;i<c;i++)
            fprintf(fich,"1");
           fprintf(fich,"\" ,\n");
           fprintf(fich,"           msig1(0 TO %d)  when others ;\n",puiss(c)-1);
           break;
          }
    default: break;
 }

 fprintf(fich,"\n\n");
 fprintf(fich,"  with wla(4 TO %d) select\n",l-1);
 fprintf(fich,"  msig3 <= msig0(0 TO %d) & msig2(0 TO %d) when B\"",(puiss(l-4)-1)*(puiss(c))-1,puiss(c)-1);
 for(i=0;i<l-4;i++)
  fprintf(fich,"0");
 fprintf(fich,"\",\n");
 for(i=1;i<puiss(l-4)-1;i++)
 {
  fprintf(fich,"           msig0(0 TO %d) & msig2(0 TO %d) & msig0(%d TO %d) when B\"",(puiss(l-4)-(i+1))*puiss(c)-1,puiss(c)-1,(puiss(l-4)-i)*puiss(c),puiss(l+c-4)-1);
  j=i;
  for(k=l-5;k>=0;k--)
  {
   if(j>=puiss(k)) {
                    fprintf(fich,"1");
                    j = j - puiss(k);
                   }
   else fprintf(fich,"0");
  }
  fprintf(fich,"\" , \n");
 }
  fprintf(fich,"           msig2(0 TO %d) & msig0(%d TO %d) when B\"",puiss(c)-1,puiss(c),puiss(l+c-4)-1);
 for(i=0;i<l-4;i++)
  fprintf(fich,"1");
 fprintf(fich,"\";\n");

 fprintf(fich,"\n\n");

 fprintf(fich,"-- Register Write --");
 fprintf(fich,"\n\n");
  for(i=0;i<16;i++)
  {
   fprintf(fich," wb%d : block (((write and not(read)) = '1') and (wla(0 TO 3) = B\"",i);
   j=i;
   for(k=3;k>=0;k--)
   {
    if(j>=puiss(k)) {
                     fprintf(fich,"1");
                     j = j - puiss(k);
                    }
    else fprintf(fich,"0");
   }
   fprintf(fich,"\" ))\n");
   fprintf(fich,"        begin\n");
   fprintf(fich,"             mem%d <= guarded msig3;\n",i);
   fprintf(fich,"        end block;\n");
   fprintf(fich,"\n\n");
  }
   fprintf(fich,"\n\n");
   fprintf(fich,"\n\n");

 fprintf(fich,"-- End of description --\n");
 fprintf(fich,"end rbitarch ; \n");
 fclose(fich);
}


int gvst2(l,c,n,u,xname)
int l,c,n,u;
char *xname;
{
 FILE *fich;
 int i,j,k;
 char name[12], *p;

 if(*xname != '\0')
 {
   i=0;
   p = xname;
   while(*p != '\0')
   {
    name[i] = *p;
    i++;
    p++;
   }
   name[i++] = '.';
   name[i++] = 'v';
   name[i++] = 's';
   name[i++] = 't';
   name[i] = '\0';
 }
  else
  {
   name[0] = 'm';
   name[1] = 'e';
   name[2] = 'm';
   name[3] = '_';
   name[4] = valeur(l);
   name[5] = '_';
   name[6] = valeur(c);
   name[7] = '.';
   name[8] = 'v';
   name[9] = 's';
   name[10] = 't';
   name[11] = '\0';
  }
 
 fich = fopen(name, "w");
 fprintf(fich,"ENTITY  mem_%d_%d IS\n",l,c);

 fprintf(fich,"PORT (\n"); 
 fprintf(fich,"   adr	:	IN BIT_VECTOR(%d DOWNTO 0);\n",l+c-1);
 fprintf(fich,"   write :	IN BIT ;\n");
 fprintf(fich,"   ck	:   	IN BIT ;\n");
 if(u==1){
 fprintf(fich,"   din	:	IN BIT_VECTOR(%d DOWNTO 0);\n",n-1);
 fprintf(fich,"   dout	:	OUT BIT_VECTOR(%d DOWNTO 0);\n",n-1);
         }
 else {
 fprintf(fich,"   dout	:	INOUT MUX_VECTOR(%d DOWNTO 0) BUS;\n",n-1);
      }

 fprintf(fich,"   vdd	:   	linkage BIT ;\n");
 fprintf(fich,"   vss	:   	linkage BIT) ;\n");
 fprintf(fich,"END mem_%d_%d ;\n",l,c);
 fprintf(fich,"\n\n\n"); 
 fprintf(fich,"ARCHITECTURE structural_view OF mem_%d_%d IS \n",l,c);

 fprintf(fich," \n"); 
 fprintf(fich,"COMPONENT dec_%d_%d\n",l,c);
 fprintf(fich,"PORT (\n"); 
 fprintf(fich,"   adr	:	IN BIT_VECTOR(%d DOWNTO 0);\n",l+c-1);
 fprintf(fich,"   wld	:	OUT BIT_VECTOR(%d DOWNTO 0);\n",puiss(l)-1);
 fprintf(fich,"   wlg	:	OUT BIT_VECTOR(%d DOWNTO 0);\n",puiss(l)-1);
 fprintf(fich,"   sel	:   	OUT BIT_VECTOR(%d DOWNTO 0);\n",puiss(c)-1);
 fprintf(fich,"   write :	IN BIT ;\n");
 fprintf(fich,"   cpl	:	OUT BIT ;\n");
 fprintf(fich,"   cpr	:	OUT BIT ;\n");
 fprintf(fich,"   cwl	:	OUT BIT ;\n");
 fprintf(fich,"   cwr	:	OUT BIT ;\n");
 fprintf(fich,"   csl	:	OUT BIT ;\n");
 fprintf(fich,"   csr	:	OUT BIT ;\n");
 fprintf(fich,"   ck	:   	IN BIT ;\n");
 fprintf(fich,"   vdd	:   	IN BIT ;\n");
 fprintf(fich,"   vss	:   	IN BIT) ;\n");
 fprintf(fich,"END COMPONENT;\n");
 fprintf(fich," \n"); 

 fprintf(fich,"COMPONENT rbit_%d_%d\n",l,c);
 fprintf(fich,"PORT (\n");
 fprintf(fich,"   wl    :       IN BIT_VECTOR(0 TO %d);\n",puiss(l)-1);
 fprintf(fich,"   sel   :       IN BIT_VECTOR(0 TO %d);\n",puiss(c)-1);
 fprintf(fich,"   read  :       IN BIT ;\n");
 fprintf(fich,"   write :       IN BIT ;\n");
 fprintf(fich,"   ckp   :       IN BIT ;\n");
 if(u==1){
 fprintf(fich,"   ent   :       IN BIT;\n");
 fprintf(fich,"   sor   :       OUT BIT;\n");
         }
 else {
 fprintf(fich,"   sor   :       INOUT MUX_BIT BUS ;\n");
      }
 fprintf(fich,"   vdd   :       IN BIT ;\n");
 fprintf(fich,"   vss   :       IN BIT) ;\n");
 fprintf(fich,"END COMPONENT;\n");

 fprintf(fich," \n"); 
 fprintf(fich," SIGNAL lecd	: BIT;\n"); 
 fprintf(fich," SIGNAL lecg	: BIT;\n"); 
 fprintf(fich," SIGNAL ecrd	: BIT;\n"); 
 fprintf(fich," SIGNAL ecrg	: BIT;\n"); 
 fprintf(fich," SIGNAL prd	: BIT;\n"); 
 fprintf(fich," SIGNAL prg	: BIT;\n"); 
 fprintf(fich," SIGNAL selm	: BIT_VECTOR(0 TO %d);\n",puiss(c)-1); 
 fprintf(fich," SIGNAL wlnd	: BIT_VECTOR(0 TO %d);\n",puiss(l)-1); 
 fprintf(fich," SIGNAL wlng	: BIT_VECTOR(0 TO %d);\n",puiss(l)-1); 
 fprintf(fich," \n\n\n"); 
 fprintf(fich,"BEGIN\n"); 

 fprintf(fich,"   decod : dec_%d_%d\n",l,c);
 fprintf(fich,"     PORT MAP (\n");
 fprintf(fich,"       adr   => adr,\n");
 fprintf(fich,"       wld    => wlnd,\n");
 fprintf(fich,"       wlg    => wlng,\n");
 fprintf(fich,"       sel   => selm,\n");
 fprintf(fich,"       write => write,\n");
 fprintf(fich,"       cpl   => prg,\n");
 fprintf(fich,"       cpr   => prd,\n");
 fprintf(fich,"       cwl   => ecrg,\n");
 fprintf(fich,"       cwr   => ecrd,\n");
 fprintf(fich,"       csl   => lecg,\n");
 fprintf(fich,"       csr   => lecd,\n");
 fprintf(fich,"       ck    => ck,\n");
 fprintf(fich,"       vdd   => vdd,\n");
 fprintf(fich,"       vss   => vss);\n");
 fprintf(fich," \n"); 

 for(i=0;i<n;i++)
 {
  fprintf(fich,"   bit_%d : rbit_%d_%d\n",i,l,c);
  fprintf(fich,"     PORT MAP (\n");
  fprintf(fich,"   wl    => wlng, \n");
  fprintf(fich,"   sel   => selm, \n");
  fprintf(fich,"   read  => lecg, \n");
  fprintf(fich,"   write => ecrg, \n");
  fprintf(fich,"   ckp   => prg, \n");
  if(u==1){
           fprintf(fich,"   ent   => din(%d), \n",i);
          }
  fprintf(fich,"   sor   => dout(%d), \n",i);
  fprintf(fich,"   vdd   => vdd, \n");
  fprintf(fich,"   vss   => vss ); \n");
  fprintf(fich," \n"); 
 }
 for(i=0;i<n;i++)
 {
  fprintf(fich,"   bit_%d : rbit_%d_%d\n",i+n,l,c);
  fprintf(fich,"     PORT MAP (\n");
  fprintf(fich,"   wl    => wlnd, \n");
  fprintf(fich,"   sel   => selm, \n");
  fprintf(fich,"   read  => lecd, \n");
  fprintf(fich,"   write => ecrd, \n");
  fprintf(fich,"   ckp   => prd, \n");
  if(u==1){
           fprintf(fich,"   ent   => din(%d), \n",i);
          }
  fprintf(fich,"   sor   => dout(%d), \n",i);
  fprintf(fich,"   vdd   => vdd, \n");
  fprintf(fich,"   vss   => vss ); \n");
  fprintf(fich," \n"); 
 }
 fprintf(fich," END structural_view;\n");
 fclose(fich);
}

int present()
{
 alliancebanner("RaGe", "1.1", "Ram Generator","93", "2.0");
 /*
 printf("\n\n");
 printf("              @@@@@@          @@@@@\n");
 printf("              @     @        @     @  \n");
 printf("              @     @  @@@@  @        @@@@\n");
 printf("              @@@@@@       @ @  @@@@ @    @\n");
 printf("              @   @    @@@@@ @ @   @ @@@@@@ \n");
 printf("              @    @  @    @ @     @ @\n");
 printf("              @     @  @@@@@  @@@@@   @@@@ \n");
 printf("\n");
 printf("          Alliance CAD system,          RaGe 1.0\n");
 printf("          Tool: RaGe,              RAM Generator\n");
 printf("          (c) copyright 1993 MASI, CAO-VLSI team\n");
 printf("          E-mail support:   cao-vlsi@masi.ibp.fr\n");
 printf("\n\n");
 */
}
