
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: pat_savpaseq.c					*/
/* date		: Aug 31 1993						*/
/* version	: v104							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* content	: parser-driver functions				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include MUT_H
#include PAT_H
#include PPT_H

/* ###--------------------------------------------------------------### */
/* function	: pat_savpaseq						*/
/* description	: save a sequence of patterns into a pattern file	*/
/* called func.	: makfopen  , pat_error, pat_warning, pat_drvpat	*/
/* ###--------------------------------------------------------------### */

int pat_savpaseq (name, ptseq, labelsiz)

char         *name  ;		/* name of the drived file		*/
struct paseq *ptseq ;		/* list of existing sequences		*/
unsigned int  labelsiz;		/* length of the longest label		*/

  {
  static FILE *fp = NULL;
  static char *sfx = NULL;
  char        *str;
  int          flag;

	/* ###------------------------------------------------------### */
	/*    read the environment variable VH_PATSFX to get the	*/
	/* pattern file extension.					*/
	/* ###------------------------------------------------------### */

  if (sfx == NULL)
    {
    if ((str = getenv ("VH_PATSFX")) != NULL)
      sfx = strtok (str, ":");
    else
      sfx = "pat";
    }

  if (ptseq != NULL)
    {
	/* ###------------------------------------------------------### */
	/*    if the sequence exist ...					*/
	/* open a new file if it is the first call for the current	*/
	/* sequence. Produce a warning message if the previous file	*/
	/* has not been closed						*/
	/* ###------------------------------------------------------### */

    if (ptseq->DRVSEQ == 0)
      {
      if (fp != NULL)
        pat_warning (1, "driver", ' ', 0);
 
      if ((fp = mbkfopen (name, sfx, WRITE_TEXT)) == NULL)
        pat_error (102, name, ' ', 0);
      }

    if (fp != NULL)
      {
	/* ###------------------------------------------------------### */
	/*    parse the openned file. Close the file when the end is	*/
	/* reached.							*/
	/* ###------------------------------------------------------### */

      flag = pat_drvpat (fp, ptseq, labelsiz);

      if (ptseq->ENDFLG == 'Y')
        {
        fclose (fp);
        fp = NULL;
        }
      }
    }

  return (flag);
  }
