%{

/* ###--------------------------------------------------------------### */
/*									*/
/* file		: pat_pars.lex						*/
/* date		: Aug 31 1993						*/
/* version	: v104							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* content	: parser-driver function				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include MUT_H
#include "pat_type.h"
#include "y.tab.h"

#ifdef YY_DECL
#undef YY_DECL
#endif

#define YY_DECL int pat_lex (lval_pnt) YYSTYPE *lval_pnt;
#define yylval  (*lval_pnt)

static char buff [1024];
int         LINNUM = 1;
int         MAXPAT = 1;

%}

%s INS_PAT
%s OUT_PAT
%s DTC_FRM

letter		[a-zA-Z]

%%
\:								{
		BEGIN INS_PAT;
		return (Colon);
								}
(\;)+								{
		BEGIN OUT_PAT;

		if (yyleng < 16)
		  yylval.valu = yyleng - 1;
		else
		  yylval.valu = 15;

		return (Semicolons);
								}
\.								{
		BEGIN OUT_PAT;
		return (Dot);
								}
\,								{
		return (Comma);
								}
\(								{
		BEGIN INITIAL;
		return (LeftParen);
								}
\)								{
		BEGIN DTC_FRM;
		return (RightParen);
								}
\<=								{
		return (_LESym);
								}
<DTC_FRM>[xobXOB]						{
		yylval.immd = yytext[0];
		return (Format);
								}
\'[01]\'							{
		strcpy (buff,yytext);
		yylval.text = buff;
		return (BitStringLit);
								}
[xX]\"[0-9a-fA-F]+\"						{
		strcpy (buff,yytext);
		yylval.text = buff;
		return (BitStringLit);
								}
[oO]\"[0-7]+\"							{
		strcpy (buff,yytext);
		yylval.text = buff;
		return (BitStringLit);
								}
[bB]?\"[01]+\"							{
		strcpy (buff,yytext);
		yylval.text = buff;
		return (BitStringLit);
								}
<INITIAL,OUT_PAT,DTC_FRM>(0|[1-9][0-9]*)			{
		yylval.valu = atoi (yytext);
		return (AbstractLit);
								}
<INS_PAT>[0-9a-fA-F\*\+\-\? \t\n]+				{
		int i = 0;
		int j = 0;

		while ((buff[j] = yytext[i++]) != '\0')
		  {
		  if ((buff[j] != ' ' ) && (buff[j] != '\t') &&
		      (buff[j] != '\n'))
		    j++;
		  else
		    {
		    if (buff[j] == '\n')
		      LINNUM++;
		    }
		  }

		buff[j] = '\0';

		yylval.text = buff;
		return (Literal);
								}
<INITIAL,OUT_PAT,DTC_FRM>{letter}(_?({letter}|[0-9]))*		{
		int         code;
		static int  lcl_search ();

		yylval.text = namealloc (yytext);
		if ((code = lcl_search (yylval.text)) == -1)
		  {
		  BEGIN DTC_FRM;
		  return (Identifier);
		  }
		else
		  {
		  return (code);
		  }
								}
\#.*$								{
		yylval.text = namealloc (&yytext[1]);
		return (Comment);
								}
<INITIAL,OUT_PAT,DTC_FRM>\-\-.*$				{
								}
[ \t]								{
								}
\n								{
		LINNUM++;
								}
.								{
		return (UnknownChar);
								}
%%

/* ###--------------------------------------------------------------### */
/* function	: lcl_search						*/
/* description	: check that an identifier is a reserved word or not	*/
/* called func.	: addht, addhtitem, gethtitem, namealloc		*/
/* ###--------------------------------------------------------------### */

static int lcl_search (key)

char  *key;

  {
  static ht *pt_hash = NULL;

  if (pt_hash == NULL)
    {
    pt_hash = addht (20);

    addhtitem (pt_hash, namealloc("save")    , SAVE);
    addhtitem (pt_hash, namealloc("in")      , _IN);
    addhtitem (pt_hash, namealloc("out")     , _OUT);
    addhtitem (pt_hash, namealloc("inout")   , _INOUT);
    addhtitem (pt_hash, namealloc("register"), REGISTER);
    addhtitem (pt_hash, namealloc("signal")  , SIGNAL);
    addhtitem (pt_hash, namealloc("begin")   , BEGIN_);
    addhtitem (pt_hash, namealloc("end")     , END_);
    addhtitem (pt_hash, namealloc("to")      , TO);
    addhtitem (pt_hash, namealloc("downto")  , DOWNTO);
    }
  return (gethtitem (pt_hash, namealloc(key)));
  }
