
/* ###--------------------------------------------------------------### */
/*									*/
/* file		: pat_lodpaseq.c					*/
/* date		: Aug 17 1993						*/
/* version	: v104							*/
/* author	: Pirouz BAZARGAN SABET					*/
/* content	: parser-driver functions				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include MUT_H
#include PAT_H
#include PPT_H

/* ###--------------------------------------------------------------### */
/* function	: pat_lodpaseq						*/
/* description	: load a sequence of patterns from a pattern file	*/
/* called func.	: makfopen  , pat_error, pat_warning, pat_prspat	*/
/* ###--------------------------------------------------------------### */

struct paseq *pat_lodpaseq (name, ptseq, maxpat)

char         *name  ;		/* name of the new sequence		*/
struct paseq *ptseq ;		/* list of existing sequences		*/
unsigned int  maxpat;		/* # of pattern in a sub-sequence	*/

  {
  static FILE         *fp      = NULL;
  static struct chain *sfx_lst = NULL;
  struct chain        *sfx_pnt;
  char                *str;
  char                *tok;

  if ((ptseq == NULL) || (ptseq->ENDFLG == 'Y'))
    {
	/* ###------------------------------------------------------### */
	/*    read the environment variable VH_PATSFX to get the	*/
	/* pattern file extensions.					*/
	/* ###------------------------------------------------------### */

    if (sfx_lst == NULL)
      {
      if ((str = getenv ("VH_PATSFX")) != NULL)
        {
        tok = strtok (str, ":");
        while (tok != NULL)
          {
          sfx_lst = addchain (sfx_lst, tok);
          tok     = strtok (NULL, ":");
          }

        sfx_lst = (struct chain *) reverse (sfx_lst);
        }
      else
        sfx_lst = addchain (NULL, "pat");
      }

	/* ###------------------------------------------------------### */
	/*    open a new file. If the previous file has not been closed	*/
	/* produce a warning message.					*/
	/* ###------------------------------------------------------### */

    if (fp != NULL)
      pat_warning (1, "parser", ' ', 0);

    sfx_pnt = sfx_lst;
    while (sfx_pnt != NULL)
      {
      if ((fp = mbkfopen (name, sfx_pnt->DATA, READ_TEXT)) != NULL)
        break;
      sfx_pnt = sfx_pnt->NEXT;
      }

    if (fp == NULL)
      pat_error (102, name, ' ', 0);
    }

  if (fp != NULL)
    {
	/* ###------------------------------------------------------### */
	/*    parse the openned file. Close the file when the end is	*/
	/* reached or if an error has occured.				*/
	/* ###------------------------------------------------------### */

    ptseq = pat_prspat (fp, name, ptseq, maxpat);

    if ((ptseq == NULL) || (ptseq->ENDFLG == 'Y') || (ptseq->ERRFLG != 0))
      {
      fclose (fp);
      fp = NULL;
      }
    }

  return (ptseq);
  }
