
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: pat_addpaiol.c					*/
/* date		: Jul 16 1993						*/
/* version	: v104							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: low-level pat function				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H
#include PAT_H

/* ###--------------------------------------------------------------### */
/* function	: pat_addpaiol						*/
/* description	: create a PAIOL (input-output) structure at the top	*/
/*		  of a list						*/
/* called func.	: namealloc, mbkalloc					*/
/* ###--------------------------------------------------------------### */

struct paiol *pat_addpaiol (lastpaiol, name, format, mode, blank)

struct paiol  *lastpaiol;	/* pointer on the last paiol structure	*/
char          *name;		/* input-output's name			*/
char           format;		/* input-output format			*/
char           mode;		/* input-output mode			*/
unsigned char  blank;		/* nbr of blank column to be printed	*/
				/* after the input-output value		*/

  {
  struct paiol *ptiol;

  name          = namealloc (name);

  ptiol         = (struct paiol *) mbkalloc (sizeof(struct paiol));
  ptiol->NAME   = name;
  ptiol->FORMAT = format;
  ptiol->MODE   = mode;
  ptiol->BLANK  = blank;
  ptiol->VALUE  = '*';
  ptiol->SIG    = NULL;
  ptiol->NEXT   = lastpaiol;

  return (ptiol);
  }
