/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  optimiseur de netlist                                      */
/*    Fichier :  no_menu.c                                                  */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 06/05/1992     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include MUT_H
#include MLO_H
#include LOG_H
#include "../load/types_map.h"
#include "../netparam/no_param.h"
#include "../net/no_type.h"
#include "no_menu.h"
#include "titres.h"


ptype_list *lstGestion();

/*---------------------------------------------------------------------------
fonction MENU
---------------------------------------------------------------------------*/
int MENU( Titre, NbrOptions, ListOptions )

	char *Titre;
	int   NbrOptions; 
	char *ListOptions[];
	{
	char *debut = (char *) mbkalloc ( 2 * MaxString );
	char *milieu = (char *) mbkalloc ( 2 * MaxString );
	char *fin = (char *) mbkalloc ( 2 * MaxString );
	char  ListChoix[MaxString];
	char  Choix;
	int   NumOption;

	RazEcran;
        gotolc(2,2);
  printf("                      Chaine de CAO & VLSI   Alliance\n");
  printf("    ===========================================================\n");
  printf("    (c) copyright 1992 Laboratoire MASI equipe CAO & VLSI\n");
  printf("    All right reserved\n");
  printf("    Support : e-mail cao-vlsi@masi.ibp.fr\n");
  printf("    ===========================================================\n");
  printf("    %s",NO_VERSION);
  printf("\n\n\n");
  printf( "\t FUNCTION :  \t%s\n\n\n", Titre );
	
  debut[0] = '\0'; milieu[0] = '\0'; fin[0] = '\0';
	for( NumOption = 0; NumOption < NbrOptions; NumOption ++ )
		{
		if( sscanf( ListOptions[NumOption], "%[^<>] <%[A-Z_]> %[^<>]",
				debut, milieu, fin ) == 1 )
			printf( "   %s\n", debut );
		else
			{
			printf( "   %s<", debut );

			if( strcmp( milieu, "NO_PARAM" ) == 0 )
			   strcpy( milieu, NO_PARAM );
			if( strcmp( milieu, "NO_FILEPAR" ) == 0 )
			   strcpy( milieu, NO_FILEPAR );
			if( strcmp( milieu, "NO_FILE" ) == 0 )
			   strcpy( milieu, NO_FILE );
			if( strcmp( milieu, "NO_FACTOR" ) == 0 )
			   strcpy( milieu, itoa( NO_FACTOR ) );

/*
			if( strcmp( milieu, "NO_DELAY" ) == 0 )
			   strcpy( milieu, itoa( NO_DELAY ) );
			if( strcmp( milieu, "NO_DELAYCOUPLE" ) == 0 )
			   strcpy( milieu,
				itoa( countChain_list( NO_COUPLEDELAY ) )
			         );
*/
			if( strcmp( milieu, "NO_CAPAPI" ) == 0 )
			   strcpy( milieu,
				itoa( countChain_list( NO_CAPAPI ) )
			         );
			if( strcmp( milieu, "NO_CAPAPO" ) == 0 )
			   strcpy( milieu,
				itoa( countChain_list( NO_CAPAPO ) )
			         );
			if( strcmp( milieu, "NO_DELAYPO" ) == 0 )
			   strcpy( milieu,
				itoa( countChain_list( NO_DELAYPO ) )
			         );
			if( strcmp( milieu, "NO_RESISTPI" ) == 0 )
			   strcpy( milieu,
				itoa( countChain_list( NO_RESISTPI ) )
			         );
			if( strcmp( milieu, "NO_DELAYPI" ) == 0 )
			   strcpy( milieu,
				itoa( countChain_list( NO_DELAYPI ) )
			         );
			printf( "%s", milieu );
			printf( "> %s\n", fin );
			};
		ListChoix[NumOption] = ListOptions[NumOption][1];
		debut[0] = '\0'; milieu[0] = '\0'; fin[0] = '\0';
		}
	ListChoix[NbrOptions] = '\0';
#if MACHINE != pc
mbkfree( (void *) debut );
	mbkfree( (void *) milieu );
	mbkfree( (void *) fin );
#endif

	do {
 	   gotolc( 24, 5 );
	   Choix = toupper( AuVol() );
	   }
	while( strchr( ListChoix, Choix ) == NULL && Choix == 'q');
	return( Choix );
	}


/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/
int lireMot( mot )

	char *mot;
	{
	char *chaine = (char *) mbkalloc( 4 * MaxString );
	char *aux = (char *) mbkalloc( 4 * MaxString );

	while( 1 )
	   {
	   gets( chaine );
	   if( chaine[0] == '\0' ) return( 1 );
	   if( sscanf( chaine, "%s %s", mot, aux ) > 1 )
		{
		RazFinLigne; Beep;
		printf( "Please, give a simple name\n" ); RazFinLigne;
		printf( "\033[2A" ); RazFinLigne; gotolc( 10, 4 );
		}
	   else break;
	   }

	chaine[0] = '\0';

#if MACHINE != pc
	mbkfree( (void *) chaine );
#endif
	return( 0 );
	}

/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/
int lireEntier( entier )

	char *entier;
	{
	char *chaine = (char *) mbkalloc( 4 * MaxString );
	char *aux = (char *) mbkalloc( 4 * MaxString );

	while( 1 )
	   {
	   gets( chaine );
	   if( chaine[0] == '\0' ) return( 1 );
	   if( sscanf( chaine, "%[0-9] %s", entier, aux ) > 1 )
		{
		RazFinLigne; Beep;
		printf( "Please, give a simple number\n" ); RazFinLigne;
		printf( "\033[2A" ); RazFinLigne; gotolc( 10, 4 );
		}
	   else if( entier[0] == '\0' )
		   {
		   Beep;
		   printf( "I wait for a number!\n" ); RazFinLigne;
		   printf( "\033[2A" ); RazFinLigne; gotolc( 10, 4 );
		   }
		else break;
	   }

	chaine[0] = '\0';

#if MACHINE != pc
	mbkfree( (void *) chaine );
#endif
	return( 0 );
	}



/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/

void COPIER ()

	{
	char Archi[MaxString];
        char file[MaxString];

	RazEcran;
        printf("      	     file of parameters already existing :\n");
	gotolc(4, 1);
	listeDe(NO_PAR_LIB,"lax" );
	DemandeFic;
	scanf( "%15s1", Archi );fflush( stdin );
        if (!strcmp(Archi,"!")) return;
        file[0] = '\0';
        if (strcmp(NO_PAR_LIB,"."))
           {
           strcat( file,NO_PAR_LIB);
           strcat( file,"/");
           }
	strcat( file, Archi);
	strcat( file, ".lax" );
	saveParam(NO_SYS->par,file);
	}

/*---------------------------------------------------------------------------
TRAVAIL_AUTRE	: demande a l'utilisateur de choisir un autre fichier de
		  parametres (a la suite d'une suppression ou de la demande
		  de chargement d'un nouveau fichier).

		  - defaut est a 1 pour une suppression (si l'utilisateur ne
		  choisit pas de nouveau fichier --> default.lax)
		  - defaut est a 0 pour un load (si l'utilisateur ne choisit
                  pas de nouveau fichier --> ancien.lax)
---------------------------------------------------------------------------*/
void TRAVAIL_AUTRE (defaut)
short defaut;
	{
	char *Archi = (char *) malloc (MaxString);
        char *file  = (char *) malloc (MaxString);

	do {
	RazEcran;
        printf("      	     Choose another file of parameters :\n");
	gotolc(4, 1);
	listeDe(NO_PAR_LIB, "lax" );
	DemandeFic;
	scanf( "%15s1", Archi );fflush( stdin );
        if (!strcmp(Archi,"!"))
           if (defaut)
              {
              Archi[0] = '\0';
              strcat(Archi, "default");
              }
           else
              return; 
        strcat(Archi,".lax");
        file[0] = '\0';
        if (strcmp(NO_PAR_LIB,"."))
           {
           strcat( file,NO_PAR_LIB);
           strcat( file,"/");
           }
	strcat( file, Archi);
        }
        while ((NO_SYS->par = loadParam(file)) == NULL);
        NO_PARAM = file;
        NO_FILEPAR = Archi;
	}

/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/
void SUPPRIMER ()
        {
        char Action[2*MaxString];
        char Archi[MaxString];

        if (strcmp(NO_PARAM,"default.lax"))
           {
           strcpy( Action, "rm " );
           system( strcat( Action, NO_PARAM ) );
           Archi[0] = '\0';
           if (strcmp(NO_PAR_LIB,"."))
              {
              strcat( Archi,NO_PAR_LIB);
              strcat( Archi,"/");
              }
           strcpy(Archi,"default.lax");
           loadParam(Archi);
           }
        TRAVAIL_AUTRE(1);
        }



/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/
void  SAUVER ()
	{
        if (!strcmp(NO_FILEPAR,"default.lax"))
           {
           printf("Warning : default.lax is automatically generated,\n");
           printf("          Any change you make in this session will be lost,\n");
           printf("          Use another file for save the modifications...\n");
	   AuVol();
           }
	saveParam(NO_SYS->par,NO_PARAM);
	}

/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/
void OUTPUT_CAPA()

{
NO_CAPAPO = lstGestion( NO_CAPAPO, "OUTPUT WITH CAPACITY");
}

/*---------------------------------------------------------------------------
---------------------------------------------------------------------------*/

void INPUT_CAPA()

{
NO_CAPAPI = lstGestion( NO_CAPAPI, "INPUT WITH MAX FANOUT");
}

/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/
void FANOUT_FACTOR()
{
NO_FACTOR = intGestion("FANOUT FACTOR");
}

/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/
void DELAY_IN()
{
NO_DELAYPI = lstGestion( NO_DELAYPI, "INPUT WITH DELAY");
}

/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/
void MODIFIER ()

	{
	char Choix;

	do {
	   switch( Choix = MENU( TitreModif, NbrModif, ListModif ) )
		{
		case '1' : OUTPUT_CAPA(); 
			   break;
		case '2' : /*INPUT_CAPA();*/
			   break;
		case '3' : FANOUT_FACTOR();
			   break;
		case '4' : DELAY_IN();
			   break;
/*
		case '5' : 
			   break;
		case '6' : 
			   break;
*/
		};
	   }
	while( Choix != '5' && Choix != 'Q');
	}

/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/
void PARAMETRISATION ()

	{
	char Choix;

	do {
	   switch( Choix = MENU( TitreParam, NbrParam, ListParam ) )
		{
		case '1' : MODIFIER ();
			   break;
		case '2' : COPIER ();
			   break;
		case '3' : SUPPRIMER ();
			   break;
		case '4' : TRAVAIL_AUTRE (0);
			   break;
		case '5' : SAUVER();
			   break;
		};
	    }
	while( Choix != '6' && Choix != 'Q');
	}

/*---------------------------------------------------------------------------

---------------------------------------------------------------------------*/
/* Le menu principal */

void PRINCIPAL (mode)
int mode;

     {
     char  Choix;

     do{
       if (mode)
          {
		/* mode normal */
          switch ( Choix = MENU(TitrePrincipal,NbrPrincipal,ListPrincipal))
              {
              case '1' : 
	                 RazEcran;
                         gotolc(2,2);
                         system((char *)genNAME("vi %s",NO_FILELOG)); 
			 break;
              case '2' : 
	                 RazEcran;
                         gotolc(2,2);
                         OPTIMISATION_LOCALE(); 
                         printf("\n  Appuyer sur une touche puis sur Return...\n");
                         AuVol();
                         break;
              case '3' : 
	                 RazEcran;
                         gotolc(2,2);
                         INFORMATION('f'); 
                         printf("\n  Appuyer sur une touche puis sur Return...\n");
                         AuVol();
                         break;
              case '4' : 
	                 RazEcran;
                         gotolc(2,2);
                         OPTIMISATION_GLOBALE(); 
                         printf("\n  Appuyer sur une touche puis sur Return...\n");
                         AuVol();
                         break;
              case '5' : 
	                 RazEcran;
                         gotolc(2,2);
                         INFORMATION('t'); 
                         printf("\n  Appuyer sur une touche puis sur Return...\n");
                         AuVol();
                         break;
              case '6' : 
	                 RazEcran;
                         gotolc(2,2);
                         PARAMETRISATION(); 
			 break;
              };
          }
       else
          {
		/* mode RELAX */
          switch ( Choix = MENU ( TitrePrincipalRelax, 
                                  NbrPrincipalRelax, 
                                  ListPrincipalRelax ) )
              {
              case '1' : 
	                 RazEcran;
                         gotolc(2,2);
                         system((char *)genNAME("vi %s",NO_FILELOG)); 
			 break;
              case '2' : 
	                 RazEcran;
                         gotolc(2,2);
                         OPTIMISATION_LOCALE(); 
                         AuVol();
                         break;
              case '3' : 
	                 RazEcran;
                         gotolc(2,2);
                         INFORMATION('f'); 
                         AuVol();
                         break;
              case '4' : 
	                 RazEcran;
                         gotolc(2,2);
                         PARAMETRISATION(); 
			 break;
              };
          }
       }
     while ((Choix != '7') && (Choix != 'Q'));
     RazEcran;
     gotolc(1,1);
     }
