/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  optimiseur de netlist                                      */
/*    Fichier :  no_type.h                                                  */
/*                                                                          */
/*    (c) copyright 1991 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  L. Burgun                            le : 06/05/1992     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/****************************************************************************/

#include "../compil/lax_param.h"

#define NO_SYS no_sys
#define NO_OPTION no_sys->option
#define NO_MODE no_sys->mode
#define NO_VERSION no_sys->version
#define NO_FILE no_sys->file		/* nom + extension */
#define NO_FILEOUT no_sys->fileOut	/* nom de destination */
#define NO_FILELOG no_sys->fileLog      /* chemin + nom + extension */
#define NO_LOG no_sys->log
#define NO_FILEPAR no_sys->filePar
#define NO_NAME no_sys->name		/* nom */
#define NO_IN_LO no_sys->in_lo
#define NO_OUT_LO no_sys->out_lo
#define NO_PARAM no_sys->fileParam
#define NO_PAR no_sys->par

/* Nouvelle version du 14 Decembre 93
#define NO_DELAY (no_sys->par)->delay
#define NO_COUPLEDELAY (no_sys->par)->coupleDelay
#define NO_CCCC_LIB no_sys->c4_lib
*/

#define NO_CAPAPI (no_sys->par)->capaPI
#define NO_DELAYPI (no_sys->par)->delayPI
#define NO_FACTOR (no_sys->par)->maxSlopeTime
#define NO_CAPAPO (no_sys->par)->capaPO
#define NO_DELAYPO (no_sys->par)->earlyPO
#define NO_RESISTPI (no_sys->par)->impedancePI

#define NO_LOG_LIB no_sys->log_lib		/* chemin */
#define NO_PAR_LIB no_sys->par_lib
#define NO_CATA_LIB no_sys->cata_lib
#define NO_CELLTH no_sys->cellTH
#define NO_CELLS no_sys->cells
#define NO_TRACE no_sys->trace
#define TRACE no_sys->trace
	

/*-------------- systeme pour l'optimisation de netlist ---------------

  fileLog	: identificateur du fichier contenant la lofig
  fileParam	: fichier de parametres
  par		: pointeur sur la structure contenant les parametres
  lof		: pointeur sur la befig de l'architecture compilee  
  mode		: mode batch ou non.
  option	: option en batch "f" "t" "g" ou "i"
-----------------------------------------------------------------*/

typedef struct no_syst {
    	char *name;		/* nom netlist */
    	char *file;		/* nom netlist + extension */
    	char *filePar;		/* */
	char *fileLog;		/* chemin + nom netlist + extension */
	char *fileParam;	/* chemin + fich param + .lax */
	char *log_lib;		/* chemin des fichiers de parametres */
	char *par_lib;		/* chemin des netlists */
        char *fileOut;		/* nom du fichier de sortie */
	ptype_list *cata_lib;	/* chemin des bibliotheques */
	int  trace;
    	char *in_lo;		/* extension de la netlist d'entree */
    	char *out_lo;		/* extension de la netlist de sortie*/
	param *par;		/* strucuture de parametres */
	lofig_list *log;
        int mode;
        char *version;
	char option;
        cellList *cells;	/* pointeur sur la liste des cellules */
        pTH cellTH;		/* TH des cellules */
	} no_system;

no_system *no_sys;
no_system *initializeNOSystem();

char *VERSION;
