/************************************************************************
*       MBK : Parser alliance logic                                     *
*                                                                       *
*	version : 4.01					                                    *
*	date	: 23/07/92				                                    *
************************************************************************/

#include <ctype.h>
#include <string.h>
#include "generic_target.h"
#include MUT_H
#include MLO_H
#include MLU_H

#define TAILLE_CHAINE BUFSIZE

/************************************************************************
*                  alcloadlofig3()                                      *
************************************************************************/

void alcloadlofig3(pfig,fname,mode,in)
lofig_list * pfig;
char * fname;
char mode;
FILE * in;
{
	chain_list * pchains;
	lofig_list * ptfigmodele;
	lofig_list * tetemodele = NULL;
	losig_list * psig;
	char ligne[TAILLE_CHAINE];
	char nomtmp[TAILLE_CHAINE], * paux, *ptemp;
	char * type, * name, insname[TAILLE_CHAINE], figname[TAILLE_CHAINE], inst_avant, nomodele;
	long i, index, l, w, x, y, ps, pd, xs, xd, equig, equid, equis;
	float capa;

/* Analyse de la ligne d'entete H */
	(void)fgets(ligne,TAILLE_CHAINE,in);
	if (ligne[0]!='H')
	{
		(void)fprintf(stderr,"\n*** mbk error *** line 2 unexpected, header needed\n");
		EXIT(1);
	}
	if ((paux=(char *)strchr(ligne,',')) == NULL)
	{
		(void)fprintf(stderr,"\n*** mbk error *** syntax error line : 2\n");
		EXIT(1);
	}
	*paux='\0';
/* controle du nom */
	if (strcmp(ligne+2,fname)!=0)
	{
		(void)fprintf(stderr,"\n*** mbk error *** invalid name, line : 2\n");
		EXIT(1);
	}
	paux++;
/*controle du type de fichier */
	if (*paux!='L')
	{
		(void)fprintf(stderr,"\n*** mbk error *** bad file type\n");
		EXIT(1);
	}
/* boucle de lecture */
	inst_avant  = nomodele = 0;
	for(i=3;;i++)
	{
		if (fgets(ligne,TAILLE_CHAINE,in)==NULL)
		{
			(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
			EXIT(1);
		}
		if (strncmp(ligne,"EOF",3)==0)
			break;
		switch(ligne[0])
		{
			case 'C' :
				if ((mode == 'C') && (!inst_avant))
					continue;
				name = ligne + 2;
				if ((paux=(char *)strchr(ligne+2,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				type = ptemp;
				ptemp=paux+1;
				index = atol(ptemp);
				if (inst_avant)
				{
					psig = givelosig(ptfigmodele,index);
					psig->TYPE = 'E';
					if (nomodele)
						(void)addlocon(ptfigmodele,name,psig,alc_directiondecode(type));
					pchains = addchain(pchains,(void *)givelosig(pfig,index));
				}
				else
				{
					psig = givelosig(pfig,index);
					psig->TYPE = 'E';
					(void)addlocon(pfig,name,psig,alc_directiondecode(type));
				}
				break;
			case 'T' :
				if (mode == 'P')
					goto end_lopars;
				if (inst_avant)
				{
					(void)addloins(pfig,insname,ptfigmodele,pchains);
					freechain(pchains);
				}
				inst_avant = 0;
				pchains = NULL;
				if ((paux=(char *)strchr(ligne+2,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				ptemp=paux+1;
				type = ligne+2;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				l = (long)(atof(ptemp) * (float)SCALE_X);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				w = (long)(atof(ptemp) * (float)SCALE_X);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				equid = atol(ptemp);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				equig = atol(ptemp);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				equis = atol(ptemp);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				xs = (long)(atof(ptemp) * (float)SCALE_X);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				xd = (long)(atof(ptemp) * (float)SCALE_X);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				ps = (long)(atof(ptemp) * (float)SCALE_X);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				pd = (long)(atof(ptemp) * (float)SCALE_X);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				x = (long)(atof(ptemp) * (float)SCALE_X);
				ptemp=paux+1;
				y = (long)(atof(ptemp) * (float)SCALE_X);
				(void)addlotrs(pfig, (*type == 'N') ? TRANSN : TRANSP, x, y, w, l, ps, pd, xs, xd, givelosig(pfig,equig), givelosig(pfig,equis), givelosig(pfig,equid));
				break;
			case 'I' :
/******************************************************************************/
/*  probleme : addloins va chercher le modele sur disque alors que toutes les */
/*  informations sont donnees dans le fichier .al ou alx et ceci pose de gros */
/*  problemes a tout le monde.  ce qu'il faudrai c'est fabriquer le modele a  */
/*  partir de la premiere instance lue (addlofig) avant sont instanciation    */
/*  (addloins).  pour les autres instances du meme modele il faut que l'ordre */
/*  des connecteurs soient identiques, sinon, il faut reordenancer            */
/******************************************************************************/
				if (mode == 'P')
					goto end_lopars;
				if (inst_avant)
				{
					(void)addloins(pfig,insname,ptfigmodele,pchains);
					freechain(pchains);
				}
				pchains = NULL;
				inst_avant = 1;
				if ((paux=(char *)strchr(ligne+2,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				(void)strcpy(figname,ligne+2);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,'\n')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				(void)strcpy(insname,ptemp);
				if ((ptfigmodele = getlomodel(tetemodele,figname)) == NULL)
				{
					nomodele = 1;
					ptfigmodele = tetemodele = addlomodel(tetemodele,figname);
				}
				else
					nomodele = 0;
				break;
			case 'S' :
				if (mode == 'P')
					goto end_lopars;
				if (inst_avant)
				{
					(void)addloins(pfig,insname,ptfigmodele,pchains);
					freechain(pchains);
				}
				pchains = NULL;
				inst_avant = 0;
				if ((paux=(char *)strchr(ligne+2,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				index = atol(ligne+2);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,',')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				capa = atof(ptemp);
				ptemp=paux+1;
				if ((paux=(char *)strchr(ptemp,'\n')) == NULL)
				{
					(void)fprintf(stderr,"\n*** mbk error *** syntax error line : %d\n",i);
					EXIT(1);
				}
				*paux='\0';
				psig = givelosig(pfig,index);
				addcapa(psig,capa);
				if ((w = atol(ptemp)) != 0)
				{
					if (w != index)
					{
						(void)strcpy(nomtmp,"mbk_sig");
						(void)strcat(nomtmp,ptemp);
						psig->NAMECHAIN = addchain(psig->NAMECHAIN,(void *)namealloc(nomtmp));
					}
				}
				else
					if (strcmp(ptemp,"*") != 0)
						psig->NAMECHAIN = addchain(psig->NAMECHAIN,(void *)namealloc(ptemp));
				break;
			default :
				(void)fprintf(stderr,"\n*** mbk error *** line %d unexpected\n",i);
				EXIT(1);
				
		}
	}
end_lopars :
	if (inst_avant)
	{
		(void)addloins(pfig,insname,ptfigmodele,pchains);
		freechain(pchains);
	}
	freelomodel(tetemodele);
}

