/************************************************************************
*       MBK : Driver alliance logic                                     *
*                                                                       *
*	version : 4.03					                                    *
*	date	: 23/09/93				                                    *
************************************************************************/

#include "generic_target.h"
#include MUT_H 
#include MLO_H 

#ident "@(#)Driver alliance logic v4.03 23/09/93 by Vincent POUILLEY"

#define TAILLE_CHAINE BUFSIZE

/************************************************************************
*                  get_date()                                           *
************************************************************************/

static void get_date(date)
char * date;
{
	time_t tim;
	struct tm *rest;
	
	(void)time(&tim);
	rest=localtime(&tim);
	(void)sprintf(date,"%2d/%2d/%2d",rest->tm_mday,rest->tm_mon+1,rest->tm_year);
}

/************************************************************************
*                  alc_decodedirection()                                *
************************************************************************/

char * alc_decodedirection(dir)
char dir;
{
	switch(dir)
	{
		case IN :
			return "IN";
		case OUT :
			return "OUT";
		case INOUT :
			return "INOUT";
		case UNKNOWN :
			return "UNKNOWN";
		case TRISTATE :
			return "TRISTATE";
		case TRANSCV :
			return "TRANSCV";
		default :
			(void)fprintf(stderr,"\n*** mbk error *** savelofig (al) invalid connector direction : %c\n",dir);
			return "UNKNOWN";
	}
}

/************************************************************************
*                  alc_decodetype()                                     *
************************************************************************/

char * alc_decodetype(type)
char type;
{
	switch(type)
	{
		case INTERNAL :
			return "INTERNAL";
		case EXTERNAL :
			return "EXTERNAL";
		default :
			(void)fprintf(stderr,"\n*** mbk error *** savelofig (al) invalid connector/signal type : %c\n",type);
			return "INTERNAL";
	}
}

/************************************************************************
*                  alcsavelofig()                                       *
************************************************************************/
void alcsavelofig(pfig)
lofig_list * pfig;
{
	locon_list * pcon;
	lotrs_list * ptrs;
	loins_list * pins;
	losig_list * psig;
	chain_list * tmp;
	char * name;
	FILE *in;
	char nomfic[TAILLE_CHAINE];
	char nomp[TAILLE_CHAINE];
	
	(void)sprintf(nomfic,"%s/%s.%s",WORK_LIB,pfig->NAME,OUT_LO);
	in=mbkfopen(pfig->NAME, OUT_LO, WRITE_TEXT);
	if(!in)
	{
		(void)fprintf(stderr,"\n*** mbk error *** savelofig (al) can't open file : %s\n",nomfic);
		EXIT(1);
	}
	if (TRACE_MODE == 'Y')
	{
		(void)printf("\n--- mbk --- writing the file : %s\n",nomfic);
	}
/*   reverse connectors, instances, etc.  */
	pfig->LOCON = (locon_list *)reverse((chain_list *)pfig->LOCON);
	pfig->LOINS = (loins_list *)reverse((chain_list *)pfig->LOINS);
	pfig->LOTRS = (lotrs_list *)reverse((chain_list *)pfig->LOTRS);
	for(pins = pfig->LOINS ; pins ; pins = pins->NEXT)
    {
		pins->LOCON = (locon_list *)reverse((chain_list *)pins->LOCON);
    }
/* write header */
	(void)fprintf(in,"V ALLIANCE : 4\n");
	get_date(nomp);
	(void)fprintf(in,"H %s,L,%s\n",pfig->NAME,nomp);
/* write connectors of the figure */
	for (pcon = pfig->LOCON; pcon != NULL; pcon = pcon->NEXT)
	{
		(void)fprintf(in,"C %s,%s,%s,%ld\n",pcon->NAME,alc_decodedirection(pcon->DIRECTION),alc_decodetype(pcon->TYPE),pcon->SIG->INDEX);
	}
	/* write transistors */
	for (ptrs = pfig->LOTRS; ptrs != NULL; ptrs = ptrs->NEXT)
	{
		(void)fprintf(in,"T %c,%g,%g,%ld,%ld,%ld,%g,%g,%g,%g,%g,%g\n", (ptrs->TYPE == TRANSN)?'N':'P', (float)((float)(ptrs->LENGTH)/(float)SCALE_X), (float)((float)(ptrs->WIDTH)/(float)SCALE_X), ptrs->DRAIN->SIG->INDEX, ptrs->GRID->SIG->INDEX, ptrs->SOURCE->SIG->INDEX, (float)((float)(ptrs->XS)/(float)SCALE_X), (float)((float)(ptrs->XD)/(float)SCALE_X), (float)((float)(ptrs->PS)/(float)SCALE_X), (float)((float)(ptrs->PD)/(float)SCALE_X), (float)((float)(ptrs->X)/(float)SCALE_X), (float)((float)(ptrs->Y)/(float)SCALE_X));
	}
/* write instances */
	for (pins = pfig->LOINS; pins != NULL; pins = pins->NEXT)
	{
		(void)fprintf(in,"I %s,%s\n",pins->FIGNAME,pins->INSNAME);
		for (pcon = pins->LOCON; pcon != NULL; pcon = pcon->NEXT)
		{
			(void)fprintf(in,"C %s,%s,%s,%ld\n",pcon->NAME,alc_decodedirection(pcon->DIRECTION),alc_decodetype(pcon->TYPE),pcon->SIG->INDEX);
		}
	}
/* write signals */
	for (psig = pfig->LOSIG; psig != NULL; psig = psig->NEXT)
	{
		(void)fprintf(in,"S %ld,%s,%g",psig->INDEX,alc_decodetype(psig->TYPE), psig->CAPA);
		for (tmp = psig->NAMECHAIN; tmp; tmp = tmp->NEXT)
		{
			(void)fprintf(in,",%s",(char *)(tmp->DATA));
		}
		(void)fprintf(in,"\n");
	}
/* write End Of File and close the file */
	(void)fputs("EOF\n",in);
	if (fclose(in) != 0)
	{
		(void)fprintf(stderr,"\n*** mbk error *** can't close file : %s\n",nomfic);
		EXIT(1);
	}
	
/*   reverse back connectors, instances, etc. */
	pfig->LOCON = (locon_list *)reverse((chain_list *)pfig->LOCON);
	pfig->LOINS = (loins_list *)reverse((chain_list *)pfig->LOINS);
	pfig->LOTRS = (lotrs_list *)reverse((chain_list *)pfig->LOTRS);
	for(pins = pfig->LOINS ; pins ; pins = pins->NEXT)
	{
		pins->LOCON = (locon_list *)reverse((chain_list *)pins->LOCON);
	}
}
