/*------------------------------------------------------------\
|                                                             |
| Tool    :                   LYNX                            |
|                                                             |
| File    :                  mbkrds.h                         |
|                                                             |
| Authors :               Jacomme Ludovic                     |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef LYNX_MBKRDS
# define LYNX_MBKRDS

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# define LYNX_TREAT          (long)0x00020000
# define LYNX_FIRST_LINK     (long)0x00040000

# define LYNX_NORTH          (char)0
# define LYNX_SOUTH          (char)1
# define LYNX_EAST           (char)2
# define LYNX_WEST           (char)3

# define LYNX_NORTH_MASK     (char)1
# define LYNX_SOUTH_MASK     (char)2
# define LYNX_WEST_MASK      (char)4
# define LYNX_EAST_MASK      (char)8

/*------------------------------------------------------------\
|                                                             |
|                             Macros                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Mbk Attribute                      |
|                                                             |
\------------------------------------------------------------*/

# define SetLynxAttribute( Rectangle, Attribute )             \
                                                              \
   ( ( Rectangle )->FLAGS |= (((long)Attribute) << 24 )       )

# define GetLynxAttribute( Rectangle )                        \
                                                              \
   ( ( ( ( Rectangle )->FLAGS ) >> 24 ) & 0x1F                )

/*------------------------------------------------------------\
|                                                             |
|                          Mbk Attribute                      |
|                                                             |
\------------------------------------------------------------*/

# define SetLynxOrient( Rectangle, Orient )                   \
                                                              \
   ( ( Rectangle )->FLAGS |= (((long)Orient) << 29 )          )

# define GetLynxOrient( Rectangle )                           \
                                                              \
   ( ( ( ( Rectangle )->FLAGS ) >> 29 ) & 0x7                 )

/*------------------------------------------------------------\
|                                                             |
|                           Lynx Treat                        |
|                                                             |
\------------------------------------------------------------*/

# define IsLynxTreat( Rectangle )           \
                                            \
   ( ( Rectangle )->FLAGS & LYNX_TREAT      )

# define SetLynxTreat( Rectangle )          \
                                            \
   ( ( Rectangle )->FLAGS |= LYNX_TREAT     )

# define ClearLynxTreat( Rectangle )        \
                                            \
   ( ( Rectangle )->FLAGS &= ~LYNX_TREAT    )

/*------------------------------------------------------------\
|                                                             |
|                        Lynx First Link                      |
|                                                             |
\------------------------------------------------------------*/

# define IsLynxFirstLink( Rectangle )            \
                                                 \
   ( ( Rectangle )->FLAGS & LYNX_FIRST_LINK      )

# define SetLynxFirstLink( Rectangle )           \
                                                 \
   ( ( Rectangle )->FLAGS |= LYNX_FIRST_LINK     )

# define ClearLynxFirstLink( Rectangle )         \
                                                 \
   ( ( Rectangle )->FLAGS &= ~LYNX_FIRST_LINK    )

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern rdsfig_list *Lynxfigmbkrds();

# endif
