/*------------------------------------------------------------\
|                                                             |
| Tool    :                   LYNX                            |
|                                                             |
| File    :                  lyerror.c                        |
|                                                             |
| Author  :               Jacomme Ludovic                     |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h> 
# include "lyerror.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                    ErrorPhysicalConnector                   |
|                                                             |
\------------------------------------------------------------*/

  void ErrorPhysicalConnector( Name, Core )
      
       char *Name;
       char  Core;
  {
    fprintf( stderr, 
             "\n Lynx.107 Error : connector %s is on two different equis !\n\n", Name );

    if ( Core ) 
    {
      fprintf( stderr, " Lynx.107 Warning : Generates core_equi file !\n\n" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    ErrorPhysicalConnectors                  |
|                                                             |
\------------------------------------------------------------*/

  void ErrorPhysicalConnectors( FirstName, SecondName, Core )
      
       char *FirstName;
       char *SecondName;
       char  Core;
  {
    fprintf( stderr, 
             "\n Lynx.107 Error : connectors %s and %s are on the same equi !\n\n", 
             FirstName, SecondName );

    if ( Core ) 
    {
      fprintf( stderr, " Lynx.107 Warning : Generates core_equi file !\n\n" );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                    ErrorMissingConnector                    |
|                                                             |
\------------------------------------------------------------*/

  void ErrorMissingConnector( Name )

       char *Name;
  {
    fprintf( stderr,
             "\n Lynx.107 Error : No connector found in %s !\n\n", Name );

    exit( 1 ); 
  }

/*------------------------------------------------------------\
|                                                             |
|                     ErrorGenerateCoreFLoat                  |
|                                                             |
\------------------------------------------------------------*/

  void ErrorGenerateCoreFloat()

  {
    fprintf( stderr, "\n Lynx.107 Warning : Generates core_float file !\n\n" );
  }

/*------------------------------------------------------------\
|                                                             |
|                     ErrorCutTransistorElbow                 |
|                                                             |
\------------------------------------------------------------*/

  void ErrorCutTransistorElbow( Core )

       char Core;
  {
    fprintf( stderr, "\n          Lynx.107 Error : Unable to cut transistor\n\n" );

    if ( Core ) 
    {
      fprintf( stderr, "          Lynx.107 Warning : Generates core_cx file !\n\n" );
    }

    exit( 1 ); 
  }

/*------------------------------------------------------------\
|                                                             |
|                     ErrorMaskCounterNull                    |
|                                                             |
\------------------------------------------------------------*/

  void ErrorMaskCounterNull()

  {
    fprintf( stderr, "\n            Lynx.107 Error : No rectangle found\n\n" );

    exit( 1 ); 
  }

/*------------------------------------------------------------\
|                                                             |
|                       ErrorTooFewParameters                 |
|                                                             |
\------------------------------------------------------------*/

  void ErrorTooFewParameters()

  {
    fprintf( stderr,
             "\n  Syntax : lynx [-v] [-c] [ -f or -t ] Input_name [ Output_name ]\n\n");

    fprintf( stderr,"    -v  Sets verbose mode on\n"); 
    fprintf( stderr,"    -c  Generates a core file when an error occurs\n"); 
    fprintf( stderr,"    -f  Flattens the layout to the catalog level befor extracting\n");
    fprintf( stderr,"    -t  Flattens the layout to transistors level befor extracting\n\n");

    exit( 1 ); 
  }

/*------------------------------------------------------------\
|                                                             |
|                       ErrorIllegalCombination               |
|                                                             |
\------------------------------------------------------------*/

  void ErrorIllegalCombination()

  {
    fprintf( stderr, "\n          Lynx.107 Error : Illegal combination -t -f !\n\n");

    exit( 1 ); 
  }

/*------------------------------------------------------------\
|                                                             |
|                       ErrorIllegalOption                    |
|                                                             |
\------------------------------------------------------------*/

  void ErrorIllegalOption( Option )

       char *Option;
  {
    fprintf( stderr, "\n            Lynx.107 Error : Illegal option %s !\n\n", Option );

    exit( 1 ); 
  }

/*------------------------------------------------------------\
|                                                             |
|                       ErrorIllegalFileName                  |
|                                                             |
\------------------------------------------------------------*/

  void ErrorIllegalFileName( Name )

       char *Name;
  {
    fprintf( stderr, "\n           Lynx.107 Error : Illegal file name %s !\n\n", Name );

    exit( 1 ); 
  }
