/*------------------------------------------------------------\
|                                                             |
| Tool    :                   LYNX                            |
|                                                             |
| File    :                  extract.h                        |
|                                                             |
| Authors :               Jacomme Ludovic                     |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef LYNX_EXTRACT
# define LYNX_EXTRACT

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# define LYNX_TREAT_EQUI     (long)0x00080000
# define LYNX_END_EQUI       (long)0x00100000

/*------------------------------------------------------------\
|                                                             |
|                            Macro                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Lynx Equi                          |
|                                                             |
\------------------------------------------------------------*/

# define IsLynxEqui( Rectangle )              \
                                              \
   ( ( Rectangle )->FLAGS & LYNX_TREAT_EQUI   )

# define SetLynxEqui( Rectangle )             \
                                              \
   ( ( Rectangle )->FLAGS |= LYNX_TREAT_EQUI  )

# define ClearLynxEqui( Rectangle )           \
                                              \
   ( ( Rectangle )->FLAGS &= ~LYNX_TREAT_EQUI )

/*------------------------------------------------------------\
|                                                             |
|                       Lynx End Equi                         |
|                                                             |
\------------------------------------------------------------*/

# define IsLynxEndEqui( Rectangle )             \
                                                \
   ( ( Rectangle )->FLAGS & LYNX_END_EQUI       )

# define SetLynxEndEqui( Rectangle )            \
                                                \
   ( ( Rectangle )->FLAGS |= LYNX_END_EQUI      )

# define ClearLynxEndEqui( Rectangle )          \
                                                \
   ( ( Rectangle )->FLAGS &= ~LYNX_END_EQUI     )

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

  extern long LynxBuildEqui();
  extern void LynxDumpAllEqui();
  extern void LynxDumpEqui();

# endif
