/*------------------------------------------------------------\
|                                                             |
| Tool    :                   LYNX                            |
|                                                             |
| File    :                 extract.c                         |
|                                                             |
| Author  :               Jacomme Ludovic                     |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>

# include MUT_H
# include MLO_H
# include MPH_H
# include RDS_H
# include RUT_H
# include RPR_H
# include RFM_H
# include RWI_H

# include "share.h"
# include "cut.h"
# include "extract.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        LynxBuildEqui                        |
|                                                             |
\------------------------------------------------------------*/

  long LynxBuildEqui( HeadEqui, Window )

    rdsrec_list **HeadEqui;
    rdswindow    *Window;
  {
    rdswin_list    *Win;
    rdswin_list    *ScanWin;
    rdswinrec_list *WinRec;
    rdswinrec_list *ScanWinRec;
    rdsrecwin_list *RecWin;
    rdsrecwin_list *ScanRecWin;
    rdsrecwin_list  StaticRecWin;

    rdsrec_list    *Previous;
    rdsrec_list    *Rec;
    rdsrec_list    *ScanRec;
    rdsrec_list    *ScanInsRec;
    rdsins_list    *ScanIns;
 
    long            X1;
    long            Y1;
    long            X2;
    long            Y2;

    long            WinIndex;
    char            RecIndex;
    char            ScanRecIndex;
    char            Index;

    char            Layer;
    char            WinLayer;
    char            RecLayer;
    char            InsLayer;
  
    long            Counter;
    
    Counter = 0;

    *HeadEqui = Previous = allocrdsrec( LYNX_MODE );

    StaticRecWin.NEXT = (rdsrecwin_list *)NULL;

    for ( WinIndex = 0; WinIndex < Window->SIZE; WinIndex++ )
    {
      Win = Window->WINTAB + WinIndex;

      for ( WinLayer = 0; WinLayer < RWI_MAX_LAYER; WinLayer++ )
      {
        Layer = GET_LYNX_GRAPH_LAYER( WinLayer, 0 );

        if ( Layer == RDS_LYNX_GRAPH_EMPTY ) continue;
             
        for ( WinRec  = Win->LAYERTAB[ WinLayer ];
              WinRec != (rdswinrec_list *)NULL;
              WinRec  = WinRec->NEXT )
        {
          for ( RecIndex = 0; RecIndex < RWI_MAX_REC; RecIndex++ )
          {
            Rec = WinRec->RECTAB[ RecIndex ];

            if ( ( Rec != (rdsrec_list *)NULL ) &&
                 ( ! IsLynxDeleted( Rec )     ) &&
                 ( ! IsLynxEqui( Rec )        ) )
            {
              if ( IsRdsFigRec( Rec ) )
              {
                SetLynxEqui( Rec );

                LYNX_EQUI( Previous ) = Rec;
                Previous              = Rec;
              }
              else
              if ( ( IsRdsConInter( Rec ) ) ||
                   ( IsRdsRefCon( Rec   ) ) )
              {
                SetLynxEqui( Rec );

                LYNX_EQUI( Previous ) = Rec;
                Previous              = Rec;

                ScanIns = (rdsins_list *)LYNX_LINK( Rec );

                for ( InsLayer = 0 ;
                      InsLayer < RWI_MAX_LAYER ;
                      InsLayer++ )
                {
                  for ( ScanInsRec  = ScanIns->LAYERTAB[ InsLayer ];
                        ScanInsRec != (rdsrec_list *)NULL;
                        ScanInsRec  = ScanInsRec->NEXT )
                  {
                    if ( ( ( IsRdsConInter( ScanInsRec ) ) ||
                         ( IsRdsRefCon( ScanInsRec )   )   ) &&
                         ( ! IsLynxEqui( ScanInsRec )      ) &&
                         ( Rec->NAME == ScanInsRec->NAME ) )
                    {
                      SetLynxEqui( ScanInsRec );

                      LYNX_EQUI( Previous ) = ScanInsRec;
                      Previous              = ScanInsRec;
                    }
                  }
                }
              }

              do
              {
                X1 = Rec->X;
                Y1 = Rec->Y;
                X2 = Rec->DX + X1;
                Y2 = Rec->DY + Y1;

                RecLayer = GetRdsLayer ( Rec );

                if ( IsRdsOneWindow( Rec ) )
                {
                  StaticRecWin.WINDOW = (rdswin_list *)Rec->USER;
                  RecWin              = &StaticRecWin;
                }
                else
                {
                  RecWin = (rdsrecwin_list *)Rec->USER;
                }

                for ( ScanRecWin  = RecWin;
                      ScanRecWin != (rdsrecwin_list *) NULL;
                      ScanRecWin  = ScanRecWin->NEXT )
                {
                  ScanWin = ScanRecWin->WINDOW;

                  Index = 0;
                  Layer = GET_LYNX_GRAPH_LAYER( RecLayer, Index );

                  while ( Layer != RDS_LYNX_GRAPH_EMPTY )
                  {
                    for ( ScanWinRec  = ScanWin->LAYERTAB[ Layer ];
                          ScanWinRec != (rdswinrec_list *)NULL;
                          ScanWinRec  = ScanWinRec->NEXT )
                    {
                      for ( ScanRecIndex = 0; 
                            ScanRecIndex < RWI_MAX_REC;
                            ScanRecIndex++ )
                      {
                        ScanRec = ScanWinRec->RECTAB[ ScanRecIndex ];

                        if ( ( ScanRec != (rdsrec_list *)NULL     ) &&
                             ( ! IsLynxEqui( ScanRec )            ) &&
                             ( ! IsLynxDeleted( ScanRec )         ) &&
                             ( ( ScanRec->X               ) <= X2 ) &&
                             ( ( ScanRec->Y               ) <= Y2 ) &&
                             ( ( ScanRec->X + ScanRec->DX ) >= X1 ) &&
                             ( ( ScanRec->Y + ScanRec->DY ) >= Y1 ) )
                        {
                          SetLynxEqui( ScanRec );

                          LYNX_EQUI( Previous ) = ScanRec;
                          Previous              = ScanRec;

                          if ( ( ! IsRdsFigRec( ScanRec ) ) &&
                               ( ( IsRdsConInter( ScanRec ) ) ||
                                 ( IsRdsRefCon( ScanRec   ) ) ) )
                          {
                            ScanIns = (rdsins_list *)LYNX_LINK( ScanRec );

                            for ( InsLayer = 0 ; 
                                  InsLayer < RWI_MAX_LAYER ; 
                                  InsLayer++ )
                            {
                              for ( ScanInsRec  = ScanIns->LAYERTAB[ InsLayer ];
                                    ScanInsRec != (rdsrec_list *)NULL;
                                    ScanInsRec  = ScanInsRec->NEXT )
                              {
                                if ( ( ( IsRdsConInter( ScanInsRec ) ) ||  
                                       ( IsRdsRefCon( ScanInsRec )   )   ) &&
                                       ( ! IsLynxEqui( ScanInsRec )      ) &&
                                     ( ScanRec->NAME == ScanInsRec->NAME ) )
                                {
                                  SetLynxEqui( ScanInsRec );
    
                                  LYNX_EQUI( Previous ) = ScanInsRec;
                                  Previous              = ScanInsRec;
                                }
                              }
                            }
                          }
                        }
                      }
                    }

                    Index = Index + 1;
                    Layer = GET_LYNX_GRAPH_LAYER( RecLayer, Index );
                  }
                }

                ScanRec = Rec;
                Rec     = LYNX_EQUI( Rec );
              }
              while ( Rec != (rdsrec_list *)NULL );

              SetLynxEndEqui( ScanRec );

              Counter = Counter + 1;
            }
          }
        }
      }
    }

    Previous  = *HeadEqui; 
    *HeadEqui = LYNX_EQUI( Previous );

    freerdsrec( Previous, LYNX_MODE );
    
    return( Counter );
  }

/*------------------------------------------------------------\
|                                                             |
|                      LynxDumpAllEqui                        |
|                                                             |
\------------------------------------------------------------*/

  void LynxDumpAllEqui( FigureRds, HeadEqui, FigureMbk )

    rdsfig_list *FigureRds;
    rdsrec_list *HeadEqui;
    phfig_list  *FigureMbk;
  {
    rdsrec_list *ScanEqui;

    Lynxrecrdsmbk( FigureMbk, FigureRds->LAYERTAB[ RDS_ABOX ] );

    for ( ScanEqui  = HeadEqui;
          ScanEqui != (rdsrec_list *)NULL;
          ScanEqui  = LYNX_EQUI( ScanEqui ) )
    {
      Lynxrecrdsmbk( FigureMbk, ScanEqui );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                        LynxDumpEqui                         |
|                                                             |
\------------------------------------------------------------*/

  void LynxDumpEqui( FigureMbk, FirstEqui )

    phfig_list  *FigureMbk;
    rdsrec_list *FirstEqui;
  {
    while ( FirstEqui != (rdsrec_list *)NULL )
    {
      Lynxrecrdsmbk( FigureMbk, FirstEqui );

      if ( IsLynxEndEqui( FirstEqui ) ) break;

      FirstEqui = LYNX_EQUI( FirstEqui );
    }
  }
