/*------------------------------------------------------------\
|                                                             |
| Tool    :                   LYNX                            |
|                                                             |
| File    :                   cut.c                           |
|                                                             |
| Author  :               Jacomme Ludovic                     |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>

# include MUT_H
# include MLO_H
# include MPH_H
# include RDS_H
# include RUT_H
# include RPR_H
# include RFM_H
# include RWI_H

# include "share.h"
# include "mbkrds.h"
# include "cut.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  static phfig_list *FigureDumpContact = (phfig_list *)NULL;

/*------------------------------------------------------------\
|                                                             |
|                       Cut Transistor Table                  |
|                                                             |
\------------------------------------------------------------*/

  static long LYNX_CUT_C_X_PARAM[ 5 ];

  /* 0 -> Constant 0    */
  /* 1 -> Nothing to do */
  /* 2 -> D             */
  /* 3 -> ( D + d ) / 2 */
  /* 4 -> ( D - d ) / 2 */

  long LYNX_CUT_C_X_N_TABLE [ 16 ] [ 4 ] [ 4 ] =

  {
    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O   */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 2 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O   */
    { { 0, 0, 2, 4 }, { 0, 3, 4, 4 }, { 3, 4, 4, 3 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O   */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 2 }, { 0, 3, 3, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O   */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 2 }, { 0, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O-- */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 4, 0, 3, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 4 }, { 4, 3, 3, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O-- */
    { { 0, 0, 2, 4 }, { 0, 3, 2, 4 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O-- */
    { { 0, 0, 2, 4 }, { 0, 3, 4, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O-- */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 4 }, { 0, 3, 2, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O-- */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 4 }, { 0, 3, 4, 4 }, { 3, 3, 4, 4 } }, /*   |   */

  };

  long LYNX_CUT_C_X_P_TABLE [ 16 ] [ 4 ] [ 4 ] =

  {
    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O   */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 2 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O   */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O   */
    { { 0, 0, 2, 4 }, { 0, 3, 4, 4 }, { 3, 4, 4, 3 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O   */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 2 }, { 0, 3, 3, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O   */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 2 }, { 0, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O-- */
    { { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 4, 0, 3, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 4 }, { 4, 3, 3, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /*   O-- */
    { { 0, 0, 4, 2 }, { 3, 0, 4, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O-- */
    { { 0, 0, 2, 4 }, { 0, 3, 2, 4 }, { 1, 1, 1, 1 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O-- */
    { { 0, 0, 2, 4 }, { 0, 3, 4, 4 }, { 3, 3, 4, 4 }, { 1, 1, 1, 1 } }, /*       */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy              */
                                                                        /* --O-- */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 4 }, { 0, 3, 2, 4 }, { 1, 1, 1, 1 } }, /*   |   */

    /*  X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy     X  Y  Dx Dy          |   */
                                                                        /* --O-- */
    { { 0, 0, 4, 4 }, { 3, 0, 4, 4 }, { 0, 3, 4, 4 }, { 3, 3, 4, 4 } }, /*   |   */

  };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                   LynxInitializeCutCxTable                  |
|                                                             |
\------------------------------------------------------------*/

  void LynxInitializeCutCxTable()

  {
    int   Index;    
    long  DeltaGate;
    long  DeltaDiff;
    char  Layer;
    char  GateLayer;
    char  DiffLayer;
    long *Table;
 
    DeltaGate = -1;
    DeltaDiff = -1;
    Index     = 0;
    GateLayer = GET_SEGMENT_LAYER( NTRANS, 0 );
    DiffLayer = GET_SEGMENT_LAYER( NTRANS, 1 );
    Layer     = GET_VIA_LAYER( C_X_N, Index );

    while ( Layer != RDS_VIA_EMPTY )
    {
      if ( Layer == GateLayer )
      {
        DeltaGate = GET_VIA_SIZE( C_X_N, Index );
      }
      else
      if ( Layer == DiffLayer )
      {
        DeltaDiff = GET_VIA_SIZE( C_X_N, Index );
      }

      Index = Index + 1;

      Layer = GET_VIA_LAYER( C_X_N, Index );
    }

    Table = LYNX_CUT_C_X_N_TABLE[0][0];

    if ( ( DeltaGate == -1 ) || 
         ( DeltaDiff == -1 ) )
    {
      for ( Index = 0; Index < 256; Index++ )
      {  
        Table[ Index ] = -1;
      }
    }
    else
    {
      /* 0 -> Constant 0    */
      /* 1 -> Nothing to do */
      /* 2 -> D             */
      /* 3 -> ( D + d ) / 2 */
      /* 4 -> ( D - d ) / 2 */
       
      LYNX_CUT_C_X_PARAM[ 0 ] =  0;
      LYNX_CUT_C_X_PARAM[ 1 ] = -1;
      LYNX_CUT_C_X_PARAM[ 2 ] = DeltaDiff;
      LYNX_CUT_C_X_PARAM[ 3 ] = ( DeltaDiff + DeltaGate ) >> 1;
      LYNX_CUT_C_X_PARAM[ 4 ] = ( DeltaDiff - DeltaGate ) >> 1;

      for ( Index = 0; Index < 256; Index++ )
      {
        Table[ Index ] = LYNX_CUT_C_X_PARAM[ Table[ Index ] ];
      }
    }

    DeltaGate = -1;
    DeltaDiff = -1;
    Index     = 0;
    GateLayer = GET_SEGMENT_LAYER( PTRANS, 0 );
    DiffLayer = GET_SEGMENT_LAYER( PTRANS, 1 );
    Layer     = GET_VIA_LAYER( C_X_P, Index );

    while ( Layer != RDS_VIA_EMPTY )
    {
      if ( Layer == GateLayer )
      {
        DeltaGate = GET_VIA_SIZE( C_X_P, Index );
      }
      else
      if ( Layer == DiffLayer )
      {
        DeltaDiff = GET_VIA_SIZE( C_X_P, Index );
      }

      Index = Index + 1;

      Layer = GET_VIA_LAYER( C_X_P, Index );
    }

    Table = LYNX_CUT_C_X_P_TABLE[0][0];

    if ( ( DeltaGate == -1 ) ||
         ( DeltaDiff == -1 ) )
    {
      for ( Index = 0; Index < 256; Index++ )
      {
        Table[ Index ] = -1;
      }
    }
    else
    {
      /* 0 -> Constant 0    */
      /* 1 -> Nothing to do */
      /* 2 -> D             */
      /* 3 -> ( D + d ) / 2 */
      /* 4 -> ( D - d ) / 2 */

      LYNX_CUT_C_X_PARAM[ 0 ] =  0;
      LYNX_CUT_C_X_PARAM[ 1 ] = -1;
      LYNX_CUT_C_X_PARAM[ 2 ] = DeltaDiff;
      LYNX_CUT_C_X_PARAM[ 3 ] = ( DeltaDiff + DeltaGate ) >> 1;
      LYNX_CUT_C_X_PARAM[ 4 ] = ( DeltaDiff - DeltaGate ) >> 1;

      for ( Index = 0; Index < 256; Index++ )
      {
        Table[ Index ] = LYNX_CUT_C_X_PARAM[ Table[ Index ] ];
      }
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                   LynxCutTransistorElbow                    |
|                                                             |
\------------------------------------------------------------*/

  long LynxCutTransistorElbow( Figure, Window, Core )

    rdsfig_list *Figure;
    rdswindow   *Window;
    char         Core;
  {
    rdsrec_list    *Rectangle;
    rdsrec_list    *ScanRec;
    rdsrecwin_list  StaticRecWin;
    rdsrecwin_list *RecWin;
    rdsrecwin_list *ScanRecWin;
    rdswinrec_list *ScanWinRec;
    rdswin_list    *ScanWin;
    long           *LineTable;
    long            Counter;
    char            FoundError;
    char            Error;
    char            Flag;
    char            Type;
    char            Index;
    char            GateLayer;
    char            Layer;
    char            DiffLayer;
    long            X1;
    long            X2;
    long            Y1;
    long            Y2;
    long            X;
    long            Y;

    StaticRecWin.NEXT  = (rdsrecwin_list *)NULL;
    FigureDumpContact  = addphfig( "core_cx" );
    FoundError         = 0;
    Counter            = 0;

    Lynxrecrdsmbk( FigureDumpContact, Figure->LAYERTAB[ RDS_ABOX ] );
 
    GateLayer = GET_SEGMENT_LAYER( NTRANS, 0 );
    DiffLayer = GET_SEGMENT_LAYER( NTRANS, 1 );

    for ( Rectangle  = Figure->LAYERTAB[ GateLayer ];
          Rectangle != (rdsrec_list *)NULL;
          Rectangle  = Rectangle->NEXT )
    {
      if ( IsRdsVia( Rectangle ) )
      {
        Type = GetLynxAttribute( Rectangle );

        if ( Type == C_X_N )
        {
          X1 = Rectangle->X;
          X2 = Rectangle->DX + X1;
          Y1 = Rectangle->Y;
          Y2 = Rectangle->DY + Y1;
          X  = X1 + ( Rectangle->DX >> 1 );
          Y  = Y1 + ( Rectangle->DY >> 1 );

          Error = 0;
          Flag  = 0;

          if ( IsRdsOneWindow ( Rectangle ) )
          {
            StaticRecWin.WINDOW = (rdswin_list *)Rectangle->USER;
            RecWin              = &StaticRecWin;
          }
          else
          {
            RecWin = (rdsrecwin_list *)Rectangle->USER;
          }

          for ( ScanRecWin  = RecWin ;
                ( ScanRecWin != (rdsrecwin_list *)NULL ) && 
                ( Error      == 0                      );
                ScanRecWin  = ScanRecWin->NEXT )
          {
            ScanWin = ScanRecWin->WINDOW;

            for ( ScanWinRec  = ScanWin->LAYERTAB[ GateLayer ];
                  ( ScanWinRec != (rdswinrec_list *)NULL ) &&
                  ( Error      == 0                      );
                  ScanWinRec  = ScanWinRec->NEXT )
            {
              for ( Index = 0; Index < RWI_MAX_REC; Index++ )
              {
                ScanRec = ScanWinRec->RECTAB[ Index ];

                if ( ( ScanRec != (rdsrec_list *)NULL ) &&
                     (   IsRdsFigRec( ScanRec )       ) &&
                     (   IsRdsSegment( ScanRec )      ) )
                {
                  Layer = GetLynxAttribute( ScanRec );

                  if ( ( Layer == NTRANS                    ) &&
                       ( ScanRec->X                   <= X2 ) &&
                       ( ScanRec->Y                   <= Y2 ) &&
                       ( ( ScanRec->X + ScanRec->DX ) >= X1 ) &&
                       ( ( ScanRec->Y + ScanRec->DY ) >= Y1 ) )
                  {
                    if ( ScanRec->Y == Y )
                    {
                      Flag  |= LYNX_NORTH_MASK;
                    }
                    else
    
                    if ( ( ScanRec->Y + ScanRec->DY ) == Y )
                    {
                      Flag  |= LYNX_SOUTH_MASK;
                    }
                    else
    
                    if ( ( ScanRec->X + ScanRec->DX ) == X )
                    {
                      Flag  |= LYNX_WEST_MASK;
                    }
                    else
                    if ( ScanRec->X == X )
                    {
                      Flag  |= LYNX_EAST_MASK;
                    }
                    else 
                    {
                      Error = 1; break;
                    }
                  }
                }
              }
            }
          }

          if ( Error == 0 )
          {
            LineTable = &LYNX_CUT_C_X_N_TABLE[ Flag ][ 0 ][ 0 ];
            ScanRec   = LYNX_LINK( Rectangle );

            while ( ScanRec != Rectangle )
            {
              if ( GetRdsLayer( ScanRec ) == DiffLayer )
              {
                SetLynxDeleted( ScanRec );

                X = ScanRec->X;
                Y = ScanRec->Y;
              }

              ScanRec = LYNX_LINK( ScanRec );
            }

            for ( Index = 0; Index < 16; Index = Index + 4 )
            {
              if ( LineTable[ Index ]  == -1 ) break;

              ScanRec = addrdsfigrec( Figure,
                                      NULL, 
                                      DiffLayer,
                                      X + LineTable[ Index + 0 ],
                                      Y + LineTable[ Index + 1 ],
                                      LineTable[ Index + 2 ],
                                      LineTable[ Index + 3 ] );

              SetLynxCut( ScanRec );

              addrdsrecwindow( ScanRec, Window );
            }

            Counter = Counter + 1;
          }
          else
          {
            if ( Core ) 
            {
              Lynxrecrdsmbk( FigureDumpContact, Rectangle );

              FoundError = 1;
            }
            else
            {
              return( -1 );
            }
          }
        }
      }
    }

    GateLayer = GET_SEGMENT_LAYER( PTRANS, 0 );
    DiffLayer = GET_SEGMENT_LAYER( PTRANS, 1 );

    for ( Rectangle  = Figure->LAYERTAB[ GateLayer ];
          Rectangle != (rdsrec_list *)NULL;
          Rectangle  = Rectangle->NEXT )
    {
      if ( IsRdsVia( Rectangle ) )
      {
        Type = GetLynxAttribute( Rectangle );

        if ( Type == C_X_P )
        {
          X1 = Rectangle->X;
          X2 = Rectangle->DX + X1;
          Y1 = Rectangle->Y;
          Y2 = Rectangle->DY + Y1;
          X  = X1 + ( Rectangle->DX >> 1 );
          Y  = Y1 + ( Rectangle->DY >> 1 );

          Error = 0;
          Flag  = 0;

          if ( IsRdsOneWindow ( Rectangle ) )
          {
            StaticRecWin.WINDOW = (rdswin_list *)Rectangle->USER;
            RecWin              = &StaticRecWin;
          }
          else
          {
            RecWin = (rdsrecwin_list *)Rectangle->USER;
          }

          for ( ScanRecWin  = RecWin ;
                ( ScanRecWin != (rdsrecwin_list *)NULL ) && 
                ( Error      == 0                      );
                ScanRecWin  = ScanRecWin->NEXT )
          {
            ScanWin = ScanRecWin->WINDOW;

            for ( ScanWinRec  = ScanWin->LAYERTAB[ GateLayer ];
                  ( ScanWinRec != (rdswinrec_list *)NULL ) &&
                  ( Error      == 0                      );
                  ScanWinRec  = ScanWinRec->NEXT )
            {
              for ( Index = 0; Index < RWI_MAX_REC; Index++ )
              {
                ScanRec = ScanWinRec->RECTAB[ Index ];

                if ( ( ScanRec != (rdsrec_list *)NULL ) &&
                     (   IsRdsFigRec( ScanRec )       ) &&
                     (   IsRdsSegment( ScanRec )      ) )
                {
                  Layer = GetLynxAttribute( ScanRec );

                  if ( ( Layer == PTRANS                    ) &&
                       ( ScanRec->X                   <= X2 ) &&
                       ( ScanRec->Y                   <= Y2 ) &&
                       ( ( ScanRec->X + ScanRec->DX ) >= X1 ) &&
                       ( ( ScanRec->Y + ScanRec->DY ) >= Y1 ) )
                  {
                    if ( ScanRec->Y == Y )
                    {
                      Flag  |= LYNX_NORTH_MASK;
                    }
                    else
    
                    if ( ( ScanRec->Y + ScanRec->DY ) == Y )
                    {
                      Flag  |= LYNX_SOUTH_MASK;
                    }
                    else
    
                    if ( ( ScanRec->X + ScanRec->DX ) == X )
                    {
                      Flag  |= LYNX_WEST_MASK;
                    }
                    else
                    if ( ScanRec->X == X )
                    {
                      Flag  |= LYNX_EAST_MASK;
                    }
                    else 
                    {
                      Error = 1; break;
                    }
                  }
                }
              }
            }
          }

          if ( Error == 0 )
          {
            LineTable = &LYNX_CUT_C_X_P_TABLE[ Flag ][ 0 ][ 0 ];
            ScanRec   = LYNX_LINK( Rectangle );

            while ( ScanRec != Rectangle )
            {
              if ( GetRdsLayer( ScanRec ) == DiffLayer )
              {
                SetLynxDeleted( ScanRec );

                X = ScanRec->X;
                Y = ScanRec->Y;
              }

              ScanRec = LYNX_LINK( ScanRec );
            }

            for ( Index = 0; Index < 16; Index = Index + 4 )
            {
              if ( LineTable[ Index ]  == -1 ) break;

              ScanRec = addrdsfigrec( Figure,
                                      NULL, 
                                      DiffLayer,
                                      X + LineTable[ Index + 0 ],
                                      Y + LineTable[ Index + 1 ],
                                      LineTable[ Index + 2 ],
                                      LineTable[ Index + 3 ] );

              SetLynxCut( ScanRec );

              addrdsrecwindow( ScanRec, Window );
            }

            Counter = Counter + 1;
          }
          else
          {
            if ( Core ) 
            {
              Lynxrecrdsmbk( FigureDumpContact, Rectangle );

              FoundError = 1;
            }
            else
            {
              return( -1 );
            }
          }
        }
      }
    }

    if ( FoundError )
    {
      savephfig( FigureDumpContact );

      return( -1 );
    }

    return( Counter );
  }
