/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  menu.c                           |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

# include <Xm/Xm.h>
# include <X11/Intrinsic.h>
# include <Xm/RowColumn.h>
# include <Xm/Label.h>
# include <Xm/SeparatoG.h>
# include <Xm/Separator.h>

# include GTB_H
# include "GTB_menu.h"

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  static char MenuBuffer [ MENU_BUFFER_SIZE ];

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       GraalBuildMenus                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalBuildMenus( Father, Menu )

       Widget          Father;
       GraalMenuItem  *Menu;
  {

    Widget   Button;
    Widget   SubMenu;
    XmString Text;
    Arg      Args[ 2 ];
    int      Counter;

    for ( Counter = 0; 
          Menu[ Counter ].LABEL != NULL; 
          Counter++ )
    {
      if ( Menu[ Counter ].SEPARATOR == True )
      {
	XtCreateManagedWidget( "Separator", 
                               xmSeparatorWidgetClass, Father,
                               NULL                  ,
                               0 );
      }

      Button = XtVaCreateManagedWidget(  Menu[ Counter ].LABEL,
                                         *Menu[ Counter ].CLASS, Father, 
                                         XmNmnemonic, 
                                         Menu[ Counter ].MNEMONIC,
                                         NULL );
      Menu[ Counter ].BUTTON = Button;

      if ( Menu[ Counter ].SHORT_KEY != NULL )
      {
        XtVaSetValues( Button, 
                       XmNaccelerator, 
                       Menu[ Counter ].SHORT_KEY, 
                       NULL );
      }

      if ( Menu[ Counter ].SHORT_KEY != NULL )
      {
        Text = XmStringCreateSimple( Menu[ Counter ].SHORT_KEY_TEXT );

        XtVaSetValues( Button, 
                       XmNacceleratorText, 
                       Text,
                       NULL );

        XmStringFree( Text );
      }

      if ( Menu[ Counter ].CALLBACK != NULL )
      {
        XtAddCallback( Button, 
                       XmNactivateCallback, 
                       Menu[ Counter ].CALLBACK,
                       Menu[ Counter ].CALLDATA );
      }

      if ( Menu[ Counter ].HELP == True )
      {
	XtSetArg( Args[ 0 ], XmNmenuHelpWidget, Button );

	XtSetValues( Father, Args, 1 );
      }

      if ( Menu[ Counter ].NEXT != NULL)
      {
	strcpy( MenuBuffer, Menu[ Counter ].LABEL );
	strcat( MenuBuffer, " Menu"               );

        SubMenu = XmCreatePulldownMenu( Father, 
                                        MenuBuffer,
                                        Args, 0 );

        Menu[ Counter ].MENU = SubMenu;

        if ( Menu[ Counter ].TITLE == True )
        {
	  Text = XmStringCreateLtoR( MenuBuffer, XmSTRING_DEFAULT_CHARSET );

	  XtVaCreateManagedWidget( "MenuTitle", 
                                   xmLabelWidgetClass, 
                                   SubMenu,
                                   XmNlabelString, Text,
                                   NULL );

          XmStringFree( Text );

          XtCreateManagedWidget( "Separator",
                                 xmSeparatorWidgetClass,
                                 SubMenu,
                                 NULL,
                                 0 );
	}

	XtSetArg( Args[ 0 ], XmNsubMenuId, SubMenu ); 
	XtSetValues( Button, Args, 1 );

        GraalBuildMenus( SubMenu, Menu[ Counter ].NEXT );
      }
      else Menu[ Counter ].MENU = (Widget)NULL;
    }
  }

