/*------------------------------------------------------------\
|                                                             |
| Tool    :                     GSB                           |
|                                                             |
| File    :                  Gsbparse.h                       |
|                                                             |
| Authors :                Jacomme Ludovic                    |
|                                                             |
| Date    :                   01.08.93                        |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/

# ifndef GSB_PARSE
# define GSB_PARSE

# define GSB_MAX_BUFFER        255
# define GSB_MAX_KEYWORD       69

# define GSB_SEPARATORS_STRING " \t\n"
# define GSB_COMMENT_CHAR      '#'

/*------------------------------------------------------------\
|                                                             |
|                        Keyword Constants                    |
|                                                             |
\------------------------------------------------------------*/

# define DEFINE_KEYWORD               "DEFINE"
# define TABLE_KEYWORD                "TABLE" 
# define END_TABLE_KEYWORD            "END"
# define END_RECORD_KEYWORD           NULL

# define PEEK_BOUND_KEYWORD           "GRAAL_PEEK_BOUND"
# define LOWER_GRID_STEP_KEYWORD      "GRAAL_LOWER_GRID_STEP"
# define LOWER_FIGURE_STEP_KEYWORD    "GRAAL_LOWER_FIGURE_STEP"
# define LOWER_INSTANCE_STEP_KEYWORD  "GRAAL_LOWER_INSTANCE_STEP"
# define LOWER_CONNECTOR_STEP_KEYWORD "GRAAL_LOWER_CONNECTOR_STEP"
# define LOWER_SEGMENT_STEP_KEYWORD   "GRAAL_LOWER_SEGMENT_STEP"
# define LOWER_REFERENCE_STEP_KEYWORD "GRAAL_LOWER_REFERENCE_STEP"


# define SEGMENT_NAME_KEYWORD         "GRAAL_SEGMENT_NAME"
# define CONNECTOR_NAME_KEYWORD       "GRAAL_CONNECTOR_NAME"
# define SEGMENT_VALUE_KEYWORD        "GRAAL_SEGMENT_VALUE"
# define VIA_NAME_KEYWORD             "GRAAL_VIA_NAME"
# define REFERENCE_NAME_KEYWORD       "GRAAL_REFERENCE_NAME"
# define SYMMETRY_NAME_KEYWORD        "GRAAL_SYMMETRY_NAME"
# define ORIENT_NAME_KEYWORD          "GRAAL_ORIENT_NAME"
# define RDS_LAYER_NAME_KEYWORD       "GRAAL_RDS_LAYER_NAME"

# define GSB_SEGMENT_NAME_MASK           0x0001
# define GSB_SEGMENT_VALUE_MASK          0x0002
# define GSB_CONNECTOR_NAME_MASK         0x0004
# define GSB_VIA_NAME_MASK               0x0008
# define GSB_REFERENCE_NAME_MASK         0x0010
# define GSB_SYMMETRY_NAME_MASK          0x0020
# define GSB_ORIENT_NAME_MASK            0x0040
# define GSB_RDS_LAYER_NAME_MASK         0x0080
# define GSB_PEEK_BOUND_MASK             0x0100
# define GSB_LOWER_GRID_STEP_MASK        0x0200
# define GSB_LOWER_FIGURE_STEP_MASK      0x0400
# define GSB_LOWER_INSTANCE_STEP_MASK    0x0800
# define GSB_LOWER_REFERENCE_STEP_MASK   0x1000
# define GSB_LOWER_SEGMENT_STEP_MASK     0x2000
# define GSB_LOWER_CONNECTOR_STEP_MASK   0x4000

# define GSB_ALL_DEFINED_MASK            0x7FFF

/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/

  typedef struct keyword 
  {
    char *NAME; 
    char  VALUE;

  } keyword;

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/

# endif
