/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                 MbkRds.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <stdlib.h>
# include <signal.h>
# include <setjmp.h>
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RTL_H
# include RFM_H
# include GSB_H 
# include GRM_H
# include DRC_H
# include "GRM_error.h"
# include "GRM_window.h"
# include "GRM_mbkrds.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       For Set Long Jump                     |
|                                                             |
\------------------------------------------------------------*/

  static jmp_buf GraalJumpBuffer;
  static void    (*OldExitHandler)() = NULL;

/*------------------------------------------------------------\
|                                                             |
|                         Graal Figure                        |
|                                                             |
\------------------------------------------------------------*/

  rdsfig_list *GraalFigureRds     = (rdsfig_list *)NULL;
  graalconrec *GraalHeadConnector = (graalconrec *)NULL;
  phfig_list  *GraalFigureMbk     = (phfig_list  *)NULL;

/*------------------------------------------------------------\
|                                                             |
|                 Graal Exit Handler Functions                |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      GraalExitHandler                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalExitHandler()
  {
    GraalFlushErrorMessage();

    signal( SIGTERM, OldExitHandler );
    longjmp( GraalJumpBuffer, 1);
  }

/*------------------------------------------------------------\
|                                                             |
|                      GraalActiveExitHandler                 |
|                                                             |
\------------------------------------------------------------*/
  
  void GraalActiveExitHandler()
  {
    OldExitHandler = signal( SIGTERM, GraalExitHandler );
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalResetExitHandler                 |
|                                                             |
\------------------------------------------------------------*/
   
  void GraalResetExitHandler() 
  { 
    signal( SIGTERM, OldExitHandler );
  }

/*------------------------------------------------------------\
|                                                             |
|                     Graal Add Functions                     |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                     Graal Add Figure                        |
|                                                             |
\------------------------------------------------------------*/

  rdsfig_list *GraalAddFigure()

  {
    void        *Pointer;
    void        *Previous;

    GraalFigureRds = addrdsfig( GraalFigureMbk->NAME, GRAAL_SIZE );

    GraalCheckWindow();

    GraalAddAbox();

    Previous = (void *)(&(GraalFigureMbk->PHSEG));

    for ( Pointer  = (void *)(GraalFigureMbk->PHSEG);
          Pointer != (void *)NULL;
          Pointer  = (void *)(((phseg_list *)Pointer)->NEXT))
    {
      ((phseg_list *)Pointer)->USER = Previous;
      Previous = (void *)(&((phseg_list *)Pointer)->NEXT);

      GraalAddSegment( (phseg_list *)Pointer );
    }

    Previous = (void *)(&(GraalFigureMbk->PHCON));

    for ( Pointer  = (void *)(GraalFigureMbk->PHCON);
          Pointer != (void *)NULL;
          Pointer  = (void *)(((phcon_list *)Pointer)->NEXT))
    {
      ((phcon_list *)Pointer)->USER = Previous;
      Previous = (void *)(&((phcon_list *)Pointer)->NEXT);

      GraalAddConnector( (phcon_list *)Pointer );
    }

    Previous = (void *)(&(GraalFigureMbk->PHREF));
 
    for ( Pointer  = (void *)(GraalFigureMbk->PHREF);
          Pointer != (void *)NULL;
          Pointer  = (void *)(((phref_list *)Pointer)->NEXT))
    {
      ((phref_list *)Pointer)->USER = Previous;
      Previous = (void *)(&((phref_list *)Pointer)->NEXT);

      GraalAddReference( (phref_list *)Pointer );
    }
 
    Previous = (void *)(&(GraalFigureMbk->PHVIA));
 
    for ( Pointer  = (void *)(GraalFigureMbk->PHVIA);
          Pointer != (void *)NULL;
          Pointer  = (void *)(((phvia_list *)Pointer)->NEXT))
    {
      ((phvia_list *)Pointer)->USER = Previous;
      Previous = (void *)(&((phvia_list *)Pointer)->NEXT);

      GraalAddVia( (phvia_list *)Pointer );
    }
 
    Previous = (void *)(&(GraalFigureMbk->PHINS));
 
    for ( Pointer  = (void *)(GraalFigureMbk->PHINS);
          Pointer != (void *)NULL;
          Pointer  = (void *)(((phins_list *)Pointer)->NEXT))
    {
      ((phins_list *)Pointer)->USER = Previous;
      Previous = (void *)(&((phins_list *)Pointer)->NEXT);

      GraalAddInstance( (phins_list *)Pointer );
    }

    return( GraalFigureRds );
  }

/*------------------------------------------------------------\
|                                                             |
|                     Graal Add Instance                      |
|                                                             |
\------------------------------------------------------------*/

  rdsins_list *GraalAddInstance( InstanceMbk )

     phins_list *InstanceMbk;
  {
    rdsins_list *InstanceRds;
    rdsrec_list *Rectangle;
    char         Layer;
   
    delphfig( InstanceMbk->FIGNAME );

    if ( Graalgetphfig( InstanceMbk->FIGNAME, 'P' ) == (phfig_list *)NULL )
    {
      return( (rdsins_list *)NULL );
    }

    InstanceRds = insmbkrds( GraalFigureRds, InstanceMbk, 'P', 1 );
    InstanceRds->USER = (void *)(&GraalFigureRds->INSTANCE);

    if ( InstanceRds->NEXT != (rdsins_list *)NULL )
    {
      InstanceRds->NEXT->USER = (void *)(&InstanceRds->NEXT);
    }

    for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
    {
      for ( Rectangle  = InstanceRds->LAYERTAB[ Layer ];
            Rectangle != (rdsrec_list *)NULL;
            Rectangle  = Rectangle->NEXT )
      { 
        GRAAL_MBK( Rectangle )      = (void         *)InstanceMbk;
        GRAAL_PREVIOUS( Rectangle ) = (rdsrec_list **)InstanceRds;

        GraalInsertRectangle( Rectangle );
      } 
    } 

    return( InstanceRds );
  }

/*------------------------------------------------------------\
|                                                             |
|                     Graal Flat Instance                     |
|                                                             |
\------------------------------------------------------------*/
 
  rdsins_list *GraalFlatInstance( InstanceRds )
 
     rdsins_list *InstanceRds;
  {
    phfig_list  *ModelMbk;
    phins_list  *InstanceMbk;
    rdsrec_list *Rectangle;
    rdsrec_list *ScanRec;
    rdsrec_list *DelRec;
    char         Layer;

    ModelMbk = Graalgetphfig( InstanceRds->FIGNAME, 'A' );

    if ( ModelMbk == (phfig_list *)NULL )
    {
      return( (rdsins_list *)NULL );
    }

    ModelMbk = Graalrflattenphfig( ModelMbk, YES, NO  );

    if ( ModelMbk == (phfig_list *)NULL )
    {
      return( (rdsins_list *)NULL );
    }

    for ( Layer = 0; Layer < RDS_ABOX; Layer++ )
    {
      ScanRec = InstanceRds->LAYERTAB[ Layer ];

      InstanceRds->LAYERTAB[ Layer ] = (rdsrec_list *)NULL;

      while( ScanRec != (rdsrec_list *)NULL )
      {
        DelRec  = ScanRec;
        ScanRec = ScanRec->NEXT;

        GraalEraseRectangle( DelRec );

        freerdsrec( DelRec, GRAAL_SIZE );
      }
    }

    ScanRec = InstanceRds->LAYERTAB[ RDS_ABOX ];

    SetGraalFlatten( ScanRec );

    InstanceMbk = (phins_list *)GRAAL_MBK( ScanRec );

    inssegmbkrds( InstanceMbk, ModelMbk, InstanceRds, 1 );
    insconmbkrds( InstanceMbk, ModelMbk, InstanceRds    );
    insrefmbkrds( InstanceMbk, ModelMbk, InstanceRds    );
    insviambkrds( InstanceMbk, ModelMbk, InstanceRds    );

    for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
    {
      for ( ScanRec  = InstanceRds->LAYERTAB[ Layer ];
            ScanRec != (rdsrec_list *)NULL;
            ScanRec  = ScanRec->NEXT )
      {
        GRAAL_MBK( ScanRec )      = (void         *)InstanceMbk;
        GRAAL_PREVIOUS( ScanRec ) = (rdsrec_list **)InstanceRds;
 
        GraalInsertRectangle( ScanRec );
      }
    }

    delphfig( ModelMbk->NAME );

    return( InstanceRds );
  }

/*------------------------------------------------------------\
|                                                             |
|                   Graal Unflat Instance                     |
|                                                             |
\------------------------------------------------------------*/
 
  rdsins_list *GraalUnflatInstance( InstanceRds )
 
     rdsins_list *InstanceRds;
  {
    phfig_list  *ModelMbk;
    phins_list  *InstanceMbk;
    rdsrec_list *Rectangle;
    rdsrec_list *ScanRec;
    rdsrec_list *DelRec;
    char         Layer;

    delphfig( InstanceRds->FIGNAME );

    ModelMbk = Graalgetphfig( InstanceRds->FIGNAME, 'P' );

    if ( ModelMbk == (phfig_list *)NULL )
    {
      return( (rdsins_list *)NULL );
    }

    for ( Layer = 0; Layer < RDS_ABOX; Layer++ )
    {
      ScanRec = InstanceRds->LAYERTAB[ Layer ];

      InstanceRds->LAYERTAB[ Layer ] = (rdsrec_list *)NULL;

      while( ScanRec != (rdsrec_list *)NULL )
      {
        DelRec  = ScanRec;
        ScanRec = ScanRec->NEXT;

        GraalEraseRectangle( DelRec );

        freerdsrec( DelRec, GRAAL_SIZE );
      }
    }

    ScanRec = InstanceRds->LAYERTAB[ RDS_ABOX ];

    ClearGraalFlatten( ScanRec );

    InstanceMbk = (phins_list *)GRAAL_MBK( ScanRec );

    inssegmbkrds( InstanceMbk, ModelMbk, InstanceRds, 1 );
    insconmbkrds( InstanceMbk, ModelMbk, InstanceRds    );
    insrefmbkrds( InstanceMbk, ModelMbk, InstanceRds    );
    insviambkrds( InstanceMbk, ModelMbk, InstanceRds    );

    for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
    {
      for ( ScanRec  = InstanceRds->LAYERTAB[ Layer ];
            ScanRec != (rdsrec_list *)NULL;
            ScanRec  = ScanRec->NEXT )
      {
        GRAAL_MBK( ScanRec )      = (void         *)InstanceMbk;
        GRAAL_PREVIOUS( ScanRec ) = (rdsrec_list **)InstanceRds;
 
        GraalInsertRectangle( ScanRec );
      }
    }

    delphfig( ModelMbk->NAME );
 
    return( InstanceRds );
  }

/*------------------------------------------------------------\
|                                                             |
|                     Graal Add Segment                       |
|                                                             |
\------------------------------------------------------------*/

  rdsrec_list *GraalAddSegment( SegmentMbk )

     phseg_list *SegmentMbk;
  {
    rdsrec_list  *ScanRec;
    rdsrec_list  *ScanPrev;
    rdsrec_list  *FirstRec;
    rdsrec_list **Previous;

    ScanRec = FirstRec = segmbkrds( GraalFigureRds, SegmentMbk, 1 );

    if ( FirstRec == (rdsrec_list *)NULL ) return( FirstRec );
    
    do 
    {
      GRAAL_MBK( ScanRec ) = (void *)SegmentMbk;

      GraalInsertRectangle( ScanRec );

      if ( GRAAL_PREVIOUS( ScanRec ) == (rdsrec_list **)NULL )
      {
        Previous = &(GraalFigureRds->LAYERTAB[ GetRdsLayer( ScanRec ) ]);

        for ( ScanPrev  = *Previous;
              ScanPrev != ScanRec;
              ScanPrev  = ScanPrev->NEXT )
        {
          if ( GRAAL_PREVIOUS( ScanPrev ) == (rdsrec_list **)NULL )
          {
            GRAAL_PREVIOUS( ScanPrev ) = Previous;
          }
  
          Previous = &ScanPrev->NEXT;
        }

        GRAAL_PREVIOUS( ScanRec ) = Previous;
  
        ScanPrev = ScanPrev->NEXT;
  
        if ( ( ScanPrev                   != (rdsrec_list  *)NULL ) &&
             ( GRAAL_PREVIOUS( ScanPrev ) != (rdsrec_list **)NULL ) )
        {
          GRAAL_PREVIOUS( ScanPrev ) = &ScanRec->NEXT;
        }
      }

      ScanRec = (rdsrec_list *)ScanRec->USER;
    }
    while ( ScanRec != FirstRec );

    return( FirstRec );
  }

/*------------------------------------------------------------\
|                                                             |
|                     Graal Add Connector                     |
|                                                             |
\------------------------------------------------------------*/
 
  rdsrec_list *GraalAddConnector( ConnectorMbk )

     phcon_list *ConnectorMbk;
  {
    rdsrec_list  *Rectangle;

    Rectangle = conmbkrds( GraalFigureRds, ConnectorMbk );
    
    if ( Rectangle == (rdsrec_list *)NULL ) return( Rectangle );
    
    GraalAddConRec( Rectangle );

    GRAAL_MBK( Rectangle ) = (void *)ConnectorMbk;

    GraalInsertRectangle( Rectangle );

    GRAAL_PREVIOUS( Rectangle ) = 
  
      &(GraalFigureRds->LAYERTAB[ GetRdsLayer( Rectangle ) ]);

    if ( Rectangle->NEXT != (rdsrec_list *)NULL )
    {
      GRAAL_PREVIOUS( Rectangle->NEXT ) = &Rectangle->NEXT;
    }

    return( Rectangle );
  }

/*------------------------------------------------------------\
|                                                             |
|                        Graal Add Via                        |
|                                                             |
\------------------------------------------------------------*/

  rdsrec_list *GraalAddVia( ViaMbk )

     phvia_list *ViaMbk;
  {
    rdsrec_list  *ScanRec;
    rdsrec_list  *ScanPrev;
    rdsrec_list  *FirstRec;
    rdsrec_list **Previous;

    ScanRec = FirstRec = viambkrds( GraalFigureRds, ViaMbk );

    if ( FirstRec == (rdsrec_list *)NULL ) return( FirstRec );

    do 
    {
      GRAAL_MBK( ScanRec ) = (void *)ViaMbk;

      GraalInsertRectangle( ScanRec );

      if ( GRAAL_PREVIOUS( ScanRec ) == (rdsrec_list **)NULL )
      {
        Previous = &(GraalFigureRds->LAYERTAB[ GetRdsLayer( ScanRec ) ]);

        for ( ScanPrev  = *Previous;
              ScanPrev != ScanRec;
              ScanPrev  = ScanPrev->NEXT )
        {
          if ( GRAAL_PREVIOUS( ScanPrev ) == (rdsrec_list **)NULL )
          {
            GRAAL_PREVIOUS( ScanPrev ) = Previous;
          }
  
          Previous = &ScanPrev->NEXT;
        }

        GRAAL_PREVIOUS( ScanRec ) = Previous;
  
        ScanPrev = ScanPrev->NEXT;
  
        if ( ( ScanPrev                   != (rdsrec_list  *)NULL ) &&
             ( GRAAL_PREVIOUS( ScanPrev ) != (rdsrec_list **)NULL ) )
        {
          GRAAL_PREVIOUS( ScanPrev ) = &ScanRec->NEXT;
        }
      }

      ScanRec = (rdsrec_list *)ScanRec->USER;
    }
    while ( ScanRec != FirstRec );

    return( FirstRec );
  }

/*------------------------------------------------------------\
|                                                             |
|                     Graal Add Reference                     |
|                                                             |
\------------------------------------------------------------*/
 
  rdsrec_list *GraalAddReference( ReferenceMbk )

     phref_list *ReferenceMbk;
  {
    rdsrec_list  *Rectangle;

    Rectangle = refmbkrds( GraalFigureRds, ReferenceMbk );
    
    if ( Rectangle == (rdsrec_list *)NULL ) return( Rectangle );
    
    GRAAL_MBK( Rectangle ) = (void *)ReferenceMbk;

    GraalInsertRectangle( Rectangle );

    GRAAL_PREVIOUS( Rectangle ) = 
  
      &(GraalFigureRds->LAYERTAB[ GetRdsLayer( Rectangle ) ]);

    if ( Rectangle->NEXT != (rdsrec_list *)NULL )
    {
      GRAAL_PREVIOUS( Rectangle->NEXT ) = &Rectangle->NEXT;
    }

    return( Rectangle );
  }

/*------------------------------------------------------------\
|                                                             |
|                       Graal Add Abox                        |
|                                                             |
\------------------------------------------------------------*/

  rdsrec_list *GraalAddAbox()

  {
    rdsrec_list *Rectangle;

    Rectangle = aboxmbkrds( GraalFigureMbk, GraalFigureRds );

    if ( Rectangle != (rdsrec_list *)NULL )
    {
      GRAAL_PREVIOUS( Rectangle ) =

        &(GraalFigureRds->LAYERTAB[ RDS_ABOX ]);

      if ( Rectangle->NEXT != (rdsrec_list *)NULL )
      {
        GRAAL_PREVIOUS( Rectangle->NEXT ) = &Rectangle->NEXT;
      }

      GRAAL_MBK( Rectangle ) = (void *)GraalFigureMbk;

      GraalInsertRectangle( Rectangle );
    }
   
    return( Rectangle );
  }

/*------------------------------------------------------------\
|                                                             |
|                    Graal Delete Functions                   |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                      Graal Del Figure                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalDelFigure()

  {
    char         Layer;
    rdsrec_list *DelRec;
    rdsrec_list *ScanRec;
    rdsins_list *ScanIns;
    rdsins_list *DelIns;
    graalrecwin *RecWin;

    for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
    {
      ScanRec  = GraalFigureRds->LAYERTAB[ Layer ];  

      while ( ScanRec != (rdsrec_list *)NULL )
      {
        DelRec   = ScanRec;
        ScanRec  = ScanRec->NEXT;

        GraalEraseRecWin( DelRec );

        freerdsrec( DelRec, GRAAL_SIZE );
      }

      GraalFigureRds->LAYERTAB[ Layer ] = (rdsrec_list *)NULL;
    }

    ScanIns  = GraalFigureRds->INSTANCE;

    while ( ScanIns != (rdsins_list *)NULL )
    {
      DelIns   = ScanIns;
      ScanIns  = ScanIns->NEXT;

      for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
      {
        ScanRec  = GraalFigureRds->LAYERTAB[ Layer ];  

        while ( ScanRec != (rdsrec_list *)NULL )
        {
          DelRec   = ScanRec;
          ScanRec  = ScanRec->NEXT;

          GraalEraseRecWin( DelRec );
        
          freerdsrec( DelRec, GRAAL_SIZE );
        }
      }

      freerdsins( DelIns );
    }

    GraalFigureRds->INSTANCE = (rdsins_list *)NULL;

    delrdsfig( GraalFigureRds      );
    delphfig( GraalFigureMbk->NAME );

    GraalDelAllConRec();

    GraalFigureRds = (rdsfig_list *)NULL;
    GraalFigureMbk = (phfig_list  *)NULL;

    GraalEraseWindow();
  }

/*------------------------------------------------------------\
|                                                             |
|                      Graal Del Instance                     |
|                                                             |
\------------------------------------------------------------*/

 void GraalDelInstance( InstanceRds )

    rdsins_list *InstanceRds;
 {
   phins_list  *InstanceMbk;
   rdsrec_list *ScanRec;
   rdsrec_list *DelRec;
   char         Layer;

   *(rdsins_list **)(InstanceRds->USER) = InstanceRds->NEXT; 

   if ( InstanceRds->NEXT != (rdsins_list *)NULL )
   {
     InstanceRds->NEXT->USER = InstanceRds->USER;
   }

   InstanceMbk = (phins_list *)GRAAL_MBK( InstanceRds->LAYERTAB[ RDS_ABOX ] );

   *(phins_list **)(InstanceMbk->USER) = InstanceMbk->NEXT;

   if ( InstanceMbk->NEXT != (phins_list *)NULL )
   {
     InstanceMbk->NEXT->USER = InstanceMbk->USER;
   }

   for ( Layer = 0; Layer < RDS_MAX_LAYER; Layer++ )
   {
     ScanRec = InstanceRds->LAYERTAB[ Layer ];

     while( ScanRec != (rdsrec_list *)NULL )
     {
       DelRec  = ScanRec;
       ScanRec = ScanRec->NEXT;

       GraalEraseRectangle( DelRec );

       freerdsrec( DelRec, GRAAL_SIZE );
     }
   }

   freerdsins( InstanceRds );
   mbkfree( InstanceMbk );
 }

/*------------------------------------------------------------\
|                                                             |
|                      Graal Del Rectangle                    |
|                                                             |
\------------------------------------------------------------*/

  void GraalDelRectangle( Rectangle )

    rdsrec_list *Rectangle;
  {
    rdsrec_list *ScanRec;
    rdsrec_list *DelRec;
    void        *Pointer;

    Pointer = GRAAL_MBK( Rectangle );

    if ( IsRdsSegment( Rectangle ) )
    { 
      *((phseg_list **)(((phseg_list *)Pointer)->USER)) = ((phseg_list *)Pointer)->NEXT;
  
      if ( ((phseg_list *)Pointer)->NEXT != (phseg_list *)NULL )
      {
        ((phseg_list *)Pointer)->NEXT->USER = ((phseg_list *)Pointer)->USER;
      }

      mbkfree( Pointer );
    }
    else
    if ( IsRdsVia( Rectangle ) )
    {
      *(phvia_list **)(((phvia_list *)Pointer)->USER) = ((phvia_list *)Pointer)->NEXT;

      if (((phvia_list *)Pointer)->NEXT != (phvia_list *)NULL )
      {
        ((phvia_list *)Pointer)->NEXT->USER = ((phvia_list *)Pointer)->USER;
      }

      mbkfree( Pointer );
    }
    else
    if ( IsRdsConnector( Rectangle ) )
    { 
      *(phcon_list **)(((phcon_list *)Pointer)->USER) = ((phcon_list *)Pointer)->NEXT;

      if (((phcon_list *)Pointer)->NEXT != (phcon_list *)NULL )
      {
        ((phcon_list *)Pointer)->NEXT->USER = ((phcon_list *)Pointer)->USER;
      }

      GraalDelConRec( Rectangle );
  
      mbkfree( Pointer );
    }
    else
    if ( IsRdsReference( Rectangle ) )
    {
      *(phref_list **)(((phref_list *)Pointer)->USER) = ((phref_list *)Pointer)->NEXT;
  
      if (((phref_list *)Pointer)->NEXT != (phref_list *)NULL )
      {
        ((phref_list *)Pointer)->NEXT->USER = ((phref_list *)Pointer)->USER;
      }

      mbkfree( Pointer );
    }
    if ( IsRdsFigure( Rectangle ) )
    {
      if ( GraalFigureRds->LAYERTAB[ RDS_ABOX ] == Rectangle )
      {
        GraalFigureMbk->XAB1 = 0;
        GraalFigureMbk->YAB1 = 0;
        GraalFigureMbk->XAB2 = 0;
        GraalFigureMbk->YAB2 = 0;
      }
    }

    ScanRec = Rectangle;

    do
    {
      DelRec  = ScanRec;
      ScanRec = (rdsrec_list *)(ScanRec->USER);

      *(GRAAL_PREVIOUS( DelRec )) = DelRec->NEXT;

      if ( DelRec->NEXT != (rdsrec_list *)NULL )
      {
        GRAAL_PREVIOUS( DelRec->NEXT ) = GRAAL_PREVIOUS( DelRec );
      }

      GraalEraseRectangle( DelRec );

      freerdsrec( DelRec, GRAAL_SIZE );
    }
    while ( ScanRec != Rectangle );
  }

/*------------------------------------------------------------\
|                                                             |
|                      Graal Save Figure                      |
|                                                             |
\------------------------------------------------------------*/

 char GraalSaveFigure()

 {
   graalundo     *ScanUndo;
   graalundorec  *ScanUndoRec;
   graalundorec **PrevUndoRec;
   rdsrec_list   *ScanRec;
   rdsrec_list   *DelRec;
   void          *Pointer;
   graalundorec  *HeadDelete;
   graalundorec *Delete;

   phseg_list   *Segment;

   if ( GraalHeadUndo != (graalundo *)NULL )
   {
     HeadDelete = (graalundorec *)NULL;

     for ( ScanUndo  = GraalHeadUndo; 
           ScanUndo != (graalundo *)NULL;
           ScanUndo  = ScanUndo->NEXT )
     {
       ScanUndoRec  = ScanUndo->UNDO;
       PrevUndoRec  = &ScanUndo->UNDO;

       while( ScanUndoRec != (graalundorec *)NULL )
       {
         ScanRec = ScanUndoRec->RECTANGLE; 
  
         if ( IsGraalDeleted( ScanRec ) )
         {
           GraalUndeleteRectangle( ScanRec );

           Delete       = ScanUndoRec;
           *PrevUndoRec = ScanUndoRec->NEXT;
           ScanUndoRec  = ScanUndoRec->NEXT;
           Delete->NEXT = HeadDelete;
           HeadDelete   = Delete;
         }
         else
         {
           PrevUndoRec  = &ScanUndoRec->NEXT;
           ScanUndoRec  = ScanUndoRec->NEXT;
         }
       }
     }

     while( HeadDelete != (graalundorec *)NULL )
     {
       Delete     = HeadDelete;
       HeadDelete = HeadDelete->NEXT;

       if ( IsRdsInstance( Delete->RECTANGLE ) )
       {
         GraalDelInstance( GRAAL_PREVIOUS( Delete->RECTANGLE ) );
       }
       else
       {
         GraalDelRectangle( Delete->RECTANGLE );
       }

       GraalFreeUndoRec( Delete );
     }
   }

   return( Graalsavephfig( GraalFigureMbk ) );
 }

/*------------------------------------------------------------\
|                                                             |
|                     Graalgetphfig                           |
|                                                             |
\------------------------------------------------------------*/

  phfig_list *Graalgetphfig( FigureName, Mode )

     char *FigureName;
     char  Mode;
  {
    phfig_list *FigureMbk;

    GraalActiveExitHandler();

    if ( setjmp( GraalJumpBuffer ) == 0 )
    {
      FigureMbk = getphfig( FigureName, Mode );

      GraalResetExitHandler();

      if ( ( FigureMbk->XAB1 == FigureMbk->XAB2 ) &&
           ( FigureMbk->YAB1 == FigureMbk->YAB2 ) ) 
      {
        FigureMbk->XAB1 = 0;
        FigureMbk->XAB2 = 0;
        FigureMbk->YAB1 = 0;
        FigureMbk->YAB2 = 0;
      }

      return( FigureMbk );
    }
    else
    {
      delphfig( FigureName );

      return( (phfig_list *)NULL );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     Graalrflattenphfig                      |
|                                                             |
\------------------------------------------------------------*/

  phfig_list *Graalrflattenphfig( FigureMbk, Concat, Catal )

     phfig_list *FigureMbk;
     char        Concat;
     char        Catal;
  {
    GraalActiveExitHandler();

    if ( setjmp( GraalJumpBuffer ) == 0 )
    {
      rflattenphfig( FigureMbk, Concat, Catal );

      GraalResetExitHandler();

      return( FigureMbk );
    }
    else
    {
      return( (phfig_list *)NULL );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                      Graalflattenphfig                      |
|                                                             |
\------------------------------------------------------------*/

  phfig_list *Graalflattenphfig( FigureMbk, Name, Concat )

     phfig_list *FigureMbk;
     char       *Name;
     char        Concat;
  {
    GraalActiveExitHandler();

    if ( setjmp( GraalJumpBuffer ) == 0 )
    {
      flattenphfig( FigureMbk, Name, Concat );

      GraalResetExitHandler();

      return( FigureMbk );
    }
    else
    {
      return( (phfig_list *)NULL );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     Graalsavephfig                          |
|                                                             |
\------------------------------------------------------------*/

  char Graalsavephfig( FigureMbk )

     phfig_list *FigureMbk;
  {
    GraalActiveExitHandler();

    if ( setjmp( GraalJumpBuffer ) == 0 )
    {
      savephfig( FigureMbk );

      GraalResetExitHandler();
 
      return( GRAAL_TRUE );
    }
    else
    {
      return( GRAAL_FALSE );
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                     Graaldrucrdsfig                         |
|                                                             |
\------------------------------------------------------------*/

  rdsfig_list *Graaldrucrdsfig( Figure )

     rdsfig_list *Figure;
  {
    rdsfig_list *FigureError;

    GraalActiveExitHandler();

    if ( setjmp( GraalJumpBuffer ) == 0 )
    {
      FigureError = drucrdsfig( Figure, 
                                RDS_TECHNO_NAME,
                                "_druc_err_" );
      GraalResetExitHandler();

      return( FigureError );
    }
    else
    {
      delrdsfig( Figure->NAME );

      return( (rdsfig_list *)NULL );
    }
  }
