/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                 Connector.c                       |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include RFM_H
# include GRM_H
# include GSB_H
# include "GRM_connector.h"

/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  graalconrec *GraalHeadConRec = (graalconrec *)NULL;

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                       Alloc Functions                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                        GraalAllocConRec                     |
|                                                             |
\------------------------------------------------------------*/

   graalconrec *GraalAllocConRec()
   {
     return((graalconrec *)rdsalloc(sizeof(graalconrec), 1));
   }

/*------------------------------------------------------------\
|                                                             |
|                        Free Functions                       |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                         GraalFreeConRec                     |
|                                                             |
\------------------------------------------------------------*/
  
  void GraalFreeConRec( FreeConRec )

     graalconrec *FreeConRec;
  {
    rdsfree((char *)FreeConRec, sizeof(graalconrec));
  }

/*------------------------------------------------------------\
|                                                             |
|                       GraalDelAllConRec                     |
|                                                             |
\------------------------------------------------------------*/

  void GraalDelAllConRec()

  {
    graalconrec *ConRec;
    graalconrec *DelConRec;

    ConRec = GraalHeadConRec;

    while ( ConRec != (graalconrec *)NULL )
    {
      DelConRec = ConRec;
      ConRec    = ConRec->NEXT;

      GraalFreeConRec( DelConRec );
    }

    GraalHeadConRec = (graalconrec *)NULL;
  }

/*------------------------------------------------------------\
|                                                             |
|                        GraalDelConRec                       |
|                                                             |
\------------------------------------------------------------*/

  void GraalDelConRec( Rectangle )
    
    rdsrec_list *Rectangle;
  {
    rdsrec_list  *ScanRec;
    graalconrec  *ConRec;
    graalconrec **Previous;

    Previous = &GraalHeadConRec;

    for ( ConRec  = GraalHeadConRec;
          ConRec != (graalconrec *)NULL;
          ConRec  = ConRec->NEXT )
    {
      ScanRec = Rectangle;

      do
      {
        if ( ConRec->RECTANGLE == ScanRec )
        {
          *Previous = ConRec->NEXT;

          GraalFreeConRec( ConRec );

          return;
        }

        ScanRec = (rdsrec_list *)ScanRec->USER;
      }
      while ( ScanRec != Rectangle );

      Previous = &ConRec->NEXT;
    }
  }

/*------------------------------------------------------------\
|                                                             |
|                         GraalAddConRec                      |
|                                                             |
\------------------------------------------------------------*/

  void GraalAddConRec( Rectangle )
    
    rdsrec_list *Rectangle;
  {
    graalconrec *ConRec;

    ConRec = GraalAllocConRec();

    ConRec->NEXT      = GraalHeadConRec;
    ConRec->RECTANGLE = Rectangle; 
    GraalHeadConRec   = ConRec;
  }
