/*------------------------------------------------------------\
|                                                             |
| Tool    :                   GRAAL                           |
|                                                             |
| File    :                  Motif.c                          |
|                                                             |
| Authors :      Venot Frederic and Jacomme Ludovic           |
|                                                             |
| Date    :                  01.08.93                         |
|                                                             |
\------------------------------------------------------------*/

/*------------------------------------------------------------\
|                                                             |
|                         Include Files                       |
|                                                             |
\------------------------------------------------------------*/

# include <stdio.h>
# include <Xm/Xm.h>
# include <Xm/Form.h>
# include <Xm/Frame.h>
# include <Xm/MainW.h>
 
# include MUT_H
# include MPH_H
# include RDS_H
# include RPR_H
# include GTB_H
# include GSB_H
# include GMX_H

# include "GMX_motif.h"
# include "GMX_graphic.h" 
# include "GMX_event.h" 
# include "GMX_message.h" 
# include "GMX_menu.h" 
# include "GMX_color.h" 
# include "GMX_panel.h"
# include "GMX_dialog.h"

/*------------------------------------------------------------\
|                                                             |
|                           Constants                         |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                            Types                            |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                          Variables                          |
|                                                             |
\------------------------------------------------------------*/

  XtAppContext  GraalApplication;
  Widget        GraalTopLevel;
  Widget        GraalMainWindow;
  Widget        GraalMainForm;
 
  static String GraalFallBacks [] =

         {
           "*.GraalMainWindow.title    : Graal",
           "*.GraalMainWindow.iconName : Graal",
           "*GraalMenuBar*fontList     : -*-helvetica-bold-r-*--14-*", 
           "*foreground                : black",
           "*background                : gray",
           "*fontList                  : -*-helvetica-medium-r-*--12-*",
           NULL
         };

/*------------------------------------------------------------\
|                                                             |
|                          Functions                          |
|                                                             |
\------------------------------------------------------------*/
/*------------------------------------------------------------\
|                                                             |
|                   GraalInitializeRessources                 |
|                                                             |
\------------------------------------------------------------*/

  void GraalInitializeRessources( argc, argv )

       int  *argc;
       char *argv[];
  {
    Arg Args[ 1 ];

    GraalTopLevel = XtVaAppInitialize(
                                       &GraalApplication,
                                       "graal.xrdb",
                                       NULL,
                                       0,
                                       argc,
                                       argv,
                                       GraalFallBacks,
                                       NULL 
                                     );

    XtVaSetValues ( GraalTopLevel,
                    XmNheight    , GRAAL_TOPLEVEL_HEIGHT,
                    XmNwidth     , GRAAL_TOPLEVEL_WIDTH,
                    XmNminHeight , GRAAL_TOPLEVEL_MIN_HEIGHT,
                    XmNminWidth  , GRAAL_TOPLEVEL_MIN_WIDTH ,
                    XmNx         , GRAAL_TOPLEVEL_X,
                    XmNy         , GRAAL_TOPLEVEL_Y,
                    NULL
                  );

    GraalMainWindow = XtVaCreateManagedWidget( "GraalMainWindow",
                                               xmMainWindowWidgetClass,
                                               GraalTopLevel,
                                               NULL);

    GraalMainForm = XtVaCreateManagedWidget( "GraalMainForm",
                                             xmFormWidgetClass,
                                             GraalMainWindow,
                                             XmNfractionBase,
                                             200,
                                             NULL );

    GraalInitializeIcon();
    GraalInitializeMenu();
    GraalInitializeMessage();
    GraalInitializePanel(); 
    GraalInitializeGraphic();
    GraalInitializeEvent();
    GraalBuildPanelMap();
    GraalInitializeMapEvent();
    GraalInitializeColors();
    GraalInitializeGraphicContext();
    GraalInitializeDialog();
    GraalBuildPanelLibrary();

    XtSetArg( Args[0], XmNallowShellResize, True ); 
    XtSetValues( GraalTopLevel, Args, 1 );
 
    XtRealizeWidget( GraalTopLevel );
 }
